/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.CInteger;
import com.sun.hadb.comm.CommException;
import com.sun.hadb.comm.CommLogFactory;
import com.sun.hadb.comm.EndPoint;
import com.sun.hadb.comm.MessageBuffer;
import com.sun.hadb.comm.MessageChunk;
import com.sun.hadb.comm.MessageChunkByteBuffer;
import com.sun.hadb.comm.MsgBufferPool;
import com.sun.hadb.comm.MsgChannel;
import com.sun.hadb.comm.MsgChannelImpl;
import com.sun.hadb.comm.MsgReceiver;
import com.sun.hadb.comm.MsgRetransmitter;
import com.sun.hadb.comm.PacketDump;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.DatagramChannel;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MsgManager {
    static final int CLU_UDP_MSGSIZE = 32768;
    static final int RCV_SNDBUF_SIZE = 65536;
    Thread retrThread = null;
    Thread recThread = null;
    private static MsgManager this_instance = new MsgManager();
    private Hashtable endpoint_table = null;
    private Hashtable connection_table = null;
    private DatagramChannel channel = null;
    private MsgReceiver receiver;
    private MsgRetransmitter retransmitter;
    private Logger logger = CommLogFactory.getCommLogger();
    private boolean acceptConnect = false;
    private CInteger lastConnectionId;
    private long packetSent = 0L;
    private long dataSent = 0L;
    private long packetRecv = 0L;
    private long dataRecv = 0L;

    private MsgManager() {
        this.connection_table = new Hashtable();
        this.endpoint_table = new Hashtable();
        this.lastConnectionId = new CInteger(0xFFFFFFFFL);
        this.lastConnectionId.setValue(System.currentTimeMillis() % 0xFFFFFFFFL);
        this.validateChannel();
        this.logger.finest("Starting MSG receive thread");
        this.receiver = new MsgReceiver(this);
        this.recThread = new Thread((Runnable)this.receiver, "MSG RECV");
        this.recThread.setDaemon(true);
        this.recThread.start();
        this.logger.finest("Starting MSG retransmission thread");
        this.retransmitter = new MsgRetransmitter(this);
        this.retrThread = new Thread((Runnable)this.retransmitter, "MSG RETRANS");
        this.retrThread.setDaemon(true);
        this.retrThread.start();
    }

    private synchronized void validateChannel() {
        if (this.channel != null && this.channel.isOpen()) {
            return;
        }
        try {
            this.endpoint_table.clear();
            this.logger.fine("Opening a DatagramChannel.");
            this.channel = DatagramChannel.open();
        }
        catch (IOException e) {
            RuntimeException re = new RuntimeException("[Clustra JDBC Driver] Could not create UDP channel ");
            re.initCause(e);
            throw re;
        }
        try {
            int rcvbuf_old = this.channel.socket().getReceiveBufferSize();
            int sndbuf_old = this.channel.socket().getSendBufferSize();
            this.channel.socket().setReceiveBufferSize(65536);
            this.channel.socket().setSendBufferSize(65536);
            int rcvbuf_new = this.channel.socket().getReceiveBufferSize();
            int sndbuf_new = this.channel.socket().getSendBufferSize();
            this.logger.finest("Adjusting SO_RCVBUF: " + rcvbuf_old + " -> " + rcvbuf_new);
            this.logger.finest("Adjusting SO_SNDBUF: " + sndbuf_old + " -> " + sndbuf_new);
        }
        catch (SocketException e) {
            RuntimeException re = new RuntimeException("[Clustra JDBC Driver] Could not create socket");
            re.initCause(e);
            this.logger.log(Level.FINE, "Socket creation failed", re);
            throw re;
        }
    }

    public static synchronized MsgManager getInstance() {
        if (this_instance == null) {
            this_instance = new MsgManager();
        }
        return this_instance;
    }

    public void acceptConnections() {
        this.acceptConnect = true;
    }

    public synchronized MsgChannel openChannel(EndPoint endpoint) throws CommException {
        MsgChannelImpl channel = (MsgChannelImpl)this.endpoint_table.get(endpoint);
        if (channel == null) {
            long cid = 0L;
            while (cid == 0L) {
                this.lastConnectionId.inc();
                cid = this.lastConnectionId.getValue();
            }
            channel = new MsgChannelImpl(this, cid, endpoint);
            Long cidObj = new Long(cid);
            this.connection_table.put(cidObj, channel);
            this.endpoint_table.put(endpoint, channel);
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("MsgManager: open channel: " + endpoint.toString() + " cid: " + cid);
            }
        }
        channel.open();
        return channel;
    }

    public void close() {
        this.retransmitter.close();
        this.receiver.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(EndPoint endpoint, MessageBuffer buffer) throws CommException {
        ByteBuffer sendBuffer = MsgBufferPool.getInstance().getMsgBuffer();
        buffer.getBufferNIODirect(sendBuffer);
        sendBuffer.flip();
        if (this.logger.isLoggable(Level.FINEST)) {
            PacketDump.dumpPacket(sendBuffer, endpoint, 2);
        }
        InetSocketAddress addr = new InetSocketAddress(endpoint.getAddress(), endpoint.getPort());
        try {
            int byteSent = this.channel.send(sendBuffer, addr);
            ++this.packetSent;
            this.dataSent += (long)byteSent;
        }
        catch (ClosedByInterruptException ce) {
            CommException cc = new CommException(24);
            cc.initCause(ce);
            throw cc;
        }
        catch (IOException ie) {
            this.logger.log(Level.FINE, "DatagramChannel.send() returned exception", ie);
        }
        finally {
            MsgBufferPool.getInstance().returnMsgBuffer(sendBuffer);
        }
    }

    void receive_handler() {
        try {
            ByteBuffer recvBuffer = MsgBufferPool.getInstance().getMsgBuffer();
            recvBuffer.clear();
            this.validateChannel();
            InetSocketAddress sa = (InetSocketAddress)this.channel.receive(recvBuffer);
            if (recvBuffer.position() > 0) {
                EndPoint endpoint = new EndPoint(sa.getAddress(), sa.getPort());
                ++this.packetRecv;
                this.dataRecv += (long)recvBuffer.position();
                recvBuffer.flip();
                if (this.logger.isLoggable(Level.FINEST)) {
                    PacketDump.dumpPacket(recvBuffer, endpoint, 1);
                }
                MessageBuffer buffer = new MessageBuffer();
                MessageChunkByteBuffer chunk = new MessageChunkByteBuffer(recvBuffer);
                buffer.append(chunk);
                int version = ((MessageChunk)chunk).getUInt8(0);
                recvBuffer = null;
                if (version == 4 || version == 5) {
                    MsgChannelImpl msgchannel;
                    long cid = 0L;
                    if (version == 5) {
                        cid = ((MessageChunk)chunk).getUInt32(23);
                    }
                    if ((msgchannel = cid != 0L ? (MsgChannelImpl)this.connection_table.get(new Long(cid)) : (MsgChannelImpl)this.endpoint_table.get(endpoint)) == null) {
                        try {
                            if (this.acceptConnect) {
                                msgchannel = (MsgChannelImpl)this.openChannel(endpoint);
                                this.logger.finest("MsgManager.receive_handler: opened MsgChannel for incomming message: " + endpoint.toString());
                            }
                        }
                        catch (CommException e) {
                            this.logger.log(Level.FINE, "Failed to create message channel to " + endpoint.toString(), e);
                        }
                    }
                    if (msgchannel != null) {
                        msgchannel.receive_handler(buffer);
                        buffer = null;
                        recvBuffer = null;
                    } else if (this.logger.isLoggable(Level.FINER)) {
                        this.logger.finer("MsgManager.receive_handler: Did not find channel: " + endpoint.toString() + " CID: " + cid);
                    }
                } else {
                    this.logger.fine("MsgManager.receive_handler: illegal message version: " + version);
                }
                if (buffer != null) {
                    buffer.close();
                }
            } else {
                this.logger.fine("Packet was empty");
            }
            if (recvBuffer != null) {
                MsgBufferPool.getInstance().returnMsgBuffer(recvBuffer);
                recvBuffer = null;
            }
        }
        catch (ClosedByInterruptException cbie) {
            this.logger.log(Level.INFO, "ClosedByInterruptException - reconnect channel", cbie);
            Thread.currentThread();
            Thread.interrupted();
            this.channel.socket().close();
            try {
                this.channel.close();
            }
            catch (IOException ex2) {
                this.logger.log(Level.INFO, "IOException - closing channel", ex2);
            }
        }
        catch (IOException e) {
            this.logger.log(Level.FINE, "IOException??", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void retransmit(long elapsed) {
        Hashtable hashtable = this.endpoint_table;
        synchronized (hashtable) {
            Enumeration e = this.endpoint_table.elements();
            while (e.hasMoreElements()) {
                MsgChannelImpl channel = (MsgChannelImpl)e.nextElement();
                try {
                    channel.retransmit(elapsed);
                }
                catch (Exception ex) {
                    this.logger.log(Level.FINE, "retransmit on " + channel + " caused an exception. ", ex);
                    channel.disableRetransmit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void garbageCollect() {
        this.logger.finest("MsgManager.garbageCollect");
        LinkedList<MsgChannelImpl> gcList = new LinkedList<MsgChannelImpl>();
        Hashtable hashtable = this.endpoint_table;
        synchronized (hashtable) {
            Enumeration e = this.endpoint_table.elements();
            while (e.hasMoreElements()) {
                MsgChannelImpl channel = (MsgChannelImpl)e.nextElement();
                if (!channel.readyForGC()) continue;
                gcList.add(channel);
            }
        }
        while (!gcList.isEmpty()) {
            MsgChannelImpl channel = (MsgChannelImpl)gcList.getFirst();
            gcList.removeFirst();
            this.endpoint_table.remove(channel.getEndPoint());
            this.connection_table.remove(new Long(channel.getConnectionId()));
        }
    }

    public int openMsgChannels() {
        return this.endpoint_table.size();
    }

    public long messagesSent() {
        return this.packetSent;
    }

    public long dataSent() {
        return this.dataSent;
    }

    public long messagesReceived() {
        return this.packetRecv;
    }

    public long dataReceived() {
        return this.dataRecv;
    }
}

