/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.MessageBuffer;
import com.sun.hadb.comm.RPCChannel;
import com.sun.hadb.comm.RPCGetTuplesDescr;
import com.sun.hadb.comm.RPCProcedure;

public class RPCGetTuples
implements RPCProcedure {
    private static final int FETCH_BUFFER_SIZE = 32000;
    private RPCGetTuplesDescr tuples_descr;
    private long rmt;
    private long fmode;
    private long maxcnt;
    private long maxlen;
    private long option;
    private long vmark;

    public RPCGetTuples(int rpc_version) {
        this.tuples_descr = new RPCGetTuplesDescr(rpc_version);
        this.maxlen = 32000L;
    }

    public int getProcedureNumber() {
        return 21;
    }

    public void read(MessageBuffer buffer) {
        this.tuples_descr.read(buffer);
    }

    public void write(MessageBuffer buffer) {
        RPCChannel.appendInt32(buffer, this.rmt);
        RPCChannel.appendInt(buffer, this.fmode);
        RPCChannel.appendInt(buffer, this.maxcnt);
        RPCChannel.appendInt(buffer, this.maxlen);
        RPCChannel.appendInt(buffer, this.option);
        RPCChannel.appendInt32(buffer, this.vmark);
    }

    public void setRemoteTableId(long rmt) {
        this.rmt = rmt;
    }

    public void setDirection(int fmode) {
        this.fmode = fmode;
    }

    public void setMaxCount(long count) {
        this.maxcnt = count;
    }

    public void setOption(long opt) {
        this.option = opt;
    }

    public RPCGetTuplesDescr getTuplesDescriptor() {
        return this.tuples_descr;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("INPUT: rmt=").append(this.rmt);
        sb.append(" fetch direction=").append(this.fmode);
        sb.append(" max count=").append(this.maxcnt);
        sb.append("\n");
        sb.append("OUTPUT: ");
        sb.append(this.tuples_descr.toString());
        return sb.toString();
    }
}

