/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.MessageBuffer;
import com.sun.hadb.comm.RPCChannel;
import com.sun.hadb.comm.RPCStatus;
import com.sun.hadb.comm.RPCTransStatus;
import com.sun.hadb.comm.RPCType;

public class RPCGetTuplesDescr
implements RPCType {
    private RPCTransStatus transstat;
    private RPCStatus status;
    private long count;
    private long mrkcount;
    private long eof;
    private long marks;
    private long option;
    private MessageBuffer tuples;
    private int rpc_version;

    public RPCGetTuplesDescr(int rpc_version) {
        this.rpc_version = rpc_version;
    }

    public void write(MessageBuffer buffer) {
    }

    public void read(MessageBuffer buffer) {
        this.count = RPCChannel.getInt(buffer);
        this.mrkcount = RPCChannel.getInt(buffer);
        this.eof = RPCChannel.getInt(buffer);
        if (this.rpc_version >= 6) {
            this.option = RPCChannel.getInt(buffer);
        }
        this.tuples = buffer;
    }

    public int getCount() {
        return (int)this.count;
    }

    public boolean isEof() {
        return this.eof != 0L;
    }

    public MessageBuffer getTuples() {
        return this.tuples;
    }

    public long getOption() {
        return this.option;
    }

    public RPCStatus getRPCStatus() {
        return this.status;
    }

    public void setRPCStatus(RPCStatus status) {
        this.status = status;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("count=");
        sb.append(this.count);
        sb.append(" eof=");
        sb.append(this.eof);
        sb.append(" mrkcount=");
        sb.append(this.mrkcount);
        if (this.rpc_version >= 6) {
            sb.append(" option=" + this.getOption());
        }
        sb.append(" buffer.size()=");
        sb.append(this.getTuples().size());
        return sb.toString();
    }
}

