/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.MessageBuffer;
import com.sun.hadb.comm.RPCChannel;
import com.sun.hadb.comm.RPCProcedure;
import com.sun.hadb.comm.RPCStatus;
import com.sun.hadb.comm.RPCTransStatus;
import com.sun.hadb.comm.RPCTrimChar;
import com.sun.hadb.comm.RPCVarByte;
import com.sun.hadb.comm.RPCVarChar;
import java.util.Vector;

public class RPCOpenDatabase
implements RPCProcedure {
    private RPCTransStatus transstatus;
    private RPCStatus rpcstatus;
    private RPCTrimChar username = new RPCTrimChar(32);
    private RPCVarByte password = new RPCVarByte();
    private RPCTrimChar database = new RPCTrimChar(16);
    private long loginmode;
    private RPCTrimChar user = new RPCTrimChar(64);
    private RPCTrimChar node = new RPCTrimChar(64);
    private RPCTrimChar term = new RPCTrimChar(8);
    private long cpuno;
    private long machtp;
    private int timezone;
    private int msg_charset;
    private RPCVarChar language;
    private int charsetcnt;
    private RPCTrimChar procid = new RPCTrimChar(8);
    private long logins;
    private long userid;
    private long priv;
    private long pid;
    private long sid;
    private Vector charsetvec;
    private int rpc_version = 5;

    public RPCOpenDatabase() {
        this.language = new RPCVarChar();
        this.charsetvec = new Vector();
    }

    public int getProcedureNumber() {
        return 2;
    }

    public void setUsername(String username) {
        this.username.setValue(username);
    }

    public void setPassword(byte[] encrypted_password) {
        this.password.setValue(encrypted_password);
    }

    public void setDatabase(String dbname) {
        this.database.setValue(dbname);
    }

    public void setMode(int mode) {
        this.loginmode = mode;
    }

    public void setUser(String user) {
        this.user.setValue(user);
    }

    public void setNode(String node) {
        this.node.setValue(node);
    }

    public void setProcessId(String id) {
        this.procid.setValue(id);
    }

    public void setCpuNo(long cpu) {
        this.cpuno = cpu;
    }

    public void setMachineType(int machtype) {
        this.machtp = machtype;
    }

    public void setTimeZone(int zone) {
        this.timezone = zone;
    }

    public void setTerminal(String terminal) {
        this.term.setValue(terminal);
    }

    public void setMsgCharset(int msgcharset) {
        this.msg_charset = msgcharset;
    }

    public int getMsgCharset() {
        return this.msg_charset;
    }

    public String getLanguage() {
        return this.language.getValue();
    }

    public void setLanguage(String language) {
        this.language.setValue(language);
    }

    public void addCharset(int charset) {
        this.charsetvec.add(new Integer(charset));
    }

    public void write(MessageBuffer buffer) {
        this.username.write(buffer);
        this.password.write(buffer);
        this.database.write(buffer);
        RPCChannel.appendInt(buffer, this.loginmode);
        this.user.write(buffer);
        this.node.write(buffer);
        this.term.write(buffer);
        this.procid.write(buffer);
        RPCChannel.appendInt32(buffer, this.cpuno);
        RPCChannel.appendInt(buffer, this.machtp);
        RPCChannel.appendInt16(buffer, this.timezone);
        if (this.rpc_version >= 5) {
            RPCChannel.appendInt16(buffer, this.msg_charset);
            this.language.write(buffer);
            RPCChannel.appendInt16(buffer, this.charsetvec.size());
            for (int i = 0; i < this.charsetvec.size(); ++i) {
                Integer a = (Integer)this.charsetvec.elementAt(i);
                RPCChannel.appendInt16(buffer, a);
            }
        }
    }

    public void read(MessageBuffer buffer) {
        this.procid.read(buffer);
        this.cpuno = RPCChannel.getInt32(buffer);
        this.machtp = RPCChannel.getInt(buffer);
        this.logins = RPCChannel.getInt(buffer);
        this.userid = RPCChannel.getInt32(buffer);
        this.priv = RPCChannel.getInt32(buffer);
        this.pid = RPCChannel.getInt32(buffer);
        this.sid = RPCChannel.getInt32(buffer);
        this.timezone = RPCChannel.getInt16(buffer);
        if (this.rpc_version >= 5) {
            this.msg_charset = RPCChannel.getInt16(buffer);
            this.language.read(buffer);
        }
        buffer.close();
    }

    public void setRPCVersion(int ver) {
        this.rpc_version = ver;
    }
}

