/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.MessageBuffer;
import com.sun.hadb.comm.RPCChannel;
import com.sun.hadb.comm.RPCErrMsgDescr;
import com.sun.hadb.comm.RPCExeDescr;
import com.sun.hadb.comm.RPCPrepDescr;
import com.sun.hadb.comm.RPCStatus;
import com.sun.hadb.comm.RPCTableTypeDescr;
import com.sun.hadb.comm.RPCTransStatus;
import com.sun.hadb.comm.RPCType;

public class RPCQueryDescr
implements RPCType {
    private RPCTransStatus transstat;
    private RPCStatus status;
    private long rmt;
    private long qrymode;
    private long paramdescr;
    private RPCTableTypeDescr pds;
    private long msgcount;
    private RPCErrMsgDescr[] messages;
    private long prepcount;
    private RPCPrepDescr[] prep;
    private long execount;
    private RPCExeDescr[] exe;
    private MessageBuffer tuples;
    private int rpc_version;

    public RPCQueryDescr(int rpc_version) {
        this.rpc_version = rpc_version;
        this.rmt = -1L;
        this.execount = 0L;
    }

    public void write(MessageBuffer buffer) {
    }

    public void read(MessageBuffer buffer) {
        int i;
        this.rmt = RPCChannel.getInt(buffer);
        this.qrymode = RPCChannel.getInt(buffer);
        this.paramdescr = RPCChannel.getInt(buffer);
        if (this.paramdescr != 0L) {
            this.pds = new RPCTableTypeDescr();
            this.pds.read(buffer);
        }
        this.msgcount = RPCChannel.getInt(buffer);
        if (this.msgcount > 0L) {
            this.messages = new RPCErrMsgDescr[(int)this.msgcount];
            for (i = 0; i < this.messages.length; ++i) {
                this.messages[i] = new RPCErrMsgDescr();
                this.messages[i].read(buffer);
            }
        }
        this.prepcount = RPCChannel.getInt(buffer);
        if (this.prepcount > 0L) {
            this.prep = new RPCPrepDescr[(int)this.prepcount];
            for (i = 0; i < this.prep.length; ++i) {
                this.prep[i] = new RPCPrepDescr();
                this.prep[i].read(buffer);
            }
        }
        this.execount = RPCChannel.getInt(buffer);
        if (this.execount > 0L) {
            this.exe = new RPCExeDescr[(int)this.execount];
            for (i = 0; i < this.exe.length; ++i) {
                this.exe[i] = new RPCExeDescr(this.rpc_version);
                this.exe[i].read(buffer);
            }
        }
        this.tuples = buffer;
    }

    public int getPrepCount() {
        return (int)this.prepcount;
    }

    public int getMsgCount() {
        return (int)this.msgcount;
    }

    public int getExeCount() {
        return (int)this.execount;
    }

    public void setExeCount(int i) {
        this.execount = i;
    }

    public RPCTableTypeDescr getPDS() {
        return this.pds;
    }

    public RPCExeDescr getExe(int i) {
        if (this.exe != null) {
            return this.exe[i];
        }
        return null;
    }

    public RPCExeDescr[] getExe() {
        return this.exe;
    }

    public void setExe(RPCExeDescr[] exe) {
        this.exe = exe;
        this.execount = exe != null ? (long)exe.length : 0L;
    }

    public RPCPrepDescr getPrep(int i) {
        if (this.prep != null) {
            return this.prep[i];
        }
        return null;
    }

    public RPCStatus getRPCStatus() {
        return this.status;
    }

    public void setRPCStatus(RPCStatus stat) {
        this.status = stat;
    }

    public long getQueryMode() {
        return this.qrymode;
    }

    public long getRemoteTableId() {
        return this.rmt;
    }

    public MessageBuffer getTuples() {
        return this.tuples;
    }

    public void close() {
        if (this.tuples != null) {
            this.tuples.close();
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer("RPCQueryDescr: ");
        str.append(", rmt=").append(Long.toHexString(this.rmt));
        str.append(", qrymode=").append(Long.toHexString(this.qrymode));
        if (this.pds != null) {
            str.append("\nPDS:\n");
            str.append(this.pds.toString());
        }
        str.append("\n");
        int i = 0;
        while ((long)i < this.msgcount) {
            str.append("  " + i + ": ");
            str.append(this.messages[i].toString());
            str.append("\n");
            ++i;
        }
        i = 0;
        while ((long)i < this.prepcount) {
            str.append("  " + i + ": ");
            str.append(this.prep[i].toString());
            str.append("\n");
            ++i;
        }
        i = 0;
        while ((long)i < this.execount) {
            str.append("  " + i + ": ");
            str.append(this.exe[i].toString());
            str.append("\n");
            ++i;
        }
        return str.toString();
    }
}

