/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.CommException;
import com.sun.hadb.comm.MessageBuffer;
import com.sun.hadb.comm.RPCStatus;
import com.sun.hadb.comm.RPCTransStatus;

public class RPCResult {
    private long reply;
    private RPCStatus status = null;
    private RPCTransStatus transtat = null;
    private int procno;

    RPCResult(long rep, int no) {
        this.reply = rep;
        this.procno = no;
    }

    void read(MessageBuffer buffer) throws CommException {
        if (this.reply != 1L) {
            this.status = new RPCStatus();
            this.status.fill(this.reply);
            String iot = this.status.getIOSText();
            throw new CommException(13, this.status.getErrorMessage() + " : " + iot);
        }
        if (this.procno != 0) {
            if (this.procno != 40) {
                this.transtat = new RPCTransStatus();
                this.transtat.read(buffer);
            }
            this.status = new RPCStatus();
            this.status.read(buffer);
            if (this.status.getIOStatus() != 0L) {
                String iot = this.status.getIOSText();
                if (iot == null) {
                    iot = "";
                }
                throw new CommException(13, this.status.getErrorMessage() + " : " + iot);
            }
        }
    }

    public RPCStatus getRPCStatus() {
        return this.status;
    }

    public RPCTransStatus getRPCTransStatus() {
        return this.transtat;
    }

    public long getReply() {
        return this.reply;
    }
}

