/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.MessageBuffer;
import com.sun.hadb.comm.RPCChannel;

public class RPCTransStatus {
    private static final int TRN_INSIDE = 1;
    private static final int TRN_CLOSED = 2;
    private static final int TRN_COMMITTED = 4;
    private static final int TRN_ROLLEDBACK = 8;
    private boolean error = false;
    private long transtat;
    private long transno;

    public void read(MessageBuffer buffer) {
        this.error = false;
        this.transtat = buffer.getUInt32();
        if ((this.transtat & 2L) != 0L) {
            this.error = true;
            this.transno = RPCChannel.getInt64(buffer);
        }
    }

    public boolean isError() {
        return this.error;
    }

    public long getTransactionCode() {
        return this.transtat;
    }

    public boolean isRolledBack() {
        return (this.transtat & 8L) != 0L;
    }

    public boolean isInsideTransaction() {
        return (this.transtat & 1L) != 0L;
    }

    public boolean isClosed() {
        return (this.transtat & 2L) != 0L;
    }

    public long getTransNo() {
        return this.transno;
    }
}

