/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.CommException;
import com.sun.hadb.comm.CommLogFactory;
import com.sun.hadb.comm.Dialog;
import com.sun.hadb.comm.DialogManager;
import com.sun.hadb.comm.EndPoint;
import com.sun.hadb.comm.MsgInfo;
import com.sun.hadb.comm.SepChannel;
import com.sun.hadb.comm.SepFrame;
import java.util.logging.Level;
import java.util.logging.Logger;

class SepInitThread
implements Runnable {
    private static final int SEP_RETRYINTERVAL = 200;
    private static final int SEP_INIT_RETRY = 2;
    Logger logger = CommLogFactory.getCommLogger();
    private long message_key;
    private SepChannel channel;
    private EndPoint endpoint;
    private boolean running;
    private String callerthr;

    public SepInitThread(SepChannel channel, EndPoint endpoint, String who) {
        this.endpoint = endpoint;
        this.channel = channel;
        this.callerthr = who;
        this.running = true;
    }

    public EndPoint getEndPoint() {
        return this.endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.logger.finer("Calling " + this.endpoint.toString());
        Dialog dlg = null;
        DialogManager dlgman = DialogManager.getInstance();
        try {
            int state = 1;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("run " + this.callerthr + " " + this.endpoint.toString());
            }
            block16: while (this.isRunning()) {
                switch (state) {
                    case 1: {
                        dlg = dlgman.open(this.endpoint, false, 0L);
                        if (dlg == null) {
                            this.logger.fine("DialogManager returned null dialog");
                            return;
                        }
                        this.send(dlg, 160, 1);
                        break;
                    }
                    case 2: {
                        this.logger.fine("SEP_INIT_RETRY " + this.callerthr);
                        dlg.retryMsg();
                        break;
                    }
                    case 5: {
                        this.logger.fine("Success " + this.callerthr + this.endpoint.toString());
                        SepChannel sepChannel = this.channel;
                        synchronized (sepChannel) {
                            this.channel.setEndPoint(this.endpoint, this.message_key);
                            this.channel.notify();
                        }
                        return;
                    }
                    case 255: {
                        this.logger.fine("Error " + this.callerthr + this.endpoint.toString());
                        return;
                    }
                    default: {
                        this.logger.fine("ERROR with endpoint : " + this.callerthr + this.endpoint.toString());
                        return;
                    }
                }
                int type = this.receive(dlg);
                switch (type) {
                    case 2: {
                        dlg.close();
                        state = 5;
                        continue block16;
                    }
                    case 4: {
                        dlg.close();
                        state = 255;
                        continue block16;
                    }
                    case 254: {
                        this.logger.fine("timeout");
                        state = 2;
                        continue block16;
                    }
                }
                state = 255;
            }
        }
        catch (Exception e) {
            this.logger.log(Level.FINE, "SEP negotiation caused an exception", e);
        }
        this.logger.fine("closed by owner " + this.callerthr);
    }

    public synchronized void setRunning(boolean to_what) {
        this.running = to_what;
    }

    private synchronized boolean isRunning() {
        return this.running;
    }

    private void send(Dialog dlg, int comcode, int type) throws CommException {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("SepInitThread.send() : To " + this.endpoint.toString() + " comcode=" + comcode + " type=" + type);
        }
        SepFrame frame = new SepFrame(comcode, type, null);
        frame.send(dlg, true);
    }

    private int receive(Dialog dlg) throws CommException {
        MsgInfo msg = null;
        int retries = 0;
        while (msg == null && ++retries <= 4) {
            msg = dlg.receive(50L);
        }
        if (msg != null) {
            EndPoint[] serverlist;
            SepFrame frame = new SepFrame(msg);
            if (frame.getComCode() != 161) {
                this.logger.fine("Illegal comcode received : code = " + frame.getComCode());
                frame.close();
                return 255;
            }
            if (frame.getType() == 7 && (serverlist = frame.getServerList()).length > 0) {
                this.endpoint = serverlist[0];
            }
            this.message_key = frame.getMessageKey();
            int type = frame.getType();
            frame.close();
            return type;
        }
        return 254;
    }
}

