/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.CommLogFactory;
import com.sun.hadb.comm.DialogCallback;
import com.sun.hadb.comm.DialogManager;
import com.sun.hadb.comm.EndPoint;
import com.sun.hadb.comm.MsgInfo;
import com.sun.hadb.comm.SepChannel;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SepManager
implements DialogCallback {
    Logger logger = CommLogFactory.getCommLogger();
    private static SepManager this_instance = null;
    private Hashtable sepChannels = new Hashtable();

    private SepManager() {
        DialogManager.getInstance().setCallback(this);
    }

    public static synchronized SepManager getInstance() {
        if (this_instance == null) {
            this_instance = new SepManager();
        }
        return this_instance;
    }

    public synchronized void register(SepChannel sep, EndPoint endPoint) {
        if (this.sepChannels.containsKey(endPoint)) {
            this.logger.finest("SepManager.register: hash table already contains " + endPoint);
            this.sepChannels.remove(endPoint);
        }
        this.sepChannels.put(endPoint, sep);
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("SepManager.register: size: " + this.sepChannels.size());
        }
    }

    public synchronized void unregister(SepChannel sep) {
        EndPoint endPoint = sep.getEndPoint();
        if (endPoint != null) {
            if (this.sepChannels.remove(endPoint) == null) {
                this.logger.finest("SepManager.unregister: did not find Sep Channel (endPoint: " + endPoint + ")");
            }
        } else {
            this.logger.finest("SepManager.unregister: Sep Channel does not have endPoint");
        }
        this.logger.finest("SepManager.unregister: size: " + this.sepChannels.size());
    }

    public synchronized void callback(int dialog_id, int round, int flags, MsgInfo msginfo) {
        SepChannel sep = (SepChannel)this.sepChannels.get(msginfo.getEndPoint());
        if (sep != null) {
            sep.callback(dialog_id, round, flags, msginfo);
        } else {
            this.logger.fine("SepManager.callback: No sep channel found for PING request");
        }
    }
}

