/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.CommException;
import com.sun.hadb.comm.CommLogFactory;
import com.sun.hadb.comm.Dialog;
import com.sun.hadb.comm.DialogManager;
import com.sun.hadb.comm.EndPoint;
import com.sun.hadb.comm.MessageBuffer;
import com.sun.hadb.comm.MsgInfo;
import com.sun.hadb.comm.SepChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SepPingThread
implements Runnable {
    private static final int SEP_PING_BLOCK_TIME = 1000;
    private Logger logger = CommLogFactory.getCommLogger();
    private Dialog dialog;
    private boolean running;
    private SepChannel sep;

    public SepPingThread(EndPoint endPoint, int dialogId, long key, SepChannel sep) throws CommException {
        this.sep = sep;
        DialogManager dlgman = DialogManager.getInstance();
        this.dialog = dlgman.openSlave(endPoint, dialogId, true, key);
    }

    public void run() {
        this.logger.finest("SEP ping thread started");
        this.running = true;
        while (this.stillRunning()) {
            MsgInfo pingMsg = null;
            int retries = 0;
            while (pingMsg == null && ++retries <= 4) {
                pingMsg = this.dialog.receive(250L);
            }
            if (pingMsg == null) continue;
            this.logger.finest("SEP ping received");
            if (this.stillRunning()) {
                if (this.sep != null) {
                    this.sep.receivePing();
                }
                try {
                    MessageBuffer buffer = new MessageBuffer();
                    buffer.appendUInt8(165);
                    buffer.appendUInt8(0);
                    buffer.appendUInt16(0);
                    this.dialog.send(buffer);
                }
                catch (CommException e) {
                    this.logger.log(Level.WARNING, "Exception while sending SEP ping reply", e);
                }
            }
            pingMsg.close();
        }
        this.dialog.close();
        this.dialog = null;
        this.logger.finest("SEP ping thread stopped");
    }

    public synchronized void stopRunning() {
        this.logger.finest("SEP ping thread received close signal");
        this.running = false;
        this.sep = null;
    }

    public synchronized boolean stillRunning() {
        return this.running;
    }
}

