/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.MessageBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class TimeVal {
    private static SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss.SSS");
    private int tv_sec;
    private int tv_usec;

    public TimeVal() {
        this.tv_sec = 0;
        this.tv_usec = 0;
    }

    public TimeVal(int sec, int usec) {
        this.tv_sec = sec;
        this.tv_usec = usec;
    }

    public TimeVal(MessageBuffer buf) {
        this.tv_sec = buf.getInt32();
        this.tv_usec = (int)buf.getUInt32();
    }

    public void fetch() {
        long millis = System.currentTimeMillis();
        this.tv_sec = (int)(millis / 1000L);
        this.tv_usec = (int)((millis - (long)(this.tv_sec * 1000)) * 1000L);
    }

    public void append(MessageBuffer buf) {
        buf.appendInt32(this.tv_sec);
        buf.appendUInt32(this.tv_usec);
    }

    public boolean equals(TimeVal rhs) {
        return this.tv_sec == rhs.tv_sec && this.tv_usec == rhs.tv_usec;
    }

    public int compareTo(TimeVal rhs) {
        if (this.equals(rhs)) {
            return 0;
        }
        if (this.tv_sec < rhs.tv_sec || this.tv_sec == rhs.tv_sec && this.tv_usec < rhs.tv_usec) {
            return -1;
        }
        return 1;
    }

    public TimeVal add(TimeVal val) {
        TimeVal result = new TimeVal(this.tv_sec + val.tv_sec, this.tv_usec + val.tv_usec);
        result.normalize();
        return result;
    }

    public TimeVal subtract(TimeVal val) {
        TimeVal result = new TimeVal(this.tv_sec - val.tv_sec, this.tv_usec - val.tv_usec);
        result.normalize();
        return result;
    }

    private void normalize() {
        if (this.tv_usec >= 1000000) {
            ++this.tv_sec;
            this.tv_usec -= 1000000;
        } else if (this.tv_usec < 0) {
            --this.tv_sec;
            this.tv_usec += 1000000;
        }
    }

    public String toDateString() {
        Date d = new Date((long)this.tv_sec * 1000L + (long)(this.tv_usec / 1000));
        return formatter.format(d);
    }

    public String toString() {
        String usecStr = String.valueOf(this.tv_usec);
        int strLen = usecStr.length();
        if (strLen != 6) {
            if (strLen < 6) {
                int zeros = 6 - strLen;
                for (int i = 0; i < zeros; ++i) {
                    usecStr = "0" + usecStr;
                }
            } else {
                usecStr = "XXXXXX";
            }
        }
        return " " + this.tv_sec + '.' + usecStr;
    }

    public int get_sec() {
        return this.tv_sec;
    }

    public int get_usec() {
        return this.tv_usec;
    }

    public float get_float() {
        return (float)this.tv_sec + (float)this.tv_usec / 1000000.0f;
    }

    static {
        formatter.setTimeZone(TimeZone.getDefault());
    }
}

