/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.jdbc.DbException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ClobImpl
implements Clob {
    private static final String LOB_COLUMN = "lob_data";
    private static final int INPUT_MODE = 1;
    private static final int OUTPUT_MODE = 2;
    private int mode = 2;
    private long len;
    private ResultSet rs;

    public InputStream getAsciiStream() throws SQLException {
        return new AsciiStreamMultiplexer(this.rs, this.len);
    }

    public Reader getCharacterStream() throws SQLException {
        return new CharacterStreamMultiplexer(this.rs, this.len);
    }

    public String getSubString(long pos, int length) throws SQLException {
        throw new DbException(2);
    }

    public long length() throws SQLException {
        if (this.mode == 2) {
            return this.len;
        }
        return 0L;
    }

    public long position(Clob searchstr, long start) throws SQLException {
        throw new DbException(2);
    }

    public long position(String searchstr, long start) throws SQLException {
        throw new DbException(2);
    }

    public OutputStream setAsciiStream(long pos) throws SQLException {
        this.mode = 1;
        throw new DbException(2);
    }

    public Writer setCharacterStream(long pos) throws SQLException {
        this.mode = 1;
        throw new DbException(2);
    }

    public int setString(long pos, String str) throws SQLException {
        try {
            Writer writer = this.setCharacterStream(pos);
            writer.write(str);
            return str.length();
        }
        catch (IOException e) {
            throw new DbException(e);
        }
    }

    public int setString(long pos, String str, int offset, int len) throws SQLException {
        String sub = str.substring(offset, len);
        return this.setString(pos, sub);
    }

    public void truncate(long len) throws SQLException {
    }

    protected ClobImpl(ResultSet rs, long len) {
        this.rs = rs;
        this.len = len;
    }

    class CharacterStreamMultiplexer
    extends Reader {
        private InputStream in;
        private ResultSet rs;
        private long len;
        private long charsConsumed = 0L;

        public CharacterStreamMultiplexer(ResultSet rs, long len) {
            this.rs = rs;
            this.len = len;
            this.in = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.rs = null;
                this.in = null;
            }
        }

        public int read() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                try {
                    int c;
                    if (this.in == null || (c = this.in.read()) == -1) {
                        if (this.rs != null && this.rs.next()) {
                            this.in = this.rs.getAsciiStream(ClobImpl.LOB_COLUMN);
                            c = this.in.read();
                            ++this.charsConsumed;
                        } else {
                            this.in = null;
                            c = -1;
                        }
                    }
                    if (c == -1) {
                        this.in = null;
                        if (this.charsConsumed != this.len) {
                            throw new DbException(59);
                        }
                    } else {
                        ++this.charsConsumed;
                    }
                    return c;
                }
                catch (SQLException e) {
                    IOException ne = new IOException(e.toString());
                    ne.initCause(e);
                    throw ne;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int read(char[] cbuf, int off, int len) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                int c;
                int i;
                for (i = 0; i < len && (c = this.read()) != -1; ++i) {
                    cbuf[off] = (char)c;
                    ++off;
                }
                return i;
            }
        }
    }

    class AsciiStreamMultiplexer
    extends InputStream {
        private InputStream in;
        private ResultSet rs;
        private long len;
        private long charsConsumed = 0L;

        public AsciiStreamMultiplexer(ResultSet rs, long len) {
            this.rs = rs;
            this.len = len;
            this.in = null;
        }

        public synchronized int read(byte[] b, int off, int len) throws IOException {
            if (this.rs == null) {
                throw new IOException("Stream is closed");
            }
            for (int i = 0; i < len; ++i) {
                int c = this.read();
                if (c == -1) {
                    return i;
                }
                b[off + i] = (byte)c;
            }
            return len;
        }

        public synchronized int read() throws IOException {
            if (this.rs == null) {
                throw new IOException("Stream is closed");
            }
            try {
                int c;
                if (this.in == null || (c = this.in.read()) == -1) {
                    if (this.rs.next()) {
                        this.in = this.rs.getAsciiStream(ClobImpl.LOB_COLUMN);
                        c = this.in.read();
                    } else {
                        this.in = null;
                        c = -1;
                    }
                }
                if (c == -1) {
                    this.in = null;
                    if (this.charsConsumed != this.len) {
                        throw new DbException(59);
                    }
                } else {
                    ++this.charsConsumed;
                }
                return c;
            }
            catch (SQLException e) {
                IOException ne = new IOException(e.toString());
                ne.initCause(e);
                throw ne;
            }
        }
    }
}

