/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.jdbc.ConnectionImpl;
import com.sun.hadb.jdbc.DbException;
import com.sun.hadb.jdbc.Driver;
import com.sun.hadb.jdbc.ResultSetImpl;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;

public final class DatabaseMetaDataImpl
implements DatabaseMetaData {
    private static final String jschema = "jdbc_30_42_1";
    private ConnectionImpl con;
    private boolean gotVersion = false;
    private int dbMajor = 0;
    private int dbMinor = 0;

    public DatabaseMetaDataImpl(ConnectionImpl c) throws SQLException {
        this.con = c;
    }

    public boolean allProceduresAreCallable() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(80);
        return value == 1;
    }

    public boolean allTablesAreSelectable() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(82);
        return value == 1;
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(77);
        return value == 3;
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(77);
        return value == 4;
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(102);
        return value == 1;
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        Object[][] desc = new Object[][]{{schema, "schemaname", "=", new Boolean(false)}, {table, "tablename", "=", new Boolean(false)}};
        String whereClause = this.getWhereClause(desc);
        Statement stmt = this.con.createStatement();
        return stmt.executeQuery("select scope, column_name, data_type, type_name, column_size, buffer_length, decimal_digits, pseudo_column from jdbc_30_42_1.getbestrowidentifier " + whereClause + "order by scope");
    }

    public String getCatalogSeparator() throws SQLException {
        return this.con.acquireServerInfo().getString(86);
    }

    public String getCatalogTerm() throws SQLException {
        return this.con.acquireServerInfo().getString(88);
    }

    public ResultSet getCatalogs() throws SQLException {
        String str = "select table_cat from jdbc_30_42_1.getcatalogs";
        Statement stmt = this.con.createStatement();
        ResultSetImpl rs = (ResultSetImpl)stmt.executeQuery(str);
        return rs;
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        Object[][] desc = new Object[][]{{schema, "table_schem", "=", new Boolean(false)}, {table, "table_name", "=", new Boolean(false)}, {columnNamePattern, "column_name", "like", new Boolean(false)}};
        Statement stmt = this.con.createStatement();
        String str = "select table_cat, table_schem, table_name, column_name, grantor, grantee, privilege, is_grantable from jdbc_30_42_1.getcolumnprivileges " + this.getWhereClause(desc) + " order by column_name, privilege";
        ResultSetImpl rs = (ResultSetImpl)stmt.executeQuery(str);
        return rs;
    }

    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        Object[][] desc = new Object[][]{{schemaPattern, "table_schem", "like", new Boolean(false)}, {tableNamePattern, "table_name", "like", new Boolean(false)}, {columnNamePattern, "column_name", "like", new Boolean(false)}};
        Statement stmt = this.con.createStatement();
        String whereClause = this.getWhereClause(desc);
        String str = "select table_cat, table_schem, table_name, column_name, data_type, type_name, column_size, buffer_length, decimal_digits, num_prec_radix, nullable, remarks, column_def, sql_data_type, sql_datetime_sub, char_octet_length, ordinal_position, is_nullable from jdbc_30_42_1.getcolumns " + whereClause + " order by table_schem, table_name, ordinal_position";
        return stmt.executeQuery(str);
    }

    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        if (primaryTable == null && foreignTable == null) {
            throw new DbException(19);
        }
        Object[][] desc = new Object[][]{{primarySchema, "pktable_schem", "=", new Boolean(false)}, {primaryTable, "pktable_name", "=", new Boolean(false)}, {foreignSchema, "fktable_schem", "=", new Boolean(false)}, {foreignTable, "fktable_name", "=", new Boolean(false)}};
        Statement stmt = this.con.createStatement();
        String str = "select pktable_cat, pktable_schem, pktable_name, pkcolumn_name, fktable_cat, fktable_schem, fktable_name, fkcolumn_name, key_seq, update_rule, delete_rule, fk_name, pk_name, deferrability from jdbc_30_42_1.getcrossreference " + this.getWhereClause(desc) + " order by fktable_cat, fktable_schem, fktable_name, key_seq";
        ResultSetImpl rs = (ResultSetImpl)stmt.executeQuery(str);
        return rs;
    }

    public String getDatabaseProductName() throws SQLException {
        return this.con.acquireServerInfo().getString(153);
    }

    public String getDatabaseProductVersion() throws SQLException {
        return this.con.acquireServerInfo().getString(94);
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        return this.siiaToJdbc(this.con.acquireServerInfo().getInt(23));
    }

    public int getDriverMajorVersion() {
        return Driver.majorVersion;
    }

    public int getDriverMinorVersion() {
        return Driver.minorVersion;
    }

    public String getDriverName() throws SQLException {
        return "Sun Java System(tm) HADB JDBC 3.0 Type 4 Driver";
    }

    public String getDriverVersion() throws SQLException {
        return Driver.driverVersion;
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        if (table == null) {
            throw new DbException(19);
        }
        Object[][] desc = new Object[][]{{schema, "pktable_schem", "=", new Boolean(false)}, {table, "pktable_name", "=", new Boolean(false)}};
        Statement stmt = this.con.createStatement();
        String str = "select pktable_cat, pktable_schem, pktable_name, pkcolumn_name, fktable_cat, fktable_schem, fktable_name, fkcolumn_name, key_seq, update_rule, delete_rule, fk_name, pk_name, deferrability from jdbc_30_42_1.getexportedkeys " + this.getWhereClause(desc) + " order by fktable_cat, fktable_schem, fktable_name, key_seq";
        ResultSetImpl rs = (ResultSetImpl)stmt.executeQuery(str);
        return rs;
    }

    public String getExtraNameCharacters() throws SQLException {
        return this.con.acquireServerInfo().getString(159);
    }

    public String getIdentifierQuoteString() throws SQLException {
        return this.con.acquireServerInfo().getString(149);
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        if (table == null) {
            throw new DbException(19);
        }
        Object[][] desc = new Object[][]{{schema, "fktable_schem", "=", new Boolean(false)}, {table, "fktable_name", "=", new Boolean(false)}};
        Statement stmt = this.con.createStatement();
        String str = "select pktable_cat, pktable_schem, pktable_name, pkcolumn_name, fktable_cat, fktable_schem, fktable_name, fkcolumn_name, key_seq, update_rule, delete_rule, fk_name, pk_name, deferrability from jdbc_30_42_1.getimportedkeys " + this.getWhereClause(desc) + " order by pktable_cat, pktable_schem, pktable_name, key_seq";
        ResultSetImpl rs = (ResultSetImpl)stmt.executeQuery(str);
        return rs;
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        String uniqueclause;
        Object[][] desc = new Object[][]{{schema, "table_schem", "=", new Boolean(false)}, {table, "table_name", "=", new Boolean(false)}};
        String whereclause = this.getWhereClause(desc);
        if (unique) {
            uniqueclause = whereclause.length() == 0 ? "where " : "and ";
            uniqueclause = uniqueclause + "(non_unique = 0 or non_unique is null) ";
        } else {
            uniqueclause = "";
        }
        Statement stmt = this.con.createStatement();
        String str = "select table_cat, table_schem, table_name, non_unique, index_qualifier, index_name, type, ordinal_position, column_name, asc_or_desc, cardinality, pages, filter_condition from jdbc_30_42_1.getindexinfo " + whereclause + uniqueclause + " order by non_unique, type, index_name, ordinal_position";
        ResultSetImpl rs = (ResultSetImpl)stmt.executeQuery(str);
        return rs;
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        return this.con.acquireServerInfo().getInt(37);
    }

    public int getMaxCatalogNameLength() throws SQLException {
        return this.con.acquireServerInfo().getInt(38);
    }

    public int getMaxCharLiteralLength() throws SQLException {
        return this.con.acquireServerInfo().getInt(39);
    }

    public int getMaxColumnNameLength() throws SQLException {
        return this.con.acquireServerInfo().getInt(40);
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        return this.con.acquireServerInfo().getInt(41);
    }

    public int getMaxColumnsInIndex() throws SQLException {
        return this.con.acquireServerInfo().getInt(42);
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        return this.con.acquireServerInfo().getInt(43);
    }

    public int getMaxColumnsInSelect() throws SQLException {
        return this.con.acquireServerInfo().getInt(44);
    }

    public int getMaxColumnsInTable() throws SQLException {
        return this.con.acquireServerInfo().getInt(45);
    }

    public int getMaxConnections() throws SQLException {
        return 0;
    }

    public int getMaxCursorNameLength() throws SQLException {
        return this.con.acquireServerInfo().getInt(46);
    }

    public int getMaxIndexLength() throws SQLException {
        return this.con.acquireServerInfo().getInt(48);
    }

    public int getMaxProcedureNameLength() throws SQLException {
        return this.con.acquireServerInfo().getInt(50);
    }

    public int getMaxRowSize() throws SQLException {
        return this.con.acquireServerInfo().getInt(51);
    }

    public int getMaxSchemaNameLength() throws SQLException {
        return this.con.acquireServerInfo().getInt(52);
    }

    public int getMaxStatementLength() throws SQLException {
        return this.con.acquireServerInfo().getInt(53);
    }

    public int getMaxStatements() throws SQLException {
        return 0;
    }

    public int getMaxTableNameLength() throws SQLException {
        return this.con.acquireServerInfo().getInt(54);
    }

    public int getMaxTablesInSelect() throws SQLException {
        return this.con.acquireServerInfo().getInt(55);
    }

    public int getMaxUserNameLength() throws SQLException {
        return this.con.acquireServerInfo().getInt(56);
    }

    private String makeFunctionString(int b, String[] funcNames) {
        int bitmask = b;
        int hitCount = 0;
        String result = "";
        int i = 0;
        while (i < 32 && i < Array.getLength(funcNames)) {
            if ((bitmask & 1) == 1) {
                if (hitCount > 0) {
                    result = result + ",";
                }
                result = result + funcNames[i];
                ++hitCount;
            }
            ++i;
            bitmask >>= 1;
        }
        return result;
    }

    public String getNumericFunctions() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(59);
        String[] funcNames = new String[]{"ABS", "ACOS", "ASIN", "ATAN", "ATAN2", "CEILING", "COS", "COT", "EXP", "FLOOR", "LOG", "MOD", "SIGN", "SIN", "SQRT", "TAN", "PI", "RAND", "DEGREES", "LOG10", "POWER", "RADIANS", "ROUND", "TRUNCATE"};
        return this.makeFunctionString(value, funcNames);
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        Object[][] desc = new Object[][]{{schema, "table_schem", "=", new Boolean(false)}, {table, "table_name", "=", new Boolean(false)}};
        Statement stmt = this.con.createStatement();
        String str = "select table_cat, table_schem, table_name, column_name, key_seq, pk_name from jdbc_30_42_1.getprimarykeys " + this.getWhereClause(desc) + " order by column_name";
        ResultSetImpl rs = (ResultSetImpl)stmt.executeQuery(str);
        return rs;
    }

    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        Object[][] desc = new Object[][]{{schemaPattern, "procedure_schem", "like", new Boolean(false)}, {procedureNamePattern, "procedure_name", "like", new Boolean(false)}, {columnNamePattern, "column_name", "like", new Boolean(false)}};
        String whereClause = this.getWhereClause(desc);
        String str = "select procedure_cat, procedure_schem, procedure_name, column_name, column_type, data_type, type_name, column_size as \"precision\", buffer_length as length, decimal_digits as scale, num_prec_radix as radix, nullable, remarks from jdbc_30_42_1.getprocedurecolumns " + whereClause + " order by procedure_schem, procedure_name";
        Statement stmt = this.con.createStatement();
        ResultSetImpl rs = (ResultSetImpl)stmt.executeQuery(str);
        return rs;
    }

    public String getProcedureTerm() throws SQLException {
        return this.con.acquireServerInfo().getString(116);
    }

    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        Object[][] desc = new Object[][]{{schemaPattern, "procedure_schem", "like", new Boolean(false)}, {procedureNamePattern, "procedure_name", "like", new Boolean(false)}};
        Statement stmt = this.con.createStatement();
        String str = "select procedure_cat, procedure_schem, procedure_name, num_input_params, num_output_params, num_result_sets, remarks, procedure_type from jdbc_30_42_1.getprocedures " + this.getWhereClause(desc) + " order by procedure_schem, procedure_name";
        return stmt.executeQuery(str);
    }

    public String getSQLKeywords() throws SQLException {
        return this.con.acquireServerInfo().getString(161);
    }

    public String getSchemaTerm() throws SQLException {
        return this.con.acquireServerInfo().getString(114);
    }

    public ResultSet getSchemas() throws SQLException {
        Statement stmt = this.con.createStatement();
        String str = "select table_schem from jdbc_30_42_1.getschemas  order by table_schem";
        ResultSetImpl rs = (ResultSetImpl)stmt.executeQuery(str);
        return rs;
    }

    public String getSearchStringEscape() throws SQLException {
        return this.con.acquireServerInfo().getString(110);
    }

    public String getStringFunctions() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(74);
        String[] funcNames = new String[]{"CONCAT", "INSERT", "LEFT", "LTRIM", "LENGTH", "LOCATE", "LCASE", "REPEAT", "REPLACE", "RIGHT", "RTRIM", "SUBSTRING", "UCASE", "ASCII", "CHAR", "DIFFERENCE", "LOCATE_2", "SOUNDEX", "SPACE", "BIT_LENGTH", "CHAR_LENGTH", "CHARACTER_LENGTH", "OCTET_LENGTH", "POSITION"};
        return this.makeFunctionString(value, funcNames);
    }

    public String getSystemFunctions() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(76);
        String[] funcNames = new String[]{"USER", "DATABASE", "IFNULL"};
        return this.makeFunctionString(value, funcNames);
    }

    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        Object[][] desc = new Object[][]{{schemaPattern, "table_schem", "like", new Boolean(false)}, {tableNamePattern, "table_name", "like", new Boolean(false)}};
        Statement stmt = this.con.createStatement();
        String str = "select table_cat, table_schem, table_name, grantor, grantee, privilege, is_grantable from jdbc_30_42_1.gettableprivileges " + this.getWhereClause(desc) + " order by table_schem, table_name, privilege";
        return stmt.executeQuery(str);
    }

    public ResultSet getTableTypes() throws SQLException {
        Statement stmt = this.con.createStatement();
        return stmt.executeQuery("select table_type from jdbc_30_42_1.gettabletypes order by table_type");
    }

    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        Object[][] desc = new Object[][]{{schemaPattern, "table_schem", "like", new Boolean(false)}, {tableNamePattern, "table_name", "like", new Boolean(false)}};
        String str = "select table_cat, table_schem, table_name, table_type, remarks from jdbc_30_42_1.gettables ";
        String w = this.getWhereClause(desc);
        str = str + w;
        if (types != null) {
            boolean first = true;
            for (int l = 0; l < types.length; ++l) {
                if (types[l] == null) continue;
                if (first) {
                    str = str + (w.length() == 0 ? "where " : "and ");
                    str = str + "table_type in('" + this.duplicateQuote(types[l]) + "'";
                    first = false;
                    continue;
                }
                str = str + ",'" + this.duplicateQuote(types[l]) + "'";
            }
            if (!first) {
                str = str + ") ";
            }
        }
        str = str + "order by table_type, table_schem, table_name";
        Statement stmt = this.con.createStatement();
        ResultSetImpl rs = (ResultSetImpl)stmt.executeQuery(str);
        return rs;
    }

    public String getTimeDateFunctions() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(148);
        String[] funcNames = new String[]{"NOW", "CURDATE", "DAYOFMONTH", "DAYOFWEEK", "DAYOFYEAR", "MONTH", "QUARTER", "WEEK", "YEAR", "CURTIME", "HOUR", "MINUTE", "SECOND", "TIMESTAMPADD", "TIMESTAMPDIFF", "DAYNAME", "MONTHNAME", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "EXTRACT"};
        return this.makeFunctionString(value, funcNames);
    }

    public ResultSet getTypeInfo() throws SQLException {
        Statement stmt = this.con.createStatement();
        String str = "select type_name, data_type, column_size as \"precision\", literal_prefix, literal_suffix, create_params, nullable, case_sensitive, searchable, unsigned_attribute, fixed_prec_scale, auto_unique_value as auto_increment, local_type_name, minimum_scale, maximum_scale, sql_data_type, sql_datetime_sub, num_prec_radix from jdbc_30_42_1.gettypeinfo order by data_type";
        return stmt.executeQuery(str);
    }

    public String getURL() throws SQLException {
        return this.con.getURL();
    }

    public String getUserName() throws SQLException {
        return this.con.getCurrentUser();
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        Object[][] desc = new Object[][]{{schema, "schemaname", "=", new Boolean(false)}, {table, "tablename", "=", new Boolean(false)}};
        String whereClause = this.getWhereClause(desc);
        Statement stmt = this.con.createStatement();
        return stmt.executeQuery("select scope, column_name, data_type, type_name, column_size, buffer_length, decimal_digits, pseudo_column, seqno as ordinal_position from jdbc_30_42_1.getversioncolumns " + whereClause + "order by ordinal_position");
    }

    public boolean isCatalogAtStart() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(10);
        return value == 1;
    }

    public boolean isReadOnly() throws SQLException {
        return this.con.isReadOnly();
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(12);
        return value == 0;
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(58);
        return value == 4;
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(58);
        return value == 2;
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(58);
        return value == 0;
    }

    public boolean nullsAreSortedLow() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(58);
        return value == 1;
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(155);
        return value == 2;
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(61);
        return value == 2;
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(155);
        return value == 4 || value == 3;
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(61);
        return value == 4;
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(155);
        return value == 1;
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(61);
        return value == 1;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        int conformance = this.con.acquireServerInfo().getInt(62);
        return (conformance & 1) != 0;
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        int conformance = this.con.acquireServerInfo().getInt(62);
        return (conformance & 8) != 0;
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        int conformance = this.con.acquireServerInfo().getInt(62);
        return (conformance & 4) != 0;
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(6);
        return (value & 0x20) != 0;
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(6);
        return (value & 0xC00) != 0;
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(11);
        return (value & 1) != 0;
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(11);
        return (value & 8) != 0;
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(11);
        return (value & 0x10) != 0;
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(11);
        return (value & 2) != 0;
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(11);
        return (value & 4) != 0;
    }

    public boolean supportsColumnAliasing() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(92);
        return (value & 1) != 0;
    }

    public boolean supportsConvert() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(130);
        return (value & 1) != 0;
    }

    private int mapTypeJdbcSIIA(int jdbcType) {
        switch (jdbcType) {
            case 5: {
                return 16;
            }
            case 4: {
                return 8;
            }
            case -5: {
                return 16384;
            }
            case 6: {
                return 32;
            }
            case 7: {
                return 64;
            }
            case 8: {
                return 128;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
            case 1: {
                return 1;
            }
            case 12: {
                return 256;
            }
            case -1: {
                return 512;
            }
            case 91: {
                return 32768;
            }
            case 92: {
                return 65536;
            }
            case 93: {
                return 131072;
            }
            case -2: {
                return 1024;
            }
            case -3: {
                return 2048;
            }
            case -4: {
                return 262144;
            }
        }
        return 0;
    }

    private int mapTypeJdbcSIIA2(int jdbcType) {
        switch (jdbcType) {
            case 5: {
                return 145;
            }
            case 4: {
                return 142;
            }
            case -5: {
                return 138;
            }
            case 6: {
                return 141;
            }
            case 7: {
                return 144;
            }
            case 8: {
                return 140;
            }
            case 2: {
                return 143;
            }
            case 3: {
                return 139;
            }
            case 1: {
                return 146;
            }
            case 12: {
                return 147;
            }
            case -1: {
                return 123;
            }
            case 91: {
                return 135;
            }
            case 92: {
                return 136;
            }
            case 93: {
                return 137;
            }
            case -2: {
                return 127;
            }
            case -3: {
                return 128;
            }
            case -4: {
                return 122;
            }
        }
        return 0;
    }

    public boolean supportsConvert(int parm1, int parm2) throws SQLException {
        boolean from_ok = false;
        boolean to_ok = false;
        int v = 0;
        if (parm1 == 0 || this.mapTypeJdbcSIIA2(parm1) > 0) {
            from_ok = true;
            v = parm1 != 0 ? this.con.acquireServerInfo().getInt(this.mapTypeJdbcSIIA2(parm1)) : Integer.MAX_VALUE;
        }
        to_ok = parm2 == 0 || (v & this.mapTypeJdbcSIIA(parm2)) != 0;
        return from_ok && to_ok;
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(75);
        return (value & 0x10) != 0;
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(77);
        return value == 2;
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(77);
        return value == 1;
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(96);
        return value == 1;
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(60);
        return (value & 4) != 0;
    }

    public boolean supportsGroupBy() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(33);
        return value != 0;
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(33);
        return value == 2;
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(33);
        return value == 3;
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(100);
        return value != 0;
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(60);
        return value != 0;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(106);
        return value != 0;
    }

    public boolean supportsOuterJoins() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(60);
        return value != 0;
    }

    public boolean supportsPositionedDelete() throws SQLException {
        return true;
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        return true;
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(120);
        return (value & 1) != 0;
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(120);
        return (value & 8) != 0;
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(120);
        return (value & 0x10) != 0;
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(120);
        return (value & 2) != 0;
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(120);
        return (value & 4) != 0;
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    public boolean supportsStoredProcedures() throws SQLException {
        int value = this.con.acquireServerInfo().getInt(108);
        return value == 1;
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    public boolean supportsTransactionIsolationLevel(int parm1) throws SQLException {
        switch (parm1) {
            default: {
                throw new DbException(3, "" + parm1);
            }
            case 0: {
                return false;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
        }
        int value = this.con.acquireServerInfo().getInt(78);
        return (parm1 & value) == parm1;
    }

    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    public boolean supportsUnion() throws SQLException {
        return true;
    }

    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    static void testResultSetType(int type) throws SQLException {
        switch (type) {
            case 1003: 
            case 1004: 
            case 1005: {
                break;
            }
            default: {
                throw new DbException(20, Integer.toString(type));
            }
        }
    }

    static void testConcurrency(int conc) throws SQLException {
        switch (conc) {
            case 1007: 
            case 1008: {
                break;
            }
            default: {
                throw new DbException(22, Integer.toString(conc));
            }
        }
    }

    public boolean deletesAreDetected(int type) throws SQLException {
        DatabaseMetaDataImpl.testResultSetType(type);
        return false;
    }

    public Connection getConnection() throws SQLException {
        return this.con;
    }

    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        String str = "select type_cat, type_schem, type_name, class_name, data_type, remarks from jdbc_30_42_1.getudts";
        Statement stmt = this.con.createStatement();
        return stmt.executeQuery(str);
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        DatabaseMetaDataImpl.testResultSetType(type);
        return false;
    }

    public boolean othersDeletesAreVisible(int type) throws SQLException {
        DatabaseMetaDataImpl.testResultSetType(type);
        return false;
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        DatabaseMetaDataImpl.testResultSetType(type);
        return false;
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        DatabaseMetaDataImpl.testResultSetType(type);
        return false;
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        DatabaseMetaDataImpl.testResultSetType(type);
        return false;
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        DatabaseMetaDataImpl.testResultSetType(type);
        return false;
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        DatabaseMetaDataImpl.testResultSetType(type);
        return false;
    }

    public boolean supportsBatchUpdates() throws SQLException {
        int value;
        block2: {
            value = 0;
            try {
                value = this.con.acquireServerInfo().getInt(8);
            }
            catch (DbException e) {
                DbException u = new DbException(43);
                if (e.getErrorCode() == u.getErrorCode()) break block2;
                throw e;
            }
        }
        return value != 0;
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        DatabaseMetaDataImpl.testConcurrency(concurrency);
        switch (concurrency) {
            case 1007: {
                return this.supportsResultSetType(type);
            }
        }
        return false;
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        DatabaseMetaDataImpl.testResultSetType(type);
        switch (type) {
            case 1003: {
                return true;
            }
        }
        return false;
    }

    public boolean updatesAreDetected(int type) throws SQLException {
        DatabaseMetaDataImpl.testResultSetType(type);
        return false;
    }

    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        String qry = "SELECT type_cat, type_schem, type_name, supertype_cat, supertype_schem, supertype_name FROM jdbc_30_42_1.getsupertypes WHERE type_cat like ? AND type_schem LIKE ? AND type_name LIKE ?";
        PreparedStatement pstmt = this.con.prepareStatement(qry);
        pstmt.setString(1, catalog);
        pstmt.setString(2, schemaPattern);
        pstmt.setString(3, typeNamePattern);
        ResultSet rs = pstmt.executeQuery();
        return rs;
    }

    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        String qry = "SELECT table_cat, table_schem, table_name, supertable_name FROM jdbc_30_42_1.getsupertables WHERE table_cat LIKE ? AND table_schem LIKE ? AND table_name LIKE ?";
        PreparedStatement pstmt = this.con.prepareStatement(qry);
        pstmt.setString(1, catalog);
        pstmt.setString(2, schemaPattern);
        pstmt.setString(3, tableNamePattern);
        ResultSet rs = pstmt.executeQuery();
        return rs;
    }

    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        String qry = "SELECT type_cat, type_schem, type_name, attr_name data_type, attr_type_name, attr_size, decimal_digits, num_prec_radix, nullable, remarks, attr_def, sql_data_type, sql_datetime_sub, char_octet_length, ordinal_position, is_nullable, scope_catalog, scope_schema, scope_table, source_data_type FROM jdbc_30_42_1.getattributes WHERE type_cat LIKE ? AND type_schem LIKE ? AND type_name LIKE ? AND attr_name LIKE ?";
        PreparedStatement pstmt = this.con.prepareStatement(qry);
        pstmt.setString(1, catalog);
        pstmt.setString(2, schemaPattern);
        pstmt.setString(3, typeNamePattern);
        pstmt.setString(4, attributeNamePattern);
        ResultSet rs = pstmt.executeQuery();
        return rs;
    }

    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        switch (holdability) {
            case 2: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        return false;
    }

    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    private void getDbVersion() throws SQLException {
        if (!this.gotVersion) {
            String dbVersion = this.getDatabaseProductVersion();
            StringTokenizer t = new StringTokenizer(dbVersion, ". (\t");
            try {
                this.dbMajor = Integer.parseInt(t.nextToken());
                this.dbMinor += Integer.parseInt(t.nextToken()) * 10000;
                this.dbMinor += Integer.parseInt(t.nextToken()) * 100;
                this.dbMinor += Integer.parseInt(t.nextToken());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.gotVersion = true;
        }
    }

    public int getDatabaseMajorVersion() throws SQLException {
        this.getDbVersion();
        return this.dbMajor;
    }

    public int getDatabaseMinorVersion() throws SQLException {
        this.getDbVersion();
        return this.dbMinor;
    }

    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    public int getSQLStateType() throws SQLException {
        return 1;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    public boolean supportsStatementPooling() throws SQLException {
        return true;
    }

    public ResultSet getExPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT table_cat, table_schem, table_name, ");
        sb.append("column_name, key_seq, pk_name, data_type, type_name, ");
        sb.append("column_size, decimal_digits, nullable ");
        sb.append(" FROM ");
        sb.append(jschema);
        sb.append(".getexprimarykeys ");
        sb.append("WHERE ");
        sb.append("table_name LIKE '");
        sb.append(table);
        sb.append("' ");
        if (schema != null) {
            sb.append(" AND table_schem LIKE '");
            sb.append(schema);
            sb.append("' ");
        }
        sb.append("ORDER BY table_cat, table_schem, table_name, key_seq");
        Statement stmt = this.con.createStatement();
        ResultSet rs = stmt.executeQuery(sb.toString());
        return rs;
    }

    private String getWhereClause(Object[][] desc) {
        int s = desc.length;
        String str = "";
        boolean where = true;
        for (int c = 0; c < s; ++c) {
            if (desc[c][0] == null) continue;
            if (where) {
                str = str + "where ";
                where = false;
            } else {
                str = str + "and ";
            }
            str = str + desc[c][1] + " ";
            str = desc[c][0] == "" && (Boolean)desc[c][3] != false ? str + desc[c][2] + " user " : str + desc[c][2] + " '" + this.duplicateQuote((String)desc[c][0]) + "' ";
        }
        return str;
    }

    private String duplicateQuote(String str) {
        StringBuffer sb = new StringBuffer(str);
        int len = str.length();
        for (int c = 0; c < len; ++c) {
            if (sb.charAt(c) != '\'') continue;
            sb.insert(c, '\'');
            ++len;
            ++c;
        }
        return sb.toString();
    }

    private int siiaToJdbc(int siiaCode) throws SQLException {
        switch (siiaCode) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 8: {
                return 8;
            }
        }
        throw new DbException(23, Integer.toString(siiaCode));
    }

    static void testHoldability(int holdability) throws SQLException {
        switch (holdability) {
            case 2: {
                break;
            }
            default: {
                throw new DbException(52);
            }
        }
    }

    public static void main(String[] args) {
        try {
            String url = args[0];
            Class.forName("com.sun.hadb.jdbc.Driver");
            Connection con = DriverManager.getConnection(url);
            DatabaseMetaDataImpl.printstuff(con);
            System.out.println("closing connection");
            con.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void printstuff(Connection con) throws SQLException {
        int TFO = 1003;
        int TSI = 1004;
        int TSS = 1005;
        int CUP = 1008;
        DatabaseMetaData md = con.getMetaData();
        System.out.println("allProceduresAreCallable:             <" + md.allProceduresAreCallable() + ">");
        System.out.println("allTablesAreSelectable:               <" + md.allTablesAreSelectable() + ">");
        System.out.println("dataDefinitionCausesTransactionCommit:<" + md.dataDefinitionCausesTransactionCommit() + ">");
        System.out.println("dataDefinitionIgnoredInTransactions:  <" + md.dataDefinitionIgnoredInTransactions() + ">");
        System.out.println("deletesAreDetected:                   <" + md.deletesAreDetected(TFO) + ">");
        System.out.println("doesMaxRowSizeIncludeBlobs:           <" + md.doesMaxRowSizeIncludeBlobs() + ">");
        ResultSet rsbri = md.getBestRowIdentifier(null, null, "ttt", 0, true);
        System.out.println("getBestRowIdentifier(n,n,'ttt',0,t):");
        while (rsbri.next()) {
            short scope = rsbri.getShort("SCOPE");
            String column_name = rsbri.getString("column_name");
            short data_type = rsbri.getShort("data_type");
            String type_name = rsbri.getString("type_name");
            int column_size = rsbri.getInt("column_size");
            int buffer_length = rsbri.getInt("buffer_length");
            short decimal_digits = rsbri.getShort("decimal_digits");
            short pseudo_column = rsbri.getShort("pseudo_column");
            System.out.println("   <" + scope + "><" + column_name + "><" + data_type + "><" + type_name + "><" + column_size + "><" + buffer_length + "><" + decimal_digits + "><" + pseudo_column + ">");
        }
        System.out.println("getCatalogs                           <" + md.getCatalogs() + ">");
        ResultSet rscat = md.getCatalogs();
        while (rscat.next()) {
            String table_cat = rscat.getString("table_cat");
            System.out.println("table_cat=<" + table_cat + ">");
        }
        System.out.println("getCatalogSeparator                   <" + md.getCatalogSeparator() + ">");
        System.out.println("getCatalogTerm                        <" + md.getCatalogTerm() + ">");
        ResultSet rscpr = md.getColumnPrivileges(null, null, "ttt", null);
        System.out.println("getColumnPrivileges(n,n,'ttt',0,t):");
        while (rscpr.next()) {
            String table_cat = rscpr.getString("table_cat");
            String table_schem = rscpr.getString("table_schem");
            String table_name = rscpr.getString("table_name");
            String column_name = rscpr.getString("column_name");
            String grantor = rscpr.getString("grantor");
            String grantee = rscpr.getString("grantee");
            String privilege = rscpr.getString("privilege");
            String is_grantable = rscpr.getString("is_grantable");
            System.out.println("   <" + table_cat + "><" + table_schem + "><" + table_name + "><" + column_name + "><" + grantor + "><" + grantee + "><" + privilege + "><" + is_grantable + ">");
        }
        ResultSet rscol = md.getColumns(null, null, "ttt", null);
        System.out.println("getColumns(n,n,'ttt',0,t):");
        while (rscol.next()) {
            String table_cat = rscol.getString("table_cat");
            String table_schem = rscol.getString("table_schem");
            String table_name = rscol.getString("table_name");
            String column_name = rscol.getString("column_name");
            short data_type = rscol.getShort("data_type");
            String type_name = rscol.getString("type_name");
            int column_size = rscol.getInt("column_size");
            int buffer_length = rscol.getInt("buffer_length");
            short decimal_digits = rscol.getShort("decimal_digits");
            short num_prec_radix = rscol.getShort("num_prec_radix");
            short nullable = rscol.getShort("nullable");
            String remarks = rscol.getString("remarks");
            String column_def = rscol.getString("column_def");
            short sql_data_type = rscol.getShort("sql_data_type");
            short sql_datetime_sub = rscol.getShort("sql_datetime_sub");
            int char_octet_length = rscol.getInt("char_octet_length");
            int ordinal_position = rscol.getInt("ordinal_position");
            String is_nullable = rscol.getString("is_nullable");
            System.out.println("   <" + table_cat + "><" + table_schem + "><" + table_name + "><" + column_name + "><" + data_type + "><" + type_name + "><" + column_size + "><" + buffer_length + "><" + decimal_digits + "><" + num_prec_radix + "><" + nullable + "><" + remarks + "><" + column_def + "><" + sql_data_type + "><" + sql_datetime_sub + "><" + char_octet_length + "><" + ordinal_position + "><" + is_nullable + ">");
        }
        System.out.println("getCrossReference                     <" + md.getCrossReference(null, "", "ttt", null, null, null) + ">");
        System.out.println("getDatabaseProductName                <" + md.getDatabaseProductName() + ">");
        System.out.println("getDatabaseProductVersion             <" + md.getDatabaseProductVersion() + ">");
        System.out.println("getDefaultTransactionIsolation        <" + md.getDefaultTransactionIsolation() + ">");
        System.out.println("getDriverMajorVersion                 <" + md.getDriverMajorVersion() + ">");
        System.out.println("getDriverMinorVersion                 <" + md.getDriverMinorVersion() + ">");
        System.out.println("getDriverName                         <" + md.getDriverName() + ">");
        System.out.println("getDriverVersion                      <" + md.getDriverVersion() + ">");
        System.out.println("getExportedKeys                       <" + md.getExportedKeys(null, "", "ttt") + ">");
        System.out.println("getExtraNameCharacters                <" + md.getExtraNameCharacters() + ">");
        System.out.println("getIdentifierQuoteString              <" + md.getIdentifierQuoteString() + ">");
        System.out.println("getImportedKeys                       <" + md.getImportedKeys(null, "", "ttt") + ">");
        ResultSet rsinx = md.getIndexInfo(null, null, "ttt", false, false);
        System.out.println("getIndexInfo(n,n,'ttt',false,false):");
        while (rsinx.next()) {
            String table_cat = rsinx.getString("table_cat");
            String table_schem = rsinx.getString("table_schem");
            String table_name = rsinx.getString("table_name");
            short non_unique = rsinx.getShort("non_unique");
            String index_qualifier = rsinx.getString("index_qualifier");
            String index_name = rsinx.getString("index_name");
            short type = rsinx.getShort("type");
            short ordinal_position = rsinx.getShort("ordinal_position");
            String column_name = rsinx.getString("column_name");
            String asc_or_desc = rsinx.getString("asc_or_desc");
            int cardinality = rsinx.getInt("cardinality");
            boolean car_wasnull = rsinx.wasNull();
            int pages = rsinx.getInt("pages");
            boolean pag_wasnull = rsinx.wasNull();
            String filter_condition = rsinx.getString("filter_condition");
            System.out.println("   <" + table_cat + "><" + table_schem + "><" + table_name + "><" + non_unique + "><" + index_qualifier + "><" + index_name + "><" + type + "><" + ordinal_position + "><" + column_name + "><" + asc_or_desc + "><" + (car_wasnull ? "null" : new Integer(cardinality).toString()) + "><" + (pag_wasnull ? "null" : new Integer(pages).toString()) + "><" + filter_condition + ">");
        }
        System.out.println("getMaxBinaryLiteralLength             <" + md.getMaxBinaryLiteralLength() + ">");
        System.out.println("getMaxCatalogNameLength               <" + md.getMaxCatalogNameLength() + ">");
        System.out.println("getMaxCharLiteralLength               <" + md.getMaxCharLiteralLength() + ">");
        System.out.println("getMaxColumnNameLength                <" + md.getMaxColumnNameLength() + ">");
        System.out.println("getMaxColumnsInGroupBy                <" + md.getMaxColumnsInGroupBy() + ">");
        System.out.println("getMaxColumnsInIndex                  <" + md.getMaxColumnsInIndex() + ">");
        System.out.println("getMaxColumnsInOrderBy                <" + md.getMaxColumnsInOrderBy() + ">");
        System.out.println("getMaxColumnsInSelect                 <" + md.getMaxColumnsInSelect() + ">");
        System.out.println("getMaxColumnsInTable                  <" + md.getMaxColumnsInTable() + ">");
        System.out.println("getMaxConnections                     <" + md.getMaxConnections() + ">");
        System.out.println("getMaxCursorNameLength                <" + md.getMaxCursorNameLength() + ">");
        System.out.println("getMaxIndexLength                     <" + md.getMaxIndexLength() + ">");
        System.out.println("getMaxProcedureNameLength             <" + md.getMaxProcedureNameLength() + ">");
        System.out.println("getMaxRowSize                         <" + md.getMaxRowSize() + ">");
        System.out.println("getMaxSchemaNameLength                <" + md.getMaxSchemaNameLength() + ">");
        System.out.println("getMaxStatementLength                 <" + md.getMaxStatementLength() + ">");
        System.out.println("getMaxStatements                      <" + md.getMaxStatements() + ">");
        System.out.println("getMaxTableNameLength                 <" + md.getMaxTableNameLength() + ">");
        System.out.println("getMaxTablesInSelect                  <" + md.getMaxTablesInSelect() + ">");
        System.out.println("getMaxUserNameLength                  <" + md.getMaxUserNameLength() + ">");
        System.out.println("getNumericFunctions                   <" + md.getNumericFunctions() + ">");
        ResultSet rspky = md.getPrimaryKeys(null, null, "ttt");
        System.out.println("getPrimaryKeys(n,n,'ttt'):");
        while (rspky.next()) {
            String table_cat = rspky.getString("table_cat");
            String table_schem = rspky.getString("table_schem");
            String table_name = rspky.getString("table_name");
            String column_name = rspky.getString("column_name");
            short key_seq = rspky.getShort("key_seq");
            String pk_name = rspky.getString("pk_name");
            System.out.println("   <" + table_cat + "><" + table_schem + "><" + table_name + "><" + column_name + "><" + key_seq + "><" + pk_name + ">");
        }
        rspky.close();
        System.out.println("getProcedureColumns(n,n,n,n)          <" + md.getProcedureColumns(null, null, null, null) + ">");
        System.out.println("getProcedures(n,n,n)                  <" + md.getProcedures(null, null, null) + ">");
        System.out.println("getProcedureTerm                      <" + md.getProcedureTerm() + ">");
        ResultSet rssch = md.getSchemas();
        System.out.println("getSchemas():");
        while (rssch.next()) {
            String table_schem = rssch.getString("table_schem");
            System.out.println("   <" + table_schem + ">");
        }
        rssch.close();
        System.out.println("getSchemaTerm                         <" + md.getSchemaTerm() + ">");
        System.out.println("getSearchStringEscape                 <" + md.getSearchStringEscape() + ">");
        System.out.println("getSQLKeywords                        <" + md.getSQLKeywords() + ">");
        System.out.println("getStringFunctions                    <" + md.getStringFunctions() + ">");
        System.out.println("getSystemFunctions                    <" + md.getSystemFunctions() + ">");
        ResultSet rstpr = md.getTablePrivileges(null, null, "ttt");
        System.out.println("getTablePrivileges(n,n,'ttt'):");
        while (rstpr.next()) {
            String table_cat = rstpr.getString("table_cat");
            String table_schem = rstpr.getString("table_schem");
            String table_name = rstpr.getString("table_name");
            String grantor = rstpr.getString("grantor");
            String grantee = rstpr.getString("grantee");
            String privilege = rstpr.getString("privilege");
            String is_grantable = rstpr.getString("is_grantable");
            System.out.println("   <" + table_cat + "><" + table_schem + "><" + table_name + "><" + grantor + "><" + grantee + "><" + privilege + "><" + is_grantable + ">");
        }
        rstpr.close();
        ResultSet rstab = md.getTables(null, null, "ttt", null);
        System.out.println("getTables(n,n,'ttt',n):");
        while (rstab.next()) {
            String table_cat = rstab.getString("table_cat");
            String table_schem = rstab.getString("table_schem");
            String table_name = rstab.getString("table_name");
            String table_type = rstab.getString("table_type");
            String remarks = rstab.getString("remarks");
            System.out.println("   <" + table_cat + "><" + table_schem + "><" + table_name + "><" + table_type + "><" + remarks + ">");
        }
        rstab.close();
        ResultSet rstty = md.getTableTypes();
        String rsttstr = "";
        while (rstty.next()) {
            rsttstr = rsttstr + rstty.getString("TABLE_TYPE");
            if (rstty.isLast()) continue;
            rsttstr = rsttstr + ",";
        }
        rstty.close();
        System.out.println("getTableTypes                         <" + rsttstr + ">");
        System.out.println("getTimeDateFunctions                  <" + md.getTimeDateFunctions() + ">");
        ResultSet rstyp = md.getTypeInfo();
        System.out.println("getTypeInfo():");
        while (rstyp.next()) {
            String type_name = rstyp.getString("type_name");
            short data_type = rstyp.getShort("data_type");
            short precision = rstyp.getShort("precision");
            String literal_prefix = rstyp.getString("literal_prefix");
            String literal_suffix = rstyp.getString("literal_suffix");
            String create_params = rstyp.getString("create_params");
            int nullable = rstyp.getInt("nullable");
            short case_sensitive = rstyp.getShort("case_sensitive");
            short searchable = rstyp.getShort("searchable");
            short unsigned_attribute = rstyp.getShort("unsigned_attribute");
            short fixed_prec_scale = rstyp.getShort("fixed_prec_scale");
            short auto_increment = rstyp.getShort("auto_increment");
            String local_type_name = rstyp.getString("local_type_name");
            short minimum_scale = rstyp.getShort("minimum_scale");
            short maximum_scale = rstyp.getShort("maximum_scale");
            int sql_data_type = rstyp.getInt("sql_data_type");
            int sql_datetime_sub = rstyp.getInt("sql_datetime_sub");
            int num_prec_radix = rstyp.getInt("num_prec_radix");
            System.out.println("   <" + type_name + "><" + data_type + "><" + precision + "><" + literal_prefix + "><" + literal_suffix + "><" + create_params + "><" + nullable + "><" + case_sensitive + "><" + searchable + "><" + unsigned_attribute + "><" + fixed_prec_scale + "><" + auto_increment + "><" + local_type_name + "><" + minimum_scale + "><" + maximum_scale + "><" + sql_data_type + "><" + sql_datetime_sub + "><" + num_prec_radix + ">");
        }
        rstyp.close();
        System.out.println("getUDTs(n,n,n,n)                      <" + md.getUDTs(null, null, null, null) + ">");
        System.out.println("getURL                                <" + md.getURL() + ">");
        System.out.println("getUserName                           <" + md.getUserName() + ">");
        ResultSet rsvcs = md.getVersionColumns(null, null, "ttt");
        System.out.println("getVersionColumns(n,n,'ttt'):");
        while (rsvcs.next()) {
            short scope = rsvcs.getShort("scope");
            String column_name = rsvcs.getString("column_name");
            short data_type = rsvcs.getShort("data_type");
            String type_name = rsvcs.getString("type_name");
            int column_size = rsvcs.getInt("column_size");
            int buffer_length = rsvcs.getInt("buffer_length");
            short decimal_digits = rsvcs.getShort("decimal_digits");
            short pseudo_column = rsvcs.getShort("pseudo_column");
            System.out.println("   <" + scope + "><" + column_name + "><" + data_type + "><" + type_name + "><" + column_size + "><" + buffer_length + "><" + decimal_digits + "><" + pseudo_column + ">");
        }
        System.out.println("insertsAreDetected                    <" + md.insertsAreDetected(1003) + ">");
        System.out.println("isCatalogAtStart                      <" + md.isCatalogAtStart() + ">");
        System.out.println("isReadOnly                            <" + md.isReadOnly() + ">");
        System.out.println("nullPlusNonNullIsNull                 <" + md.nullPlusNonNullIsNull() + ">");
        System.out.println("nullsAreSortedAtEnd                   <" + md.nullsAreSortedAtEnd() + ">");
        System.out.println("nullsAreSortedAtStart                 <" + md.nullsAreSortedAtStart() + ">");
        System.out.println("nullsAreSortedHigh                    <" + md.nullsAreSortedHigh() + ">");
        System.out.println("nullsAreSortedLow                     <" + md.nullsAreSortedLow() + ">");
        System.out.println("othersDeletesAreVisible               <" + md.othersDeletesAreVisible(TFO) + ">");
        System.out.println("othersInsertsAreVisible               <" + md.othersInsertsAreVisible(TFO) + ">");
        System.out.println("othersUpdatesAreVisible               <" + md.othersUpdatesAreVisible(TFO) + ">");
        System.out.println("ownDeletesAreVisible                  <" + md.ownDeletesAreVisible(TFO) + ">");
        System.out.println("ownInsertsAreVisible                  <" + md.ownInsertsAreVisible(TFO) + ">");
        System.out.println("ownUpdatesAreVisible                  <" + md.ownUpdatesAreVisible(TFO) + ">");
        System.out.println("storesLowerCaseIdentifiers            <" + md.storesLowerCaseIdentifiers() + ">");
        System.out.println("storesLowerCaseQuotedIdentifiers      <" + md.storesLowerCaseQuotedIdentifiers() + ">");
        System.out.println("storesMixedCaseIdentifiers            <" + md.storesMixedCaseIdentifiers() + ">");
        System.out.println("storesMixedCaseQuotedIdentifiers      <" + md.storesMixedCaseQuotedIdentifiers() + ">");
        System.out.println("storesUpperCaseIdentifiers            <" + md.storesUpperCaseIdentifiers() + ">");
        System.out.println("storesUpperCaseQuotedIdentifiers      <" + md.storesUpperCaseQuotedIdentifiers() + ">");
        System.out.println("supportsAlterTableWithAddColumn       <" + md.supportsAlterTableWithAddColumn() + ">");
        System.out.println("supportsAlterTableWithDropColumn      <" + md.supportsAlterTableWithDropColumn() + ">");
        System.out.println("supportsANSI92EntryLevelSQL           <" + md.supportsANSI92EntryLevelSQL() + ">");
        System.out.println("supportsANSI92FullSQL                 <" + md.supportsANSI92FullSQL() + ">");
        System.out.println("supportsANSI92IntermediateSQL         <" + md.supportsANSI92IntermediateSQL() + ">");
        System.out.println("supportsBatchUpdates                  <" + md.supportsBatchUpdates() + ">");
        System.out.println("supportsCatalogsInDataManipulation    <" + md.supportsCatalogsInDataManipulation() + ">");
        System.out.println("supportsCatalogsInIndexDefinitions    <" + md.supportsCatalogsInIndexDefinitions() + ">");
        System.out.println("supportsCatalogsInPrivilegeDefinitions<" + md.supportsCatalogsInPrivilegeDefinitions() + ">");
        System.out.println("supportsCatalogsInProcedureCalls      <" + md.supportsCatalogsInProcedureCalls() + ">");
        System.out.println("supportsCatalogsInTableDefinitions    <" + md.supportsCatalogsInTableDefinitions() + ">");
        System.out.println("supportsColumnAliasing                <" + md.supportsColumnAliasing() + ">");
        System.out.println("supportsConvert                       <" + md.supportsConvert() + ">");
        System.out.println("supportsConvert(TIMESTAMP,CHAR)       <" + md.supportsConvert(93, 1) + ">");
        System.out.println("supportsCoreSQLGrammar                <" + md.supportsCoreSQLGrammar() + ">");
        System.out.println("supportsCorrelatedSubqueries          <" + md.supportsCorrelatedSubqueries() + ">");
        System.out.println("supportsDataDefinitionAndDataManipulationTransactions<" + md.supportsDataDefinitionAndDataManipulationTransactions() + ">");
        System.out.println("supportsDataManipulationTransactionsOnly<" + md.supportsDataManipulationTransactionsOnly() + ">");
        System.out.println("supportsDifferentTableCorrelationNames<" + md.supportsDifferentTableCorrelationNames() + ">");
        System.out.println("supportsExpressionsInOrderBy          <" + md.supportsExpressionsInOrderBy() + ">");
        System.out.println("supportsExtendedSQLGrammar            <" + md.supportsExtendedSQLGrammar() + ">");
        System.out.println("supportsFullOuterJoins                <" + md.supportsFullOuterJoins() + ">");
        System.out.println("supportsGroupBy                       <" + md.supportsGroupBy() + ">");
        System.out.println("supportsGroupByBeyondSelect           <" + md.supportsGroupByBeyondSelect() + ">");
        System.out.println("supportsGroupByUnrelated              <" + md.supportsGroupByUnrelated() + ">");
        System.out.println("supportsIntegrityEnhancementFacility  <" + md.supportsIntegrityEnhancementFacility() + ">");
        System.out.println("supportsLikeEscapeClause              <" + md.supportsLikeEscapeClause() + ">");
        System.out.println("supportsLimitedOuterJoins             <" + md.supportsLimitedOuterJoins() + ">");
        System.out.println("supportsMinimumSQLGrammar             <" + md.supportsMinimumSQLGrammar() + ">");
        System.out.println("supportsMixedCaseIdentifiers          <" + md.supportsMixedCaseIdentifiers() + ">");
        System.out.println("supportsMixedCaseQuotedIdentifiers    <" + md.supportsMixedCaseQuotedIdentifiers() + ">");
        System.out.println("supportsMultipleResultSets            <" + md.supportsMultipleResultSets() + ">");
        System.out.println("supportsMultipleTransactions          <" + md.supportsMultipleTransactions() + ">");
        System.out.println("supportsNonNullableColumns            <" + md.supportsNonNullableColumns() + ">");
        System.out.println("supportsOpenCursorsAcrossCommit       <" + md.supportsOpenCursorsAcrossCommit() + ">");
        System.out.println("supportsOpenCursorsAcrossRollback     <" + md.supportsOpenCursorsAcrossRollback() + ">");
        System.out.println("supportsOpenStatementsAcrossCommit    <" + md.supportsOpenStatementsAcrossCommit() + ">");
        System.out.println("supportsOpenStatementsAcrossRollback  <" + md.supportsOpenStatementsAcrossRollback() + ">");
        System.out.println("supportsOrderByUnrelated              <" + md.supportsOrderByUnrelated() + ">");
        System.out.println("supportsOuterJoins                    <" + md.supportsOuterJoins() + ">");
        System.out.println("supportsPositionedDelete              <" + md.supportsPositionedDelete() + ">");
        System.out.println("supportsPositionedUpdate              <" + md.supportsPositionedUpdate() + ">");
        System.out.println("supportsResultSetConcurrency          <" + md.supportsResultSetConcurrency(TFO, CUP) + ">");
        System.out.println("supportsResultSetType(TFO)            <" + md.supportsResultSetType(TFO) + ">");
        System.out.println("supportsResultSetType(TSI)            <" + md.supportsResultSetType(TSI) + ">");
        System.out.println("supportsResultSetType(TSS)            <" + md.supportsResultSetType(TSS) + ">");
        System.out.println("supportsSchemasInDataManipulation     <" + md.supportsSchemasInDataManipulation() + ">");
        System.out.println("supportsSchemasInIndexDefinitions     <" + md.supportsSchemasInIndexDefinitions() + ">");
        System.out.println("supportsSchemasInPrivilegeDefinitions <" + md.supportsSchemasInPrivilegeDefinitions() + ">");
        System.out.println("supportsSchemasInProcedureCalls       <" + md.supportsSchemasInProcedureCalls() + ">");
        System.out.println("supportsSchemasInTableDefinitions     <" + md.supportsSchemasInTableDefinitions() + ">");
        System.out.println("supportsSelectForUpdate               <" + md.supportsSelectForUpdate() + ">");
        System.out.println("supportsStoredProcedures              <" + md.supportsStoredProcedures() + ">");
        System.out.println("supportsSubqueriesInComparisons       <" + md.supportsSubqueriesInComparisons() + ">");
        System.out.println("supportsSubqueriesInExists            <" + md.supportsSubqueriesInExists() + ">");
        System.out.println("supportsSubqueriesInIns               <" + md.supportsSubqueriesInIns() + ">");
        System.out.println("supportsSubqueriesInQuantifieds       <" + md.supportsSubqueriesInQuantifieds() + ">");
        System.out.println("supportsTableCorrelationNames         <" + md.supportsTableCorrelationNames() + ">");
        System.out.println("supportsTransactionIsolationLevel(0)  <" + md.supportsTransactionIsolationLevel(0) + ">");
        System.out.println("supportsTransactionIsolationLevel(1)  <" + md.supportsTransactionIsolationLevel(1) + ">");
        System.out.println("supportsTransactionIsolationLevel(2)  <" + md.supportsTransactionIsolationLevel(2) + ">");
        System.out.println("supportsTransactionIsolationLevel(4)  <" + md.supportsTransactionIsolationLevel(4) + ">");
        System.out.println("supportsTransactionIsolationLevel(8)  <" + md.supportsTransactionIsolationLevel(8) + ">");
        System.out.println("supportsTransactions                  <" + md.supportsTransactions() + ">");
        System.out.println("supportsUnion                         <" + md.supportsUnion() + ">");
        System.out.println("supportsUnionAll                      <" + md.supportsUnionAll() + ">");
        System.out.println("updatesAreDetected                    <" + md.updatesAreDetected(TFO) + ">");
        System.out.println("usesLocalFilePerTable                 <" + md.usesLocalFilePerTable() + ">");
        System.out.println("usesLocalFiles                        <" + md.usesLocalFiles() + ">");
    }
}

