/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.comm.ExtData;
import com.sun.hadb.comm.RPCAttrDescr;
import com.sun.hadb.jdbc.Column;
import com.sun.hadb.jdbc.DbException;
import com.sun.hadb.jdbc.ParameterTuple;
import com.sun.hadb.jdbc.Tuple;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.StringTokenizer;

class DateColumn
extends Column {
    DateColumn(RPCAttrDescr att, int fieldNo) throws SQLException {
        super(att, fieldNo);
    }

    int getColumnDisplaySize() {
        return 10;
    }

    int getColumnType() {
        return 91;
    }

    String getColumnTypeName() {
        return "DATE";
    }

    Object getObject(Tuple r) throws SQLException {
        return this.getDate(r);
    }

    String getClassName() throws SQLException {
        return "java.sql.Date";
    }

    String getString(Tuple r) throws SQLException {
        if (this.checkCluNull(r)) {
            return null;
        }
        return r.getField(this.fieldNo).getDate(0);
    }

    Date getDate(Tuple r) throws SQLException {
        String str = this.getString(r);
        if (str == null) {
            return null;
        }
        return Date.valueOf(str);
    }

    Timestamp getTimestamp(Tuple r) throws SQLException {
        String str = this.getString(r);
        if (str == null) {
            return null;
        }
        return Timestamp.valueOf(str + " 00:00:00.000000000");
    }

    Date getDate(Tuple r, Calendar parm2) throws SQLException {
        return this.getDate(r);
    }

    Timestamp getTimestamp(Tuple r, Calendar parm2) throws SQLException {
        return Timestamp.valueOf(this.getDate(r, parm2).toString() + " 00:00:00.000000000");
    }

    long getLong(Tuple r) throws SQLException {
        throw new DbException(5);
    }

    BigDecimal getBigDecimal(Tuple r) throws SQLException {
        throw new DbException(5);
    }

    BigDecimal getBigDecimal(Tuple r, int scale) throws SQLException {
        throw new DbException(5);
    }

    boolean getBoolean(Tuple r) throws SQLException {
        throw new DbException(5);
    }

    public static boolean validDate(long year, long month, long day) {
        return year > 0L && month > 0L && day > 0L && year < 10000L && month < 13L && day < 32L;
    }

    void setString(ParameterTuple r, String str) throws SQLException {
        if (str == null) {
            this.setNull(r, this.getColumnType());
            return;
        }
        ExtData p = r.allocField(this.fieldNo, 4);
        StringTokenizer tk = new StringTokenizer(str, "-");
        try {
            long yearval = new Long(tk.nextToken());
            long monthval = new Long(tk.nextToken());
            long dayval = new Long(tk.nextToken());
            if (tk.hasMoreTokens() || !DateColumn.validDate(yearval, monthval, dayval)) {
                throw new DbException(33, "'" + str + "' not accepted as a date");
            }
            p.setDate(yearval, monthval, dayval, 0);
        }
        catch (Exception e) {
            throw new DbException(33, "'" + str + "' not accepted as a date", e);
        }
    }

    void setDate(ParameterTuple r, Date date) throws SQLException {
        if (date == null) {
            this.setNull(r, this.getColumnType());
            return;
        }
        this.setString(r, date.toString());
    }

    void setTimestamp(ParameterTuple r, Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            this.setNull(r, this.getColumnType());
            return;
        }
        String str = timestamp.toString();
        StringTokenizer tk = new StringTokenizer(str, "- ");
        ExtData p = r.allocField(this.fieldNo, 4);
        try {
            p.setDate(new Long(tk.nextToken()), new Long(tk.nextToken()), new Long(tk.nextToken()), 0);
        }
        catch (Exception e) {
            throw new DbException(33, "'" + str + "' not accepted as a date");
        }
    }
}

