/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.comm.CommException;
import com.sun.hadb.comm.RPCStatus;
import java.io.PrintStream;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class DbException
extends SQLException {
    private static final int BASE = 20000;
    public static final int NOT_USED = 0;
    public static final int INTERNAL = 1;
    public static final int NOT_IMPLEMENTED = 2;
    public static final int ILLEGAL_ISOLATION = 3;
    public static final int CON_CLOSED = 4;
    public static final int TYPE_MISMATCH = 5;
    public static final int INVALID_CHAR_FOR_CAST = 6;
    public static final int TRUNCATED_READ = 7;
    public static final int NUMERIC_VALUE_OUT_OF_RANGE = 8;
    public static final int ILLEGAL_ON_FORWARD_ONLY = 9;
    public static final int PARAMETER_NOT_NULLABLE = 10;
    public static final int INVALID_ROW = 11;
    public static final int RESULT_SET_IS_CLOSED = 12;
    public static final int ILL_COL_INDEX = 13;
    public static final int ILL_PAR_INDEX = 14;
    public static final int UNKNOWN_DATATYPE = 15;
    public static final int FIND_COLUMN_FAILED = 16;
    public static final int DATETIME_FIELD_OVERFLOW = 17;
    public static final int INVALID_URL = 18;
    public static final int INVALID_USE_OF_NULL = 19;
    public static final int INVALID_RESULT_SET_TYPE = 20;
    public static final int ARGUMENT_NOT_ALLOWED = 21;
    public static final int INVALID_CONCURRENCY = 22;
    public static final int ILL_ISL_CODE = 23;
    public static final int STM_NOT_UPDATE = 24;
    public static final int STM_NOT_QUERY = 25;
    public static final int STM_HAS_PARAM = 26;
    public static final int ILL_MAX_FLD_SIZE = 27;
    public static final int ILL_MAX_ROWS = 28;
    public static final int ILL_TIMEOUT = 29;
    public static final int STM_IS_CLOSED = 30;
    public static final int BAD_NUMBER = 31;
    public static final int STRING_DATA_TRUNCATION_ERROR = 32;
    public static final int INVALID_DATETIME_FORMAT = 33;
    public static final int INTERVAL_FIELD_OVERFLOW = 34;
    public static final int UNSUPPORTED_ENCODING = 35;
    public static final int FETCH_FORWARD = 36;
    public static final int ILLEGAL_FETCH_SIZE = 37;
    public static final int ILLEGAL_FETCH_DIRECTION = 38;
    public static final int FETCH_SIZE_LARGER_THAN_MAXROWS = 39;
    public static final int NO_PARAMETERS = 40;
    public static final int PAR_NOT_SET = 41;
    public static final int NO_BATCH = 42;
    public static final int SIIA_UNSUPPORTED = 43;
    public static final int NO_USERNAME = 44;
    public static final int NO_PASSWORD = 45;
    public static final int NO_HOSTLIST = 46;
    public static final int NO_CPDS = 47;
    public static final int DSERROR = 48;
    public static final int BATCHED_NOT_ADDED = 49;
    public static final int STM_IS_BATCH = 50;
    public static final int HOST_NOT_FOUND = 51;
    public static final int HOLDABILITY_NOT_SUPPORTED = 52;
    public static final int SAVEPOINTS_NOT_SUPPORTED = 53;
    public static final int NOSUCHTABLE = 54;
    public static final int NO_BATCH_WITH_LOB = 55;
    public static final int INVALID_CAST_FOR_LOB = 56;
    public static final int OPERATION_NOT_SUPPORTED = 57;
    public static final int LOB_TOO_LARGE = 58;
    public static final int INCONSISTENT_LOB_SIZE = 59;
    public static final int LOB_INVALID_CON_STATE = 60;
    public static final int INV_TRANS_STATE_ACTIVE = 61;
    public static final int INVALID_CURSOR_STATE = 62;
    private static final String[] errtable = new String[]{"HY000 NOT_USED", "HY000 INTERNAL", "HYC00 NOT_IMPLEMENTED", "HY096 ILLEGAL_ISOLATION", "08003 CON_CLOSED", "2200G TYPE_MISMATCH", "22018 INVALID_CHAR_FOR_CAST", "01S07 TRUNCATED_READ", "22003 NUMERIC_VALUE_OUT_OF_RANGE", "HY109 ILLEGAL_ON_FORWARD_ONLY", "23000 PARAMETER_NOT_NULLABLE", "24000 INVALID_ROW", "HY010 RESULT_SET_IS_CLOSED", "07009 ILL_COL_INDEX", "07009 ILL_PAR_INDEX", "0A000 UNKNOWN_DATATYPE", "07009 FIND_COLUMN_FAILED", "22008 DATETIME_FIELD_OVERFLOW", "HY000 INVALID_URL", "HY009 INVALID_USE_OF_NULL", "HY000 INVALID_RESULT_SET_TYPE", "22023 ARGUMENT_NOT_ALLOWED", "HY000 INVALID_CONCURRENCY", "HY000 ILL_ISL_CODE", "HY000 STM_NOT_UPDATE", "HY000 STM_NOT_QUERY", "HY000 STM_HAS_PARAM", "HY024 ILL_MAX_FLD_SIZE", "HY024 ILL_MAX_ROWS", "HY024 ILL_TIMEOUT", "HY010 STM_IS_CLOSED", "22018 BAD_NUMBER", "22001 STRING_DATA_TRUNCATION_ERROR", "22007 INVALID_DATETIME_FORMAT", "22015 INTERVAL_FIELD_OVERFLOW", "HY000 UNSUPPORTED_ENCODING", "HY000 FETCH_FORWARD", "HY000 ILLEGAL_FETCH_SIZE", "HY000 ILLEGAL_FETCH_DIRECTION", "HY000 FETCH_SIZE_LARGER_THAN_MAXROWS", "23010 NO_PARAMETERS", "23020 PAR_NOT_SET", "HY000 NO_BATCH", "HY000 SIIA_UNSUPPORTED", "HY000 NO_USERNAME", "HY000 NO_PASSWORD", "HY000 NO_HOSTLIST", "HY000 NO_CPDS", "HY000 DSERROR", "23015 BATCHED_NOT_ADDED", "HY000 STM_IS_BATCH", "HY000 HOST_NOT_FOUND", "HY000 HOLDABILITY_NOT_SUPPORTED", "HY000 SAVEPOINTS_NOT_SUPPORTED", "HY000 NOSUCHTABLE", "HY000 NO_BATCH_WITH_LOB", "HY000 INVALID_CAST_FOR_LOB", "HY000 OPERATION_NOT_SUPPORTED", "HY000 LOB_TOO_LARGE", "HY000 INCONSISTENT_LOB_SIZE", "HY000 LOB_INVALID_CON_STATE", "25001 INV_TRANS_STATE_ACTIVE", "24000 INVALID_CURSOR_STATE", "HY000 UNUSED"};
    private static final String TECHRA_CODE = "HY000";

    private static String errorMessage(int i) {
        String key = errtable[i].substring(6);
        String message = null;
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle("com.sun.hadb.jdbc.DbException", Locale.getDefault());
        }
        catch (MissingResourceException e) {
            try {
                bundle = ResourceBundle.getBundle("com.sun.hadb.jdbc.DbException");
            }
            catch (MissingResourceException a) {
                // empty catch block
            }
        }
        message = bundle == null ? "Unknown error. Could not load message string table" : bundle.getString(errtable[i].substring(6));
        return message;
    }

    private static String sqlCode(int i) {
        return errtable[i].substring(0, 5);
    }

    public DbException(int errno) {
        super(DbException.errorMessage(errno), DbException.sqlCode(errno), errno + 20000);
    }

    public DbException(int errno, Exception e) {
        super(DbException.errorMessage(errno) + ": " + e.toString(), DbException.sqlCode(errno), errno + 20000);
        this.initCause(e);
    }

    public DbException(int errno, String arg) {
        super(DbException.errorMessage(errno) + ": " + arg, DbException.sqlCode(errno), errno + 20000);
    }

    public DbException(int errno, String arg, Exception e) {
        super(DbException.errorMessage(errno) + ": " + arg + ": " + e.toString(), DbException.sqlCode(errno), errno + 20000);
        this.initCause(e);
    }

    public DbException(RPCStatus rpc_status) {
        super(rpc_status.getErrorMessage(), rpc_status.getSQLState(), (int)rpc_status.getMainStatus());
    }

    public DbException(CommException e) {
        super(e.getMessage(), e.getSQLState(), e.getErrorCode());
        this.initCause(e);
    }

    private static String getCauseMsg(Exception e) {
        if (e.getCause() != null && e.getCause() instanceof DbException) {
            return e.getCause().getMessage();
        }
        return DbException.errorMessage(1);
    }

    private static String getCauseSql(Exception e) {
        if (e.getCause() != null && e.getCause() instanceof DbException) {
            return ((DbException)e.getCause()).getSQLState();
        }
        return DbException.sqlCode(1);
    }

    private static int getCauseCode(Exception e) {
        if (e.getCause() != null && e.getCause() instanceof DbException) {
            return ((DbException)e.getCause()).getErrorCode();
        }
        return 20001;
    }

    public DbException(Exception e) {
        super(DbException.getCauseMsg(e), DbException.getCauseSql(e), DbException.getCauseCode(e));
        this.initCause(e);
    }

    public DbException(RPCStatus rpc_status, CommException e) {
        super(rpc_status.getErrorMessage(), rpc_status.getSQLState(), (int)rpc_status.getMainStatus());
        this.initCause(e);
    }

    static SQLWarning toWarning(SQLException ex) {
        return new SQLWarning(ex.getMessage(), ex.getSQLState(), ex.getErrorCode());
    }

    static SQLWarning toWarning(RPCStatus status) {
        if (status.isError() && status.getSeverity() == 2L) {
            return new SQLWarning(status.getErrorMessage(), status.getSQLState(), (int)status.getMainStatus());
        }
        return null;
    }

    static SQLWarning toWarning(int errno) {
        return new SQLWarning(DbException.errorMessage(errno), DbException.sqlCode(errno), errno + 20000);
    }

    static SQLWarning toWarning(int errno, String arg) {
        return new SQLWarning(DbException.errorMessage(errno) + ": " + arg, DbException.sqlCode(errno), errno + 20000);
    }

    static void listExceptions(PrintStream s) {
        s.println("JDBC Driver Exceptions:");
        for (int i = 0; i < errtable.length; ++i) {
            s.println("" + (20000 + i) + ": " + DbException.sqlCode(i) + " : " + DbException.errorMessage(i));
        }
        s.println("\nCommunication Layer Exceptions:");
        CommException.listExceptions(s);
    }
}

