/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.comm.ExtData;
import com.sun.hadb.comm.RPCAttrDescr;
import com.sun.hadb.jdbc.DbException;
import com.sun.hadb.jdbc.NumericColumn;
import com.sun.hadb.jdbc.ParameterTuple;
import com.sun.hadb.jdbc.Tuple;
import java.sql.SQLException;

class FloatColumn
extends NumericColumn {
    FloatColumn(RPCAttrDescr att, int fieldNo) throws SQLException {
        super(att, fieldNo);
    }

    int getExtSize() throws SQLException {
        return this.getColumnType() == 6 ? 4 : 8;
    }

    int getColumnDisplaySize() {
        return 15;
    }

    int getColumnType() throws SQLException {
        switch (this.att.getMain()) {
            case 5: {
                return 6;
            }
            case 6: {
                return 8;
            }
        }
        throw new DbException(1, "Invalid metadata");
    }

    String getColumnTypeName() throws SQLException {
        switch (this.att.getMain()) {
            case 5: {
                return "REAL";
            }
            case 6: {
                return "DOUBLE PRECISION";
            }
        }
        throw new DbException(1, "Invalid metadata");
    }

    Number getNumber(Tuple r) throws SQLException {
        boolean isNull = this.checkCluNull(r);
        switch (this.att.getMain()) {
            case 5: {
                return isNull ? new Float(0.0f) : new Float(Float.intBitsToFloat(r.getField(this.fieldNo).getInt32(0)));
            }
            case 6: {
                return isNull ? new Double(0.0) : new Double(Double.longBitsToDouble(r.getField(this.fieldNo).getInt64(0)));
            }
        }
        throw new DbException(1, "Invalid metadata");
    }

    String getClassName() throws SQLException {
        switch (this.att.getMain()) {
            case 5: {
                return "java.lang.Float";
            }
            case 6: {
                return "java.lang.Double";
            }
        }
        throw new DbException(1, "Invalid metadata");
    }

    void setNumber(ParameterTuple r, Number n) throws SQLException {
        if (n == null) {
            this.setNull(r, this.getColumnType());
            return;
        }
        int fieldSize = this.getExtSize();
        ExtData p = r.allocField(this.fieldNo, fieldSize);
        switch (fieldSize) {
            case 4: {
                p.putInt32(Float.floatToIntBits(n.floatValue()), 0);
                break;
            }
            case 8: {
                p.putInt64(Double.doubleToLongBits(n.doubleValue()), 0);
                break;
            }
            default: {
                throw new DbException(1, "Invalid field size : " + fieldSize);
            }
        }
    }
}

