/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.jdbc.DbException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;

public class LobInputStream
extends InputStream {
    private long size;
    private int bytesConsumed = 0;
    private ResultSet rs;
    private byte[] barr = null;
    private int curptr = 0;

    public LobInputStream(ResultSet rs, long size) {
        this.rs = rs;
        this.size = size;
    }

    public synchronized void close() throws IOException {
        this.rs = null;
        this.barr = null;
    }

    public boolean markSupported() {
        return false;
    }

    public int available() throws IOException {
        return 0;
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (this.rs == null) {
            throw new IOException("Stream is closed");
        }
        try {
            return this.readArray(b, off, len);
        }
        catch (SQLException e) {
            IOException ne = new IOException(e.toString());
            ne.initCause(e);
            throw ne;
        }
    }

    public synchronized int read() throws IOException {
        if (this.rs == null) {
            throw new IOException("Stream is closed");
        }
        try {
            return this.readByte();
        }
        catch (SQLException e) {
            IOException ne = new IOException(e.toString());
            ne.initCause(e);
            throw ne;
        }
    }

    public synchronized long skip(long n) throws IOException {
        if (this.rs == null) {
            throw new IOException("Stream is closed");
        }
        try {
            return this.skipBytes(n);
        }
        catch (SQLException e) {
            IOException ne = new IOException(e.toString());
            ne.initCause(e);
            throw ne;
        }
    }

    synchronized long skipBytes(long n) throws SQLException {
        long bytesToSkip;
        long skipped = 0L;
        for (long left = n; left > 0L; left -= bytesToSkip) {
            if (!this.advanceInBlob()) {
                if ((long)this.bytesConsumed != this.size) {
                    throw new DbException(59);
                }
                return skipped;
            }
            long leftInBarr = this.barr.length - this.curptr;
            bytesToSkip = left < leftInBarr ? left : leftInBarr;
            this.curptr = (int)((long)this.curptr + bytesToSkip);
            skipped += bytesToSkip;
            this.bytesConsumed = (int)((long)this.bytesConsumed + bytesToSkip);
        }
        return skipped;
    }

    synchronized int readArray(byte[] b, int off, int sz) throws SQLException {
        int pos = 0;
        int left = sz;
        while (left > 0) {
            if (!this.advanceInBlob()) {
                if ((long)this.bytesConsumed != this.size) {
                    throw new DbException(59);
                }
                return pos;
            }
            int leftInBarr = this.barr.length - this.curptr;
            int bytesToCopy = left < leftInBarr ? left : leftInBarr;
            System.arraycopy(this.barr, this.curptr, b, pos, bytesToCopy);
            this.curptr += bytesToCopy;
            pos += bytesToCopy;
            left -= bytesToCopy;
            this.bytesConsumed += bytesToCopy;
        }
        return pos;
    }

    private int readByte() throws SQLException {
        if (!this.advanceInBlob()) {
            if ((long)this.bytesConsumed != this.size) {
                throw new DbException(59);
            }
            return -1;
        }
        int res = this.barr[this.curptr++];
        ++this.bytesConsumed;
        if (res < 0) {
            res = 256 + res;
        }
        return res;
    }

    private boolean advanceInBlob() throws SQLException {
        if (this.barr == null || this.curptr >= this.barr.length) {
            if (this.rs == null || !this.rs.next()) {
                return false;
            }
            this.barr = this.rs.getBytes("lob_data");
            if (this.barr == null) {
                return false;
            }
            this.curptr = 0;
            if (this.barr.length == 0) {
                return false;
            }
        }
        return true;
    }
}

