/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

public class NumberParser {
    private static final int T_EXPMARK = 1;
    private static final int T_PLUS = 2;
    private static final int T_MINUS = 3;
    private static final int T_DECPOINT = 4;
    private static final int T_DIGIT = 5;
    private static final int T_UNKNOWN = 6;

    public static char[] parse(String s, int precision, int scale) throws ArithmeticException, NumberFormatException {
        int i;
        char[] inbuf = s.toCharArray();
        int isign = 1;
        int esign = 1;
        int slen = inbuf.length;
        int ilen = 0;
        int dlen = 0;
        int elen = 0;
        int estart = -1;
        int dstart = -1;
        int istart = -1;
        int state = 0;
        block10: for (int i2 = 0; i2 < slen; ++i2) {
            char c = inbuf[i2];
            int type = NumberParser.getType(c);
            if (type == 6) {
                throw new NumberFormatException(s);
            }
            switch (state) {
                case 0: {
                    if (type == 2) {
                        isign = 1;
                        state = 1;
                        continue block10;
                    }
                    if (type == 3) {
                        isign = -1;
                        state = 1;
                        continue block10;
                    }
                    if (type == 4) {
                        state = 3;
                        continue block10;
                    }
                    if (type == 5) {
                        state = 1;
                    } else {
                        throw new NumberFormatException(s);
                    }
                }
                case 1: {
                    if (type == 5) {
                        istart = i2;
                        ++ilen;
                        state = 2;
                        continue block10;
                    }
                    if (type == 4) {
                        state = 3;
                        continue block10;
                    }
                    throw new NumberFormatException(s);
                }
                case 2: {
                    if (type == 5) {
                        ++ilen;
                        continue block10;
                    }
                    if (type == 4) {
                        state = 3;
                        continue block10;
                    }
                    if (type == 1) {
                        state = 5;
                        continue block10;
                    }
                    throw new NumberFormatException(s);
                }
                case 3: {
                    if (type == 5) {
                        ++dlen;
                        dstart = i2;
                        state = 4;
                        continue block10;
                    }
                    if (type == 1) {
                        state = 5;
                        continue block10;
                    }
                    throw new NumberFormatException(s);
                }
                case 4: {
                    if (type == 5) {
                        ++dlen;
                        continue block10;
                    }
                    if (type == 1) {
                        state = 5;
                        continue block10;
                    }
                    throw new NumberFormatException(s);
                }
                case 5: {
                    if (type == 2) {
                        esign = 1;
                        state = 6;
                        continue block10;
                    }
                    if (type == 3) {
                        esign = -1;
                        state = 6;
                        continue block10;
                    }
                    if (type == 5) {
                        state = 6;
                    } else {
                        throw new NumberFormatException(s);
                    }
                }
                case 6: {
                    if (type == 5) {
                        estart = i2;
                        ++elen;
                        state = 7;
                        continue block10;
                    }
                    throw new NumberFormatException(s);
                }
                case 7: {
                    if (type == 5) {
                        ++elen;
                        continue block10;
                    }
                    throw new NumberFormatException(s);
                }
            }
        }
        if (elen > 0) {
            int i3;
            int exp = NumberParser.calcExponent(inbuf, estart, elen);
            StringBuffer sb = new StringBuffer();
            if (esign > 0) {
                int i4;
                if (isign < 0) {
                    sb.append('-');
                }
                for (i3 = 0; i3 < ilen; ++i3) {
                    sb.append(inbuf[istart + i3]);
                }
                int pos = 0;
                for (i4 = 0; i4 < exp; ++i4) {
                    if (i4 < dlen) {
                        sb.append(inbuf[dstart + i4]);
                    } else {
                        sb.append('0');
                    }
                    ++pos;
                }
                if (pos < dlen) {
                    sb.append('.');
                    for (i4 = pos; i4 < dlen; ++i4) {
                        sb.append(inbuf[dstart + i4]);
                    }
                }
            } else {
                for (i3 = 0; i3 < dlen; ++i3) {
                    sb.append(inbuf[dstart + dlen - i3 - 1]);
                }
                for (i3 = 0; i3 < exp; ++i3) {
                    if (i3 >= ilen) {
                        sb.append('0');
                        continue;
                    }
                    sb.append(inbuf[istart + ilen - i3 - 1]);
                }
                if (exp >= ilen) {
                    sb.append(".0");
                } else {
                    sb.append(".");
                    for (i3 = 0; i3 < ilen - exp; ++i3) {
                        sb.append(inbuf[istart + ilen - exp - i3 - 1]);
                    }
                }
                if (isign < 0) {
                    sb.append('-');
                }
                sb = sb.reverse();
            }
            return NumberParser.parse(sb.toString(), precision, scale);
        }
        int intdigits = precision - scale;
        if (ilen > intdigits) {
            if (ilen == 1 && inbuf[istart] == '0') {
                --ilen;
            } else {
                throw new ArithmeticException("Number out of range");
            }
        }
        int pos = 0;
        int blen = precision + 1;
        if (blen % 2 != 0) {
            ++blen;
            ++intdigits;
        }
        char[] buf = new char[blen];
        for (i = 0; i < intdigits - ilen; ++i) {
            buf[pos] = 48;
            ++pos;
        }
        for (i = 0; i < ilen; ++i) {
            buf[pos] = inbuf[istart + i];
            ++pos;
        }
        for (i = 0; i < scale; ++i) {
            buf[pos] = i >= dlen ? 48 : inbuf[dstart + i];
            ++pos;
        }
        buf[pos] = isign > 0 ? 60 : 59;
        return buf;
    }

    private static int getType(char c) {
        if (c == 'E' || c == 'e') {
            return 1;
        }
        if (c == '.') {
            return 4;
        }
        if (c == '-') {
            return 3;
        }
        if (c == '+') {
            return 2;
        }
        if (Character.isDigit(c)) {
            return 5;
        }
        return 6;
    }

    private static int calcExponent(char[] buf, int start, int count) throws NumberFormatException {
        int exp = 0;
        int decade = 1;
        for (int i = start + count - 1; i >= start; --i) {
            int val = buf[i] - 48;
            if (val < 0 || val > 9) {
                throw new NumberFormatException("Invalid digit in exponent");
            }
            exp += val * decade;
            decade *= 10;
        }
        return exp;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.err.println("usage: NumberParser <string> <precision> <scale>");
        } else {
            int prec = Integer.parseInt(args[1]);
            int scale = Integer.parseInt(args[2]);
            System.out.println(new String(NumberParser.parse(args[0], prec, scale)));
        }
    }
}

