/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.comm.ExtData;
import com.sun.hadb.comm.MessageBuffer;
import com.sun.hadb.comm.MessageChunk;
import com.sun.hadb.comm.MessageChunkByteArray;
import com.sun.hadb.comm.UnsignedByteBuffer;
import com.sun.hadb.jdbc.DbException;
import com.sun.hadb.jdbc.JdbcLogFactory;
import com.sun.hadb.jdbc.SmallintColumn;
import com.sun.hadb.jdbc.Tuple;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.DataTruncation;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

class ParameterTuple
extends Tuple {
    MessageChunk[] fieldChunks = null;
    MessageChunk headerChunk = null;
    boolean[] isNull = null;
    private int lobcount = 0;
    private InputStream[] lobstreams = null;
    private long[] lobstreamlengths = null;
    private MessageChunk alignChunk = null;
    static final int PAD_NONE = -1;
    static final int PAD_NULL = 0;
    static final int PAD_SPACE = 1;
    private Logger logger = JdbcLogFactory.getJDBCLogger();

    ParameterTuple(int fieldCount, int lobcount) {
        this.fieldChunks = new MessageChunk[fieldCount];
        this.isNull = new boolean[fieldCount];
        this.alignChunk = new MessageChunkByteArray();
        this.alignChunk.appendUInt8(0);
        for (int i = 0; i < fieldCount; ++i) {
            this.isNull[i] = false;
        }
        this.lobcount = lobcount;
        if (lobcount > 0) {
            this.lobstreams = new InputStream[lobcount];
            this.lobstreamlengths = new long[lobcount];
        }
    }

    public Object clone() {
        int fieldCount = this.fieldChunks.length;
        ParameterTuple clone = new ParameterTuple(fieldCount, this.lobcount);
        for (int i = 0; i < fieldCount; ++i) {
            clone.isNull[i] = this.isNull[i];
            if (this.fieldChunks[i] == null) continue;
            clone.fieldChunks[i] = (MessageChunk)this.fieldChunks[i].clone();
        }
        return clone;
    }

    public ExtData getField(int n) {
        return this.fieldChunks[n] == null ? null : this.fieldChunks[n].getAsExtData();
    }

    public int getFieldSize(int n) {
        if (n >= this.fieldChunks.length) {
            return 0;
        }
        return this.fieldChunks[n] == null ? 0 : this.fieldChunks[n].size();
    }

    public int getFieldCount() {
        return this.fieldChunks.length;
    }

    public InputStream[] getLobStreams() {
        return this.lobstreams;
    }

    public long[] getLobStreamLengths() {
        return this.lobstreamlengths;
    }

    public int getLobCount() {
        return this.lobcount;
    }

    public void setLobStream(int lobno, InputStream ls, long length) {
        if (this.lobstreams != null) {
            this.lobstreams[lobno] = ls;
            this.lobstreamlengths[lobno] = length;
        }
    }

    protected boolean checkCluNull(int fieldno) {
        if (fieldno >= this.isNull.length) {
            return false;
        }
        return this.isNull[fieldno];
    }

    public int size() {
        int size = 4;
        for (int i = 0; i < this.getFieldCount(); ++i) {
            size += 2 + this.getFieldSize(i);
        }
        return size;
    }

    public String toString() {
        if (this.headerChunk == null) {
            this.createHeader();
        }
        ExtData h = new ExtData(this.headerChunk);
        String s = h.toHexString();
        for (int i = 0; i < this.getFieldCount(); ++i) {
            ExtData p = this.getField(i);
            s = s + (p == null ? "[]" : "[" + p.toHexString() + "]");
        }
        return s;
    }

    private void createHeader() {
        int headersize = 2 + 2 * this.getFieldCount() + 2;
        this.headerChunk = new MessageChunkByteArray(headersize + 2);
        this.headerChunk.appendUInt16(this.size());
        ExtData p = new ExtData(this.headerChunk.allocate(headersize), 2);
        p.putInt16((short)0, 0);
        int fieldOffset = headersize;
        for (int i = 0; i < this.getFieldCount() + 1; ++i) {
            int putval = this.checkCluNull(i) ? fieldOffset - 32768 : fieldOffset;
            p.putInt16((short)putval, 2 + i * 2);
            fieldOffset = (short)(fieldOffset + this.getFieldSize(i));
        }
    }

    public void appendToMessageBuffer(MessageBuffer buf) {
        this.createHeader();
        buf.append(this.headerChunk);
        for (int i = 0; i < this.getFieldCount(); ++i) {
            if (this.fieldChunks[i] == null) continue;
            buf.append(this.fieldChunks[i]);
        }
        if (this.size() % 2 == 1) {
            buf.append(this.alignChunk);
        }
    }

    public MessageBuffer asMessageBuffer() {
        MessageBuffer buf = new MessageBuffer();
        this.appendToMessageBuffer(buf);
        return buf;
    }

    public ExtData allocField(int fieldno, int size) {
        this.isNull[fieldno] = false;
        this.fieldChunks[fieldno] = new MessageChunkByteArray(size + 1);
        return this.fieldChunks[fieldno].allocate(size);
    }

    void setCluNull(int fieldno) {
        this.allocField(fieldno, 0);
        this.isNull[fieldno] = true;
    }

    private void padSpace(UnsignedByteBuffer buf, int offset, int len) {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("padSpace, offset = " + offset + ", length = " + len);
        }
        for (int i = 0; i < len; ++i) {
            buf.putUInt8(32, offset++);
        }
    }

    private void padNULL(UnsignedByteBuffer buf, int offset, int len) {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("padNULL, offset = " + offset + ", length = " + len);
        }
        for (int i = 0; i < len; ++i) {
            buf.putUInt8(0, offset++);
        }
    }

    int setStream(int fieldno, int columnlen, InputStream x, int streamlen, int padMode, int type) throws SQLException {
        if (x == null) {
            this.setCluNull(fieldno);
            return -1;
        }
        if (streamlen > columnlen) {
            throw new DataTruncation(fieldno + 1, true, false, streamlen, columnlen);
        }
        int allocSpace = padMode == -1 ? streamlen : columnlen;
        ExtData ptr = this.allocField(fieldno, allocSpace);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("setStream, allocSpace = " + allocSpace + ", columnlen = " + columnlen + ", streamlen = " + streamlen);
        }
        int readlen = 0;
        try {
            block1 : switch (type) {
                case 2: {
                    while (readlen < streamlen) {
                        int val = x.read();
                        if (val < 0) break block1;
                        if (val > 127) {
                            throw new DbException(35, "Unicode[" + val + "] to ISO8859-1");
                        }
                        ptr.putUInt8(val, readlen++);
                    }
                    break;
                }
                default: {
                    readlen = ptr.putByteStream(x, streamlen, 0);
                }
            }
        }
        catch (IOException ex) {
            throw new DbException(ex);
        }
        switch (padMode) {
            case 0: {
                this.padNULL(ptr, streamlen, columnlen - streamlen);
                break;
            }
            case 1: {
                this.padSpace(ptr, streamlen, columnlen - streamlen);
                break;
            }
        }
        return readlen;
    }

    int setReader(int fieldno, int columnlen, Reader x, int readerlen, int padMode) throws SQLException {
        if (x == null) {
            this.setCluNull(fieldno);
            return -1;
        }
        if (readerlen > columnlen) {
            throw new DataTruncation(fieldno + 1, true, false, readerlen, columnlen);
        }
        int allocSpace = padMode == -1 ? readerlen : columnlen;
        ExtData ptr = this.allocField(fieldno, allocSpace);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("setReader, allocSpace = " + allocSpace + ", columnlen = " + columnlen + ", readerlen = " + readerlen);
        }
        int readlen = 0;
        try {
            int val;
            while (readlen < readerlen && (val = x.read()) >= 0) {
                if ((val & 0xFF00) != 0) {
                    throw new DbException(35, "char[" + val + "] to ISO8859-1");
                }
                ptr.putUInt8(val, readlen++);
            }
        }
        catch (IOException ex) {
            throw new DbException(ex);
        }
        switch (padMode) {
            case 0: {
                this.padNULL(ptr, readerlen, columnlen - readerlen);
                break;
            }
            case 1: {
                this.padSpace(ptr, readerlen, columnlen - readerlen);
                break;
            }
        }
        return readlen;
    }

    void setCluChar(int fieldno, int len, String x, int padMode) throws SQLException {
        if (x == null) {
            this.setCluNull(fieldno);
            return;
        }
        StringReader reader = new StringReader(x);
        this.setReader(fieldno, len, reader, x.length(), padMode);
    }

    void setCluBinary(int fieldno, int len, byte[] x, int padMode) throws SQLException {
        if (x == null) {
            this.setCluNull(fieldno);
            return;
        }
        if (x.length > len) {
            throw new DataTruncation(fieldno + 1, true, false, x.length, len);
        }
        int allocSpace = padMode == -1 ? x.length : len;
        ExtData ptr = this.allocField(fieldno, allocSpace);
        ptr.putBytes(x, 0);
        if (x.length < len) {
            switch (padMode) {
                case 0: {
                    this.padNULL(ptr, x.length, len - x.length);
                    break;
                }
                case 1: {
                    this.padSpace(ptr, x.length, len - x.length);
                    break;
                }
            }
        }
    }

    void setCluBinary(int fieldno, int len, String hexstr, int padMode) throws SQLException {
        if (hexstr == null) {
            this.setCluNull(fieldno);
            return;
        }
        byte[] dest = new byte[hexstr.length()];
        for (int i = 0; i < dest.length; ++i) {
            dest[i] = (byte)Character.digit(hexstr.charAt(i), 16);
            if (dest[i] != -1) continue;
            throw new DbException(6);
        }
        this.setCluBinary(fieldno, len, dest, padMode);
    }

    public static void main(String[] args) {
        ParameterTuple t = new ParameterTuple(5, 0);
        try {
            SmallintColumn c = new SmallintColumn(null, 0);
            c.setInt(t, 32763);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        System.out.println(t.toString());
    }
}

