/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.jdbc.DbException;
import com.sun.hadb.jdbc.StatementImpl;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.ListIterator;

class StatementPool {
    private LinkedList pool;
    private int maxSize;

    public StatementPool(int size) throws SQLException {
        this.setPoolSize(size);
        this.pool = new LinkedList();
    }

    synchronized StatementImpl getPooledStatement(String sql, long schema) {
        ListIterator li = this.pool.listIterator(0);
        while (li.hasNext()) {
            Entry e = (Entry)li.next();
            if (!e.sql.equals(sql) || e.schema != schema) continue;
            li.remove();
            return e.pstmt;
        }
        return null;
    }

    synchronized void addToPool(StatementImpl pstmt, String sql, long schema) throws SQLException {
        while (this.pool.size() >= this.maxSize) {
            StatementImpl stmt = ((Entry)this.pool.removeLast()).pstmt;
            stmt.doClose(false, null, 0L);
        }
        if (this.maxSize > 0) {
            Entry e = new Entry();
            e.pstmt = pstmt;
            e.sql = sql;
            e.schema = schema;
            this.pool.addFirst(e);
        } else {
            pstmt.doClose(false, null, 0L);
        }
    }

    synchronized void clearPool(boolean close) {
        if (close) {
            ListIterator li = this.pool.listIterator(0);
            while (li.hasNext()) {
                Entry e = (Entry)li.next();
                try {
                    e.pstmt.doClose(false, null, 0L);
                }
                catch (SQLException ex) {}
            }
        }
        this.pool.clear();
    }

    synchronized void setPoolSize(int size) throws SQLException {
        if (size < 0) {
            throw new DbException(1, "setPoolSize(size<0)");
        }
        this.maxSize = size;
    }

    public synchronized int getPoolSize() {
        return this.maxSize;
    }

    static class Entry {
        public StatementImpl pstmt;
        public String sql;
        public long schema;

        Entry() {
        }
    }
}

