/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import java.util.Date;

public final class Statistics
implements Cloneable {
    private boolean delta = false;
    private long time = System.currentTimeMillis();
    private long bytesSent = 0L;
    private long bytesReceived = 0L;
    private long requests = 0L;
    private int peakBytesSent = 0;
    private int peakBytesReceived = 0;

    public String toString() {
        return (this.delta ? "Interval:          " + (double)this.time / 1000.0 + "seconds" : "Start date:        " + new Date(this.time)) + "\nTotal requests: " + this.requests + "\nBytes sent:     " + this.bytesSent + ",     " + this.bytesSent / this.requests + " per request, " + this.peakBytesSent + " peak" + "\nBytes received: " + this.bytesReceived + ",     " + this.bytesReceived / this.requests + " per request, " + this.peakBytesReceived + " peak";
    }

    public static Statistics difference(Statistics a, Statistics b) {
        Statistics r = new Statistics();
        r.time = a.time - b.time;
        r.bytesSent = a.bytesSent - b.bytesSent;
        r.bytesReceived = a.bytesReceived - b.bytesReceived;
        r.requests = a.requests - b.requests;
        r.peakBytesSent = a.peakBytesSent - b.peakBytesSent;
        r.peakBytesReceived = a.peakBytesReceived - b.peakBytesReceived;
        r.delta = true;
        return r;
    }

    public void add(Statistics s) {
        this.time = Math.min(this.time, s.time);
        this.bytesSent += s.bytesSent;
        this.bytesReceived += s.bytesReceived;
        this.requests += s.requests;
        this.peakBytesSent = Math.max(this.peakBytesSent, s.peakBytesSent);
        this.peakBytesReceived = Math.max(this.peakBytesReceived, s.peakBytesReceived);
    }

    public void request(int sent, int received) {
        this.bytesSent += (long)sent;
        this.bytesReceived += (long)received;
        ++this.requests;
        this.peakBytesSent = Math.max(this.peakBytesSent, sent);
        this.peakBytesReceived = Math.max(this.peakBytesReceived, received);
    }
}

