/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.comm.ExtData;
import com.sun.hadb.comm.RPCAttrDescr;
import com.sun.hadb.jdbc.Column;
import com.sun.hadb.jdbc.DateColumn;
import com.sun.hadb.jdbc.DbException;
import com.sun.hadb.jdbc.ParameterTuple;
import com.sun.hadb.jdbc.TimeColumn;
import com.sun.hadb.jdbc.Tuple;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.StringTokenizer;

class TimestampColumn
extends Column {
    TimestampColumn(RPCAttrDescr att, int fieldNo) throws SQLException {
        super(att, fieldNo);
    }

    int getColumnDisplaySize() {
        return 26;
    }

    int getColumnType() {
        return 93;
    }

    String getColumnTypeName() {
        return "TIMESTAMP";
    }

    Object getObject(Tuple r) throws SQLException {
        return this.getTimestamp(r);
    }

    String getClassName() throws SQLException {
        return "java.sql.Timestamp";
    }

    String getString(Tuple r) throws SQLException {
        if (this.checkCluNull(r)) {
            return null;
        }
        return r.getField(this.fieldNo).getTimeStamp(0);
    }

    Date getDate(Tuple r) throws SQLException {
        if (this.checkCluNull(r)) {
            return null;
        }
        return Date.valueOf(r.getField(this.fieldNo).getDate(0, true));
    }

    Time getTime(Tuple r) throws SQLException {
        if (this.checkCluNull(r)) {
            return null;
        }
        Timestamp ts = Timestamp.valueOf("1970-01-01 " + r.getField(this.fieldNo).getTime(0));
        return new Time(ts.getTime());
    }

    Timestamp getTimestamp(Tuple r) throws SQLException {
        if (this.checkCluNull(r)) {
            return null;
        }
        return Timestamp.valueOf(this.getString(r));
    }

    void setString(ParameterTuple r, String str) throws SQLException {
        if (str == null) {
            this.setNull(r, this.getColumnType());
            return;
        }
        StringTokenizer tk = new StringTokenizer(str, "-");
        try {
            long yearval = new Long(tk.nextToken());
            long monthval = new Long(tk.nextToken());
            tk = new StringTokenizer(tk.nextToken(), " ");
            long dayval = new Long(tk.nextToken());
            tk = new StringTokenizer(tk.nextToken(), ":");
            long hourval = new Long(tk.nextToken());
            long minuteval = new Long(tk.nextToken());
            tk = new StringTokenizer(tk.nextToken(), ".");
            long secondval = new Long(tk.nextToken());
            String nanos = tk.hasMoreElements() ? tk.nextToken() : "0";
            nanos = nanos + "000000000";
            String us = nanos.substring(0, 6);
            String trunc = nanos.substring(6, 9);
            if (trunc.compareTo("000") != 0) {
                this.accessor.addWarning(new DataTruncation(this.fieldNo + 1, true, false, str.length(), 26));
            }
            long microsec = new Long(us);
            if (!DateColumn.validDate(yearval, monthval, dayval) || !TimeColumn.validTime(hourval, minuteval, secondval, microsec) || tk.hasMoreElements()) {
                throw new DbException(33, "'" + str + "' not accepted as a timestamp");
            }
            if (this.hasTimezone()) {
                ExtData p = r.allocField(this.fieldNo, 10);
                p.setTimestampWithTimezone(yearval, monthval, dayval, hourval, minuteval, secondval, microsec, 0, 0, 0);
            } else {
                ExtData p = r.allocField(this.fieldNo, 8);
                p.setTimestamp(yearval, monthval, dayval, hourval, minuteval, secondval, microsec, 0);
            }
        }
        catch (Exception e) {
            throw new DbException(33, "'" + str + "' not accepted as a timestamp", e);
        }
    }

    void setDate(ParameterTuple r, Date date) throws SQLException {
        if (date == null) {
            this.setNull(r, this.getColumnType());
            return;
        }
        Timestamp ts = new Timestamp(date.getTime());
        this.setTimestamp(r, ts);
    }

    void setTime(ParameterTuple r, Time val) throws SQLException {
        if (val == null) {
            this.setNull(r, this.getColumnType());
            return;
        }
        Timestamp ts = new Timestamp(val.getTime());
        this.setTimestamp(r, ts);
    }

    void setTimestamp(ParameterTuple r, Timestamp timestamp) throws SQLException {
        if (timestamp == null) {
            this.setNull(r, this.getColumnType());
            return;
        }
        this.setString(r, timestamp.toString());
    }

    private boolean hasTimezone() {
        return this.att.hasTimezone();
    }
}

