/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.comm.ExtData;
import com.sun.hadb.comm.ExtDataInputStream;
import com.sun.hadb.jdbc.DbException;
import com.sun.hadb.jdbc.TupleStore;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

class Tuple {
    static final int RECORD_HEAD_SZ = 2;
    static final int OFFSET_SZ = 2;
    private ExtData p = null;
    private TupleStore store;

    public Tuple(TupleStore store, ExtData p) {
        this.store = store;
        this.p = p;
    }

    protected Tuple() {
    }

    public ExtData getField(int n) {
        int offset = this.p.getInt16(2 + n * 2);
        if (offset < 0) {
            offset += 32768;
        }
        return new ExtData(this.p, offset);
    }

    public int getFieldSize(int n) {
        int off2;
        int off1 = this.p.getInt16(2 + (n + 1) * 2);
        if (off1 < 0) {
            off1 += 32768;
        }
        if ((off2 = this.p.getInt16(2 + n * 2)) < 0) {
            off2 += 32768;
        }
        return off1 - off2;
    }

    public int getFieldCount() {
        int off = this.p.getInt16(2);
        if (off < 0) {
            off += 32768;
        }
        return (off - 2) / 2 - 1;
    }

    public int size() {
        return this.p.getInt16(this.getFieldCount() * 2 + 2);
    }

    public String toString() {
        int field = 0;
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(this.p.toHexString(2 + (this.getFieldCount() + 1) * 2));
            for (int i = 0; i < this.getFieldCount(); ++i) {
                field = i;
                sb.append('[');
                sb.append(this.getField(i).toHexString(this.getFieldSize(i)));
                sb.append(']');
            }
        }
        catch (Exception e) {
            System.out.println("\n toString failed.Field no " + field);
        }
        return sb.toString();
    }

    String getFieldAsString(int fieldno) {
        if (this.checkCluNull(fieldno)) {
            return null;
        }
        return this.getField(fieldno).toCharString(0, this.getFieldSize(fieldno));
    }

    InputStream getFieldAsAsciiStream(int fieldno) {
        if (this.checkCluNull(fieldno)) {
            return null;
        }
        int len = this.getFieldSize(fieldno);
        return new ExtDataInputStream(this.getField(fieldno), len);
    }

    InputStream getFieldAsUnicodeStream(int fieldno) throws SQLException {
        if (this.checkCluNull(fieldno)) {
            return null;
        }
        try {
            byte[] iso8859bytes = this.getFieldAsBytes(fieldno);
            String fieldstr = new String(iso8859bytes, "ISO8859_1");
            byte[] unicodebytes = fieldstr.getBytes("UTF8");
            return new ByteArrayInputStream(unicodebytes);
        }
        catch (IOException e1) {
            throw new DbException(e1);
        }
    }

    byte[] getFieldAsBytes(int fieldno) {
        if (this.checkCluNull(fieldno)) {
            return null;
        }
        int len = this.getFieldSize(fieldno);
        return this.getField(fieldno).asByteArray(len);
    }

    protected boolean checkCluNull(int fieldno) {
        short off = this.p.getInt16(2 + fieldno * 2);
        return off < 0;
    }

    String getBinaryFieldAsString(int fieldNo) {
        if (this.checkCluNull(fieldNo)) {
            return null;
        }
        return this.getField(fieldNo).toHexString(this.getFieldSize(fieldNo));
    }

    public TupleStore getTupleStore() {
        return this.store;
    }
}

