/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc;

import com.sun.hadb.comm.CliStatement;
import com.sun.hadb.comm.CommException;
import com.sun.hadb.comm.ExtData;
import com.sun.hadb.comm.RPCAttrDescr;
import com.sun.hadb.comm.RPCGetTuplesDescr;
import com.sun.hadb.comm.RPCStatus;
import com.sun.hadb.comm.RPCTableTypeDescr;
import com.sun.hadb.jdbc.ConnectionImpl;
import com.sun.hadb.jdbc.DbException;
import com.sun.hadb.jdbc.LobFragment;
import com.sun.hadb.jdbc.LobFrame;
import com.sun.hadb.jdbc.ResultSetMetaDataImpl;
import com.sun.hadb.jdbc.StatementImpl;
import com.sun.hadb.jdbc.Tuple;
import java.util.LinkedList;

public class TupleStore {
    private Tuple currentTuple = null;
    private ExtData extdata;
    private ExtData oldBuffer;
    private ConnectionImpl con;
    private StatementImpl statement;
    private ResultSetMetaDataImpl metadata;
    private int rowsToFetch;
    private int currentLob;
    private int lobCount;
    private int tupleCount;
    private boolean eof;
    private boolean currentBufferHasTuple;
    private int[] lobColMap;
    private int[] lobLobMap;
    private boolean[] nullData;
    private boolean[] fragmentEOL;
    private LinkedList[] fragmentList;
    private static final int TUPLE = 1;
    private static final int LOB_FRAME = 2;
    private int comingNext;

    public TupleStore(ConnectionImpl con, StatementImpl statement, ResultSetMetaDataImpl metadata, ExtData initialData, boolean isEof, int rowsToFetch) {
        this.con = con;
        this.statement = statement;
        this.metadata = metadata;
        this.extdata = initialData;
        this.rowsToFetch = rowsToFetch;
        this.eof = isEof;
        this.comingNext = 1;
        this.currentLob = 0;
        this.lobCount = metadata.getTTD().getLobCount();
        this.oldBuffer = null;
        this.currentBufferHasTuple = true;
        if (this.lobCount > 0) {
            this.nullData = new boolean[this.lobCount];
            this.lobColMap = new int[this.lobCount];
            this.lobLobMap = new int[this.lobCount];
            this.fragmentList = new LinkedList[this.lobCount];
            this.fragmentEOL = new boolean[this.lobCount];
            this.setupLobColMap();
        }
        this.tupleCount = 0;
    }

    private void setupLobColMap() {
        int counter = 0;
        RPCTableTypeDescr ttd = this.metadata.getTTD();
        for (int i = 0; i < ttd.getAttcnt(); ++i) {
            RPCAttrDescr ad = ttd.getRPCAttrDescr(i);
            if (!ad.isLOB()) continue;
            this.lobColMap[counter] = i;
            this.lobLobMap[counter] = ad.getLobNo();
            ++counter;
        }
    }

    public Tuple nextTuple() throws DbException {
        if (this.oldBuffer != null) {
            this.oldBuffer.close();
            this.oldBuffer = null;
        }
        if (this.comingNext == 2) {
            this.discardLobFragments();
        }
        int tripcounter = 0;
        while (this.extdata.size() == 0) {
            this.extdata.close();
            if (++tripcounter >= 5) {
                throw new DbException(1, "expected EOF");
            }
            if (this.eof) {
                this.close();
                return null;
            }
            int actions = 0xB00000;
            this.extdata = this.fetchData(actions);
        }
        this.comingNext = 1;
        int esize = this.extdata.size();
        this.extdata = new ExtData(this.extdata, 2);
        this.currentTuple = new Tuple(this, this.extdata);
        int tsiz = this.currentTuple.size();
        int align = tsiz % 2;
        tsiz += align;
        if (this.lobCount > 0) {
            this.initLobStructs();
            if (this.hasLobData()) {
                this.comingNext = 2;
                this.currentLob = 0;
            }
        }
        this.extdata = new ExtData(this.extdata, tsiz);
        this.currentBufferHasTuple = true;
        ++this.tupleCount;
        return this.currentTuple;
    }

    private void initLobStructs() {
        for (int i = 0; i < this.lobCount; ++i) {
            int colno = this.mapLobNoToColNo(i + 1);
            if (this.fragmentList[i] != null) {
                this.fragmentList[i].clear();
            } else {
                this.fragmentList[i] = new LinkedList();
            }
            if (this.currentTuple.getFieldSize(colno) == 0 || this.isLobZeroSize(colno)) {
                this.nullData[i] = true;
                this.fragmentEOL[i] = true;
                continue;
            }
            this.nullData[i] = false;
            this.fragmentEOL[i] = false;
        }
    }

    private boolean isLobZeroSize(int colno) {
        ExtData e = this.currentTuple.getField(colno);
        return e.getInt64(0) == 0L;
    }

    private boolean hasLobData() {
        for (int i = 0; i < this.lobCount; ++i) {
            if (this.nullData[i]) continue;
            return true;
        }
        return false;
    }

    public byte[] getNextLobFragment(Tuple r, int colno) throws DbException {
        if (r == this.getTuple()) {
            return this.readLobFragment(this.mapColNoToLobNo(colno));
        }
        throw new DbException(60);
    }

    public Tuple getTuple() {
        return this.currentTuple;
    }

    public int mapColNoToLobNo(int colno) {
        for (int i = 0; i < this.lobCount; ++i) {
            if (this.lobColMap[i] != colno) continue;
            return i;
        }
        return -1;
    }

    public int mapLobNoToColNo(int lobno) {
        return this.lobColMap[lobno - 1];
    }

    private byte[] readLobFragment(int lobno) throws DbException {
        if (this.nullData[lobno]) {
            return null;
        }
        block0: while (true) {
            if (this.fragmentList[lobno] != null && this.fragmentList[lobno].size() > 0) {
                LobFragment frag = (LobFragment)this.fragmentList[lobno].removeFirst();
                return frag.getData();
            }
            if (this.fragmentEOL[lobno]) {
                return null;
            }
            if (this.comingNext != 2) {
                throw new DbException(1, "Expected LOB Frame");
            }
            if (this.extdata.size() == 0) {
                if (!this.expectMoreFragments()) {
                    if (!this.currentBufferHasTuple) {
                        this.extdata.close();
                    } else {
                        this.oldBuffer = this.extdata;
                    }
                    return null;
                }
                if (!this.currentBufferHasTuple) {
                    this.extdata.close();
                } else {
                    this.oldBuffer = this.extdata;
                }
                int actions = 0x300000;
                this.extdata = this.fetchData(actions);
                this.currentBufferHasTuple = false;
                if (this.extdata.size() == 0) {
                    return null;
                }
            }
            LobFrame lf = new LobFrame(this.extdata);
            int lfsiz = lf.size();
            int align = lfsiz % 2;
            this.extdata = new ExtData(this.extdata, lfsiz += align);
            int i = 0;
            while (true) {
                if (i >= lf.getFragmentCount()) continue block0;
                LobFragment frag = lf.getFragment(i);
                int frlobno = frag.getLobNo();
                int frindex = this.mapLobNoToIndex(frlobno);
                if (frag.isEOL()) {
                    this.fragmentEOL[frindex] = true;
                }
                this.fragmentList[frindex].add(frag);
                ++i;
            }
            break;
        }
    }

    private int mapLobNoToIndex(int lobno) {
        for (int i = 0; i < this.lobLobMap.length; ++i) {
            if (this.lobLobMap[i] != lobno) continue;
            return i;
        }
        return -1;
    }

    private void discardLobFragments() {
        int siz = this.extdata.size();
        boolean expect = this.expectMoreFragments();
        if (siz > 0 && expect) {
            LobFrame lf = new LobFrame(this.extdata);
            int lfsiz = lf.size();
            int align = lfsiz % 2;
            this.extdata = new ExtData(this.extdata, lfsiz += align);
        }
        this.comingNext = 1;
    }

    private boolean expectMoreFragments() {
        for (int i = 0; i < this.lobCount; ++i) {
            if (this.fragmentEOL[i]) continue;
            return true;
        }
        return false;
    }

    private ExtData fetchData(int actions) throws DbException {
        try {
            CliStatement cstmt = this.statement.getCliStatement();
            if (cstmt == null) {
                this.close();
                throw new DbException(12);
            }
            if (this.statement.isCursorClosed()) {
                this.close();
                throw new DbException(62);
            }
            int direction = 1;
            RPCGetTuplesDescr tDescr = cstmt.getTuples(this.rowsToFetch, direction, actions);
            if (tDescr == null) {
                throw new DbException(62);
            }
            RPCStatus status = tDescr.getRPCStatus();
            if (status.isError()) {
                throw new DbException(status);
            }
            this.eof = tDescr.isEof();
            ExtData ext = new ExtData(tDescr.getTuples());
            return ext;
        }
        catch (CommException e) {
            this.con.markDirty(e);
            if (e.getRPCStatus() != null) {
                throw new DbException(e.getRPCStatus(), e);
            }
            throw new DbException(e);
        }
    }

    public boolean expectMoreTuples() {
        return !this.eof || this.extdata.size() != 0;
    }

    public int currentTuple() {
        return this.tupleCount;
    }

    public void close() {
        this.doClose();
    }

    private void doClose() {
        if (this.oldBuffer != null) {
            this.oldBuffer.close();
        }
        this.extdata.close();
        this.currentTuple = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("TupleStore: ");
        if (this.getTuple() == null) {
            sb.append("no current tuple");
        } else {
            sb.append("LOB count=").append(this.lobCount).append('\n');
            for (int i = 0; i < this.lobCount; ++i) {
                sb.append(" LOB#").append(i);
                sb.append(" column#").append(this.lobColMap[i]);
                sb.append(" isnull=").append(this.nullData[i]);
                sb.append(" eol=").append(this.fragmentEOL[i]);
                sb.append('\n');
            }
        }
        return sb.toString();
    }
}

