/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc.pool;

import com.sun.hadb.jdbc.ConnectionImpl;
import com.sun.hadb.jdbc.pool.HadbPooledConnection;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class HadbConnectionPoolDataSource
implements ConnectionPoolDataSource,
Referenceable,
Serializable {
    private int login_timeout = 0;
    private int query_timeout = 0;
    private int lock_timeout = 0;
    private int max_trans_idle = 0;
    private int port_number;
    private String server_name;
    private String server_list;
    private String description;
    private String username;
    private String password;
    private PrintWriter printer;
    private int max_statements = 0;
    private boolean eliminate_redundant_end_trans = false;
    private boolean cacheDatabaseMetaData = true;

    public PooledConnection getPooledConnection() throws SQLException {
        return this.getPooledConnection(null, null);
    }

    public PooledConnection getPooledConnection(String user, String password) throws SQLException {
        String hostlist = ConnectionImpl.concatHostList(this.server_name, this.port_number, this.server_list);
        Properties p = new Properties();
        p.setProperty("logintimeout", "" + this.login_timeout);
        p.setProperty("eliminateredundantendtransaction", "" + this.eliminate_redundant_end_trans);
        p.setProperty("cachedatabasemetadata", "" + this.cacheDatabaseMetaData);
        p.setProperty("maxtransidle", "" + this.max_trans_idle);
        p.setProperty("locktimeout", "" + this.lock_timeout);
        p.setProperty("querytimeout", "" + this.query_timeout);
        if (user == null) {
            user = this.username;
            password = this.password;
        }
        ConnectionImpl conn = new ConnectionImpl(hostlist, user, password, p);
        conn.initializeStatementPool(this.max_statements);
        HadbPooledConnection cpc = new HadbPooledConnection(user, password, conn);
        return cpc;
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        if (seconds >= 0) {
            this.login_timeout = seconds;
        }
    }

    public int getLoginTimeout() throws SQLException {
        return this.login_timeout;
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.printer = out;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.printer;
    }

    public void setPortNumber(int port) {
        this.port_number = port;
    }

    public int getPortNumber() {
        return this.port_number;
    }

    public void setServerName(String sname) {
        this.server_name = sname;
    }

    public String getServerName() {
        if (this.server_name == null) {
            return "";
        }
        return this.server_name;
    }

    public void setServerList(String slist) {
        this.server_list = slist;
    }

    public String getServerList() {
        if (this.server_list == null) {
            return "";
        }
        return this.server_list;
    }

    public void setDescription(String descr) {
        this.description = descr;
    }

    public String getDescription() {
        if (this.description == null) {
            return "";
        }
        return this.description;
    }

    public void setQueryTimeout(int timeout) {
        this.query_timeout = timeout;
    }

    public int getQueryTimeout() {
        return this.query_timeout;
    }

    public void setMaxTransIdle(int timeout) {
        this.max_trans_idle = timeout;
    }

    public int getMaxTransIdle() {
        return this.max_trans_idle;
    }

    public void setLockTimeout(int timeout) {
        this.lock_timeout = timeout;
    }

    public int getLockTimeout() {
        return this.lock_timeout;
    }

    public void setMaxStatements(int max) {
        this.max_statements = max;
    }

    public int getMaxStatements() {
        return this.max_statements;
    }

    public void setEliminateRedundantEndTransaction(boolean eliminate) {
        this.eliminate_redundant_end_trans = eliminate;
    }

    public boolean getEliminateRedundantEndTransaction() {
        return this.eliminate_redundant_end_trans;
    }

    public void setCacheDatabaseMetaData(boolean cache) {
        this.cacheDatabaseMetaData = cache;
    }

    public boolean getCacheDatabaseMetaData() {
        return this.cacheDatabaseMetaData;
    }

    public void setUser(String uname) {
        this.username = uname;
    }

    public String getUser() {
        return this.username;
    }

    public void setUserName(String uname) {
        this.setUser(uname);
    }

    public String getUserName() {
        return this.getUser();
    }

    public void setPassword(String pword) {
        this.password = pword;
    }

    public boolean tryConnection(ConnectionImpl conn) {
        try {
            if (conn.isClosed()) {
                return false;
            }
            conn.setAutoCommit(true);
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), "com.sun.hadb.jdbc.pool.HadbPoolFactory", null);
        ref.add(new StringRefAddr("serverName", this.getServerName()));
        ref.add(new StringRefAddr("description", this.getDescription()));
        ref.add(new StringRefAddr("portNumber", "" + this.getPortNumber()));
        ref.add(new StringRefAddr("serverList", this.getServerList()));
        ref.add(new StringRefAddr("user", this.getUser()));
        ref.add(new StringRefAddr("password", this.password));
        ref.add(new StringRefAddr("logintimeout", "" + this.login_timeout));
        ref.add(new StringRefAddr("queryTimeout", "" + this.query_timeout));
        ref.add(new StringRefAddr("locktimeout", "" + this.lock_timeout));
        ref.add(new StringRefAddr("maxtransidle", "" + this.max_trans_idle));
        ref.add(new StringRefAddr("maxStatements", "" + this.max_statements));
        ref.add(new StringRefAddr("eliminateRedundantEndTransaction", "" + this.eliminate_redundant_end_trans));
        ref.add(new StringRefAddr("cacheDatabaseMetaData", "" + this.cacheDatabaseMetaData));
        return ref;
    }
}

