/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc.pool;

import com.sun.hadb.jdbc.ConnectionImpl;
import com.sun.hadb.jdbc.pool.ShadowConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class HadbPooledConnection
implements PooledConnection {
    private ConnectionImpl physConnection;
    private HashSet listeners;
    private String user;
    private String pass;

    public HadbPooledConnection(String user, String pass, ConnectionImpl phys) {
        this.user = user;
        this.pass = pass;
        this.physConnection = phys;
        this.listeners = new HashSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionEventListener(ConnectionEventListener listener) {
        HashSet hashSet = this.listeners;
        synchronized (hashSet) {
            if (listener != null) {
                this.listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        HashSet hashSet = this.listeners;
        synchronized (hashSet) {
            if (listener != null) {
                this.listeners.remove(listener);
            }
        }
    }

    public void close() throws SQLException {
        if (this.physConnection != null) {
            this.physConnection.close();
            this.physConnection = null;
        }
    }

    public Connection getConnection() throws SQLException {
        ShadowConnection csc = new ShadowConnection(this, this.physConnection);
        return csc;
    }

    void freeConnection() {
        this.signalClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signalClose() {
        HashSet hashSet = this.listeners;
        synchronized (hashSet) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                ConnectionEventListener l = (ConnectionEventListener)it.next();
                if (l == null) continue;
                l.connectionClosed(new ConnectionEvent(this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signalError() {
        HashSet hashSet = this.listeners;
        synchronized (hashSet) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                ConnectionEventListener l = (ConnectionEventListener)it.next();
                if (l == null) continue;
                l.connectionErrorOccurred(new ConnectionEvent(this));
            }
        }
    }

    protected String getUser() {
        return this.user;
    }

    protected String getPassword() {
        return this.pass;
    }

    protected ConnectionImpl getPhysical() {
        return this.physConnection;
    }
}

