/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.jdbc.pool;

import com.sun.hadb.jdbc.DbException;
import com.sun.hadb.jdbc.pool.ConnectionCache;
import com.sun.hadb.jdbc.pool.HadbConnectionPoolDataSource;
import com.sun.hadb.jdbc.pool.HadbPooledConnection;
import com.sun.hadb.jdbc.pool.PoolLogFactory;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

public class HadbPooledDataSource
implements DataSource,
Referenceable,
Serializable,
ConnectionEventListener {
    private ConnectionCache cache;
    private Logger logger = PoolLogFactory.getPoolLogger();
    private int login_timeout = 0;
    private PrintWriter log_writer;
    private String description = "";
    private String data_source_name = "";
    private ConnectionPoolDataSource cpds;
    private static final int DEFAULT_TIMEOUT = 10;

    public HadbPooledDataSource() {
        this.cache = new ConnectionCache();
    }

    public void connectionClosed(ConnectionEvent event) {
        this.logger.finest("HadbPooledDataSource.connectionClosed() -- signal received");
        this.cache.addToCache((HadbPooledConnection)event.getSource());
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        this.logger.finest("HadbPooledDataSource.connectionErrorOccured() -- signal received");
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        PooledConnection pc = this.cache.getPooledConnection(username, password);
        if (pc == null) {
            this.logger.finest("HadbPooledDataSource.getConnection: cache was empty");
            if (this.cpds == null) {
                this.cpds = this.getCPDS();
                if (this.cpds == null) {
                    throw new DbException(47, "'" + this.data_source_name + "'");
                }
            }
            if (this.login_timeout != 0) {
                this.cpds.setLoginTimeout(this.login_timeout);
            }
            if (this.log_writer != null) {
                this.cpds.setLogWriter(this.log_writer);
            }
            pc = username == null ? this.cpds.getPooledConnection() : this.cpds.getPooledConnection(username, password);
        }
        pc.addConnectionEventListener(this);
        return pc.getConnection();
    }

    private ConnectionPoolDataSource getCPDS() throws DbException {
        try {
            InitialContext ctx = new InitialContext();
            HadbConnectionPoolDataSource cp = (HadbConnectionPoolDataSource)ctx.lookup(this.data_source_name);
            return cp;
        }
        catch (NamingException e) {
            throw new DbException(48, e);
        }
    }

    public int getLoginTimeout() throws SQLException {
        return this.login_timeout;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.log_writer = out;
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.login_timeout = seconds;
    }

    public void setDescription(String descr) {
        this.description = descr;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDataSourceName(String dsname) {
        this.data_source_name = dsname;
    }

    public String getDataSourceName() {
        return this.data_source_name;
    }

    public Reference getReference() throws NamingException {
        Reference ref = new Reference(this.getClass().getName(), "com.sun.hadb.jdbc.pool.HadbPoolFactory", null);
        ref.add(new StringRefAddr("dataSourceName", this.getDataSourceName()));
        ref.add(new StringRefAddr("description", this.getDescription()));
        ref.add(new StringRefAddr("loginTimeout", "" + this.login_timeout));
        return ref;
    }
}

