/*
 * Decompiled with CFR 0.152.
 */
package jmaki.runtime.jsf.shale;

import java.util.ListIterator;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import jmaki.runtime.AjaxContext;
import jmaki.runtime.AjaxException;
import jmaki.runtime.UriManager;
import jmaki.runtime.UriManagerFactory;
import org.apache.shale.remoting.Mapping;
import org.apache.shale.remoting.Mappings;
import org.apache.shale.remoting.Mechanism;
import org.apache.shale.remoting.faces.MappingsHelper;

public class RemotingUriManager
implements UriManager,
UriManagerFactory {
    private Mappings mappings = null;
    private Mapping classPathMapping = null;
    private Mapping dynamicMapping = null;
    private Mapping webappMapping = null;
    private Mapping externalMapping = null;

    public String buildClassPathResourceReference(AjaxContext ctx, String resource) throws AjaxException {
        if (this.classPathMapping == null) {
            throw new AjaxException("unable to build ClassPathResourceReference: no mapping for " + Mechanism.CLASS_RESOURCE + " defined");
        }
        return this.classPathMapping.mapResourceId(FacesContext.getCurrentInstance(), "/META-INF" + resource);
    }

    public String buildDynamicResourceReference(AjaxContext ctx, String resource) throws AjaxException {
        if (this.dynamicMapping == null) {
            throw new AjaxException("unable to build DynamicResourceReference: no mapping for " + Mechanism.DYNAMIC_RESOURCE + " defined");
        }
        if (resource.startsWith("#{") && resource.endsWith("}")) {
            resource = "/" + resource.substring(2, resource.length() - 1).replace('.', '-');
        }
        return this.dynamicMapping.mapResourceId(FacesContext.getCurrentInstance(), resource);
    }

    public String buildExternalResourceReference(AjaxContext ctx, String resource) throws AjaxException {
        if (this.externalMapping == null) {
            throw new AjaxException("unable to build ExternalResourceReference: no mapping for " + Mechanism.OTHER_RESOURCE + " defined");
        }
        return this.externalMapping.mapResourceId(FacesContext.getCurrentInstance(), resource);
    }

    public String buildWebAppResourceReference(AjaxContext ctx, String resource) throws AjaxException {
        if (this.webappMapping == null) {
            throw new AjaxException("unable to build WebAppResourceReference: no mapping for " + Mechanism.WEBAPP_RESOURCE + " defined");
        }
        return this.webappMapping.mapResourceId(FacesContext.getCurrentInstance(), resource);
    }

    public UriManager getInstance(ServletContext ctx) throws AjaxException {
        this.mappings = new MappingsHelper().getMappings(FacesContext.getCurrentInstance());
        if (this.mappings == null) {
            throw new AjaxException("could not retrieve shale remoting mappings from application scope");
        }
        ListIterator mappingsIterator = this.mappings.getMappings().listIterator();
        while (mappingsIterator.hasNext()) {
            Mapping mapping = (Mapping)mappingsIterator.next();
            Mechanism mechanism = mapping.getMechanism();
            if (mechanism.equals(Mechanism.CLASS_RESOURCE)) {
                this.classPathMapping = mapping;
            }
            if (mechanism.equals(Mechanism.DYNAMIC_RESOURCE)) {
                this.dynamicMapping = mapping;
            }
            if (mechanism.equals(Mechanism.WEBAPP_RESOURCE)) {
                this.webappMapping = mapping;
            }
            if (!mechanism.equals(Mechanism.OTHER_RESOURCE)) continue;
            this.externalMapping = mapping;
        }
        return this;
    }
}

