/*
 * Decompiled with CFR 0.152.
 */
package jmaki.runtime.jsp;

import java.io.IOException;
import java.io.Writer;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import jmaki.runtime.AjaxCommonRenderer;
import jmaki.runtime.AjaxContext;
import jmaki.runtime.AjaxGlobalObjects;
import jmaki.runtime.WidgetResourceException;
import jmaki.runtime.config.WidgetConfigException;

public class AjaxTag
extends BodyTagSupport {
    private static final long serialVersionUID = -3395729681200248684L;
    private static Logger logger;
    private String id = null;
    private String args = null;
    private String name = null;
    private String style = null;
    private String script = null;
    private String template = null;
    private String service = null;
    private String publish = null;
    private String value = null;
    private String subscribe = null;
    private ServletContext ctx = null;

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setPublish(String publish) {
        this.publish = publish;
    }

    public void setSubscribe(String subscribe) {
        this.subscribe = subscribe;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public int doStartTag() throws JspTagException {
        return 2;
    }

    public int doAfterBody() throws JspTagException {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doEndTag() throws JspTagException {
        PageContext pctx = this.pageContext;
        HttpServletRequest request = (HttpServletRequest)pctx.getRequest();
        HttpServletResponse response = (HttpServletResponse)pctx.getResponse();
        if (this.ctx == null) {
            this.ctx = pctx.getServletContext();
        }
        JspWriter out = this.pageContext.getOut();
        try {
            AjaxContext ajx = AjaxContext.getInstance(this.ctx, request, response, (Writer)out);
            AjaxCommonRenderer common = new AjaxCommonRenderer(ajx);
            common.setUuid(this.id);
            common.setArgs(this.args);
            common.setName(this.name);
            common.setScript(this.script);
            common.setTemplate(this.template);
            if (this.service != null && this.service.startsWith("/")) {
                this.service = ajx.getApplicationRoot() + this.service;
            }
            common.setService(this.service);
            common.setValue(this.value);
            common.setPublish(this.publish);
            common.setSubscribe(this.subscribe);
            common.setStyle(this.style);
            common.doProcess();
        }
        catch (IOException ioe) {
            AjaxGlobalObjects globalObjects;
            if (this.ctx == null || (globalObjects = (AjaxGlobalObjects)this.ctx.getAttribute("jmaki_globalobjects")) == null || globalObjects.getThrowExceptions()) {
                throw new JspTagException((Throwable)ioe);
            }
            try {
                if (ioe instanceof WidgetResourceException) {
                    out.println("Error loading widget resource for " + this.name + ":" + ioe.getMessage());
                } else if (ioe instanceof WidgetConfigException) {
                    out.println("Error loading widget " + this.name + ":" + ioe.getMessage());
                }
            }
            catch (IOException iox) {
                AjaxTag.getLogger().warning(ioe.getMessage());
            }
            AjaxTag.getLogger().severe(ioe.getMessage());
        }
        finally {
            this.reset();
        }
        return 6;
    }

    private void reset() {
        this.script = null;
        this.style = null;
        this.service = null;
        this.name = null;
        this.template = null;
        this.publish = null;
        this.subscribe = null;
        this.args = null;
        this.id = null;
    }

    public static Logger getLogger() {
        if (logger == null) {
            logger = Logger.getLogger("jmaki.runtime.Log");
        }
        return logger;
    }
}

