/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.database.oracle;

import com.sun.jdo.api.persistence.support.FieldMapping;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.support.sqlstore.database.BaseSpecialDBOperation;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.EJBHelper;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import oracle.jdbc.OraclePreparedStatement;

public class OracleSpecialDBOperation
extends BaseSpecialDBOperation {
    private static Logger logger = LogHelperSQLStore.getLogger();
    private DBDriverHandlerFactory dBDriverHandlerFactory;
    private static final boolean oracle816ClassesAvailable;
    private static final boolean oracle817ClassesAvailable;
    private static final String TEST_STATEMENT = "select 1 from dual";

    public void initialize(DatabaseMetaData metaData, String identifier) throws SQLException {
        Connection con = metaData.getConnection();
        PreparedStatement testPs = con.prepareStatement(TEST_STATEMENT);
        if (oracle817ClassesAvailable && testPs instanceof OraclePreparedStatement) {
            this.dBDriverHandlerFactory = new OracleDriverHandlerFactory(){

                public DBDriverHandler createDBDriverHandler(PreparedStatement ps) {
                    return new Oracle817Handler(ps);
                }
            };
        } else if (oracle816ClassesAvailable && testPs instanceof oracle.jdbc.driver.OraclePreparedStatement) {
            this.dBDriverHandlerFactory = new OracleDriverHandlerFactory(){

                public DBDriverHandler createDBDriverHandler(PreparedStatement ps) {
                    return new Oracle816Handler(ps);
                }
            };
        } else {
            this.dBDriverHandlerFactory = new DBDriverHandlerFactory(){

                public DBDriverHandler createDBDriverHandler(PreparedStatement ps) {
                    return new NonOracleHandler(ps);
                }

                public boolean supportsDefineColumnType() {
                    return false;
                }
            };
            if (logger.isLoggable(700)) {
                identifier = identifier == null ? "Connection Factory" : identifier;
                logger.log(700, "sqlstore.database.oracle.nooracleavailable", (Object)identifier);
            }
        }
        testPs.close();
    }

    public void defineColumnTypeForResult(PreparedStatement ps, List columns) throws SQLException {
        int size;
        if (this.dBDriverHandlerFactory.supportsDefineColumnType() && (size = columns.size()) > 0) {
            DBDriverHandler driverHandler = this.dBDriverHandlerFactory.createDBDriverHandler(ps);
            try {
                for (int i = 0; i < size; ++i) {
                    FieldMapping fieldMapping = (FieldMapping)columns.get(i);
                    int type = fieldMapping.getColumnType();
                    if (type == 1 || type == 12) {
                        int len = fieldMapping.getColumnLength();
                        if (len > 0) {
                            driverHandler.defineColumnType(i + 1, type, len);
                            continue;
                        }
                        driverHandler.defineColumnType(i + 1, type);
                        continue;
                    }
                    driverHandler.defineColumnType(i + 1, type);
                }
            }
            catch (Exception ex) {
                if (logger.isLoggable(800)) {
                    logger.log(800, "sqlstore.database.oracle.defineCol", (Throwable)ex);
                }
                driverHandler.clearDefines();
            }
        }
    }

    public void bindFixedCharColumn(PreparedStatement stmt, int index, String strVal, int length) throws SQLException {
        DBDriverHandler driverHandler = this.dBDriverHandlerFactory.createDBDriverHandler(stmt);
        driverHandler.bindFixedCharColumn(index, strVal, length);
    }

    private static Class loadClass(String className, ClassLoader loader) {
        final ClassLoader finalLoader = loader;
        final String finalClassName = className;
        return (Class)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    if (finalLoader != null) {
                        return Class.forName(finalClassName, true, finalLoader);
                    }
                    return Class.forName(finalClassName);
                }
                catch (Exception e) {
                    return null;
                }
            }
        });
    }

    static {
        ClassLoader loader = OracleSpecialDBOperation.class.getClassLoader();
        oracle816ClassesAvailable = OracleSpecialDBOperation.loadClass("oracle.jdbc.driver.OraclePreparedStatement", loader) != null;
        oracle817ClassesAvailable = OracleSpecialDBOperation.loadClass("oracle.jdbc.OraclePreparedStatement", loader) != null;
    }

    private static class NonOracleHandler
    implements DBDriverHandler {
        PreparedStatement ps;
        private static final char SPACE_CHAR = ' ';
        private static final int PAD_STEP_LENGTH = 50;
        private static final char[] SPACES = new char[50];

        private NonOracleHandler(PreparedStatement ps) {
            this.ps = ps;
        }

        public void defineColumnType(int index, int type) throws SQLException {
        }

        public void defineColumnType(int index, int type, int length) throws SQLException {
        }

        public void clearDefines() throws SQLException {
        }

        public void bindFixedCharColumn(int index, String strVal, int length) throws SQLException {
            this.ps.setString(index, NonOracleHandler.padSpaceChar(strVal, length));
            if (logger.isLoggable(500)) {
                logger.log(500, "sqlstore.database.oracle.fixedcharpadded", (Object)strVal, (Object)new Integer(length));
            }
        }

        private static String padSpaceChar(String val, int targetLength) {
            String retVal = val;
            int inputLength = val.length();
            if (inputLength < targetLength) {
                int padsize;
                StringBuffer buf = new StringBuffer(targetLength);
                buf.append(val);
                for (padsize = targetLength - inputLength; padsize >= 50; padsize -= 50) {
                    buf.append(SPACES);
                }
                buf.append(SPACES, 0, padsize);
                retVal = buf.toString();
            }
            return retVal;
        }

        static {
            Arrays.fill(SPACES, ' ');
        }
    }

    private static class Oracle816Handler
    implements DBDriverHandler {
        oracle.jdbc.driver.OraclePreparedStatement oraclePreparedStatement;

        public Oracle816Handler(Statement ps) {
            this.oraclePreparedStatement = (oracle.jdbc.driver.OraclePreparedStatement)EJBHelper.unwrapStatement((Statement)ps);
        }

        public void defineColumnType(int index, int type) throws SQLException {
            this.oraclePreparedStatement.defineColumnType(index, type);
        }

        public void defineColumnType(int index, int type, int length) throws SQLException {
            this.oraclePreparedStatement.defineColumnType(index, type, length);
        }

        public void clearDefines() throws SQLException {
            this.oraclePreparedStatement.clearDefines();
        }

        public void bindFixedCharColumn(int index, String strVal, int length) throws SQLException {
            this.oraclePreparedStatement.setFixedCHAR(index, strVal);
        }
    }

    private static class Oracle817Handler
    implements DBDriverHandler {
        OraclePreparedStatement oraclePreparedStatement;

        public Oracle817Handler(Statement ps) {
            this.oraclePreparedStatement = (OraclePreparedStatement)EJBHelper.unwrapStatement((Statement)ps);
        }

        public void defineColumnType(int index, int type) throws SQLException {
            this.oraclePreparedStatement.defineColumnType(index, type);
        }

        public void defineColumnType(int index, int type, int length) throws SQLException {
            this.oraclePreparedStatement.defineColumnType(index, type, length);
        }

        public void clearDefines() throws SQLException {
            this.oraclePreparedStatement.clearDefines();
        }

        public void bindFixedCharColumn(int index, String strVal, int length) throws SQLException {
            this.oraclePreparedStatement.setFixedCHAR(index, strVal);
        }
    }

    private static interface DBDriverHandler {
        public void defineColumnType(int var1, int var2) throws SQLException;

        public void defineColumnType(int var1, int var2, int var3) throws SQLException;

        public void clearDefines() throws SQLException;

        public void bindFixedCharColumn(int var1, String var2, int var3) throws SQLException;
    }

    private abstract class OracleDriverHandlerFactory
    implements DBDriverHandlerFactory {
        private OracleDriverHandlerFactory() {
        }

        public boolean supportsDefineColumnType() {
            return true;
        }
    }

    private static interface DBDriverHandlerFactory {
        public DBDriverHandler createDBDriverHandler(PreparedStatement var1);

        public boolean supportsDefineColumnType();
    }
}

