/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.CliDatabase;
import com.sun.hadb.comm.CliDatabaseImpl;
import com.sun.hadb.comm.CliDbStatus;
import com.sun.hadb.comm.CommException;
import com.sun.hadb.comm.CommLogFactory;
import com.sun.hadb.comm.DebugUtil;
import com.sun.hadb.comm.EndPoint;
import com.sun.hadb.comm.Password;
import com.sun.hadb.comm.RPCChannel;
import com.sun.hadb.comm.RPCConnect;
import com.sun.hadb.comm.RPCOpenDatabase;
import com.sun.hadb.comm.RPCResult;
import com.sun.hadb.comm.RPCStatus;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CliChannel {
    private long login_timeout = 0L;
    private RPCChannel rpc;
    private byte[] pwdkey;
    private Logger logger = CommLogFactory.getCommLogger();
    private static final int CHS_ASCII = 3;
    private static final int CHS_LATIN1 = 4;
    private static final int CHS_LATIN2 = 5;
    private static final int CHS_LATIN3 = 6;
    private static final int CHS_LATIN4 = 7;
    private static final int CHS_CYRILLIC = 8;
    private static final int CHS_ARABIC = 9;
    private static final int CHS_GREEK = 10;
    private static final int CHS_HEBREW = 11;
    private static final int CHS_LATIN5 = 12;
    private static final int CHS_LATIN6 = 13;
    private static final int CHS_LATIN7 = 109;
    private static final int CHS_LATIN8 = 110;
    private static final int CHS_LATIN9 = 111;
    private static final int CHS_LATIN10 = 112;
    private static final int CHS_UCS2 = 1000;
    private static final int CHS_UCS4 = 1001;
    private static final int CHS_UTF16 = 1015;
    private static final int CHS_UTF8 = 106;

    public CliChannel(EndPoint[] endpoints, long timeout) throws CommException {
        try {
            this.rpc = new RPCChannel(endpoints, timeout);
            this.logger.finest("Executing RPCConnect");
            RPCConnect conn = new RPCConnect();
            RPCResult reply = this.rpc.execute(conn);
            if (this.logger.isLoggable(Level.FINEST)) {
                StringBuffer sb = new StringBuffer();
                sb.append("RPC Connect replied ").append(reply).append(" / RPC Version: low=").append(conn.getLowVersionNo()).append(" high=").append(conn.getHighVersionNo()).append(" pwdkey=").append(DebugUtil.getHex(conn.getPasswordKey()));
                this.logger.finest(sb.toString());
            }
            this.rpc.setVersion(conn.getLowVersionNo(), conn.getHighVersionNo());
            this.pwdkey = conn.getPasswordKey();
        }
        catch (CommException e) {
            if (this.rpc != null) {
                this.rpc.close();
            }
            throw e;
        }
    }

    protected CliChannel() {
    }

    public synchronized CliDbStatus getDatabaseStatus(String dbname) throws CommException {
        if (this.rpc == null) {
            throw new CommException(5);
        }
        return null;
    }

    public CliDbStatus pingDatabase(String dbname) throws CommException {
        return null;
    }

    public synchronized CliDatabase openDatabase(String username, String password, String dbname, String misc_info) throws CommException {
        if (this.rpc == null) {
            throw new CommException(6);
        }
        Password clp = new Password(password);
        byte[] encrypted_password = clp.encryptPassword(this.pwdkey);
        RPCOpenDatabase rpcod = new RPCOpenDatabase();
        rpcod.setUsername(username);
        rpcod.setPassword(encrypted_password);
        rpcod.setDatabase("");
        rpcod.setMode(5);
        rpcod.setUser("JDBCclnt");
        rpcod.setNode("unknown host");
        rpcod.setNode(Thread.currentThread().getName());
        rpcod.setTerminal(misc_info);
        rpcod.setProcessId("0");
        rpcod.setCpuNo(0L);
        rpcod.setMachineType(2);
        rpcod.setTimeZone(0);
        rpcod.setMsgCharset(106);
        rpcod.setLanguage(this.getLanguage());
        rpcod.setRPCVersion(this.rpc.getVersion());
        RPCResult reply = this.rpc.execute(rpcod, this.login_timeout);
        if (reply.getReply() == 1L) {
            RPCStatus stat = reply.getRPCStatus();
            if (stat.isError()) {
                throw new CommException(7, stat.getErrorMessage(), stat);
            }
            CliDatabaseImpl ccdb = new CliDatabaseImpl(this, this.rpc);
            return ccdb;
        }
        throw new CommException(7, "openDatabase (" + reply + ")");
    }

    public synchronized void close() {
        if (this.rpc != null) {
            this.rpc.close();
            this.rpc = null;
        }
    }

    public synchronized void setLoginTimeout(long timeout) {
        this.login_timeout = timeout;
    }

    private String getLanguage() {
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        StringBuffer result = new StringBuffer();
        result.append(language);
        if (country != null && country.length() > 0) {
            result.append(':');
            result.append(country);
        }
        if (variant != null && variant.length() > 0) {
            result.append(':');
            result.append(variant);
        }
        return result.toString();
    }

    public RPCChannel getRPCChannel() {
        return this.rpc;
    }
}

