/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.CliChannel;
import com.sun.hadb.comm.CliDatabase;
import com.sun.hadb.comm.CliStatement;
import com.sun.hadb.comm.CliStatementImpl;
import com.sun.hadb.comm.CommException;
import com.sun.hadb.comm.CommLogFactory;
import com.sun.hadb.comm.RPCChannel;
import com.sun.hadb.comm.RPCCloseDatabase;
import com.sun.hadb.comm.RPCConnect;
import com.sun.hadb.comm.RPCEndTransaction;
import com.sun.hadb.comm.RPCGetPath;
import com.sun.hadb.comm.RPCGetServerInfoArray;
import com.sun.hadb.comm.RPCResult;
import com.sun.hadb.comm.RPCSetMode;
import com.sun.hadb.comm.RPCStatus;
import com.sun.hadb.comm.RPCTransStatus;
import com.sun.hadb.jdbc.ConnectionImpl;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CliDatabaseImpl
implements CliDatabase {
    public static final int QRY_DDMODE = 0;
    public static final int QRY_AUTOCOMMIT = 1;
    public static final int QRY_READWRITE = 2;
    public static final int QRY_ISOLATION = 3;
    public static final int QRY_LOGIN_DUR = 10;
    public static final int QRY_QUERY_DUR = 11;
    public static final int QRY_TRANS_IDLE = 12;
    public static final int QRY_LOCK_WAIT = 13;
    private RPCConnect rpcPing = null;
    private String[] server_info_item = null;
    private int server_info_count;
    private RPCTransStatus transstat = null;
    private ConnectionImpl con;
    private RPCChannel rpc;
    private CliChannel chan;
    private boolean is_open = false;
    private DelayedOp commitmode = new DelayedOp(1);
    private DelayedOp readwrite = new DelayedOp(2);
    private DelayedOp isolation = new DelayedOp(3);
    private long conntimeout;
    private long querytimeout;
    private boolean doEndTransactionAnyway = true;
    private Logger logger = CommLogFactory.getCommLogger();
    private Vector stmt_vec;

    public CliDatabaseImpl(CliChannel chan, RPCChannel rpc) {
        this.chan = chan;
        this.rpc = rpc;
        this.stmt_vec = new Vector();
        this.is_open = true;
    }

    public synchronized CliStatement getStatement() throws CommException {
        this.checkOpen();
        CliStatementImpl stmt = new CliStatementImpl(this, this.rpc);
        this.stmt_vec.addElement(stmt);
        return stmt;
    }

    public synchronized void setConnection(ConnectionImpl con) {
        this.con = con;
    }

    public synchronized void setExecutionMode(int mode, long param) throws CommException {
        this.checkOpen();
        switch (mode) {
            case 1: {
                if (this.isInsideTransaction() && param == 1L) {
                    this.commit();
                }
                this.commitmode.set(param);
                break;
            }
            case 2: {
                this.readwrite.set(param);
                break;
            }
            case 3: {
                this.isolation.set(param);
                break;
            }
            default: {
                this.doSetExecutionMode(mode, param);
            }
        }
    }

    private void doSetExecutionMode(int mode, long param) throws CommException {
        RPCSetMode rsm = new RPCSetMode();
        rsm.setParameter(mode, param);
        RPCResult reply = this.rpc.execute(rsm);
        this.setTransStatus(reply.getRPCTransStatus());
        switch (mode) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 10: {
                this.conntimeout = param;
                break;
            }
            case 11: {
                this.querytimeout = param;
                this.rpc.setTimeout(param);
                break;
            }
            default: {
                this.logger.finer("CliDatabaseImpl.setExecutionMode (" + mode + ", " + param + ") : Invalid mode of operation");
            }
        }
    }

    public synchronized void ping() throws CommException {
        if (this.rpcPing == null) {
            this.rpcPing = new RPCConnect();
        }
        RPCResult result = this.rpc.execute(this.rpcPing);
    }

    public Object getServerInformation(int kind) {
        return null;
    }

    public void getServerInfo() throws CommException {
        this.fetchInfo(true);
    }

    public synchronized String getPathName(long table_id) throws CommException {
        this.checkOpen();
        RPCGetPath rpg = new RPCGetPath();
        rpg.setTableId(table_id);
        rpg.setMaxlen(255);
        RPCResult reply = this.rpc.execute(rpg);
        this.evaluateRPCResult(reply);
        String path = rpg.getPathName();
        return path;
    }

    public synchronized int getServerInfoItemCount() throws CommException {
        this.checkOpen();
        this.fetchInfo(false);
        return this.server_info_count;
    }

    public synchronized int getServerInfoItemSize() throws CommException {
        this.checkOpen();
        this.fetchInfo(false);
        return this.server_info_item.length;
    }

    public String getServerInfoItem(int index) throws CommException {
        this.checkOpen();
        this.fetchInfo(false);
        if (index < this.server_info_item.length && index >= 0) {
            return this.server_info_item[index];
        }
        return null;
    }

    private void fetchInfo(boolean force) throws CommException {
        if (force || this.server_info_item == null) {
            RPCGetServerInfoArray servarr = new RPCGetServerInfoArray();
            RPCResult reply = this.rpc.execute(servarr);
            this.evaluateRPCResult(reply);
            this.server_info_item = servarr.getItems();
            this.server_info_count = servarr.getItemCount();
        }
    }

    public synchronized RPCResult endTransaction(int kind) throws CommException {
        this.checkOpen();
        RPCEndTransaction ret = new RPCEndTransaction();
        ret.setMode(kind);
        RPCResult reply = this.rpc.execute(ret);
        this.setTransStatus(reply.getRPCTransStatus());
        this.cleanup();
        return reply;
    }

    public void commit() throws CommException {
        if (this.doEndTransactionAnyway || this.isInsideTransaction()) {
            RPCResult reply = this.endTransaction(1);
            this.evaluateRPCResult(reply);
            RPCTransStatus transtat = reply.getRPCTransStatus();
            if (transtat.isRolledBack()) {
                throw new CommException(22, "isRolledBack() == true", reply.getRPCStatus());
            }
        }
    }

    public void rollback() throws CommException {
        if (this.doEndTransactionAnyway || this.isInsideTransaction()) {
            RPCResult reply = this.endTransaction(2);
            this.evaluateRPCResult(reply);
        }
    }

    public synchronized void close() {
        this.rpcPing = null;
        this.logger.finer("CliDatabaseImpl.close() called.");
        if (this.is_open) {
            this.logger.finer("CliDatabaseImpl.close(): Calling close on " + this.stmt_vec.size() + " statements");
            Enumeration e = this.stmt_vec.elements();
            while (e.hasMoreElements()) {
                CliStatementImpl stmt = (CliStatementImpl)e.nextElement();
                if (stmt != null) {
                    stmt.close();
                    continue;
                }
                this.logger.finer("CliDatabaseImpl.close() : Statement already closed");
            }
            this.stmt_vec = null;
            this.is_open = false;
            try {
                RPCCloseDatabase rcd = new RPCCloseDatabase();
                this.rpc.execute(rcd);
            }
            catch (Exception e2) {
                this.logger.log(Level.FINE, "close failed", e2);
            }
            return;
        }
    }

    private void cleanup() {
    }

    void closeStatement(CliStatementImpl stmt) {
        if (!this.stmt_vec.remove(stmt)) {
            this.logger.fine("CliDatabaseImpl.closeStatement() : Tried to delete an unexisting statement.");
        } else {
            this.logger.finest("CliDatabaseImpl.closeStatement: statement removed successfully");
        }
    }

    public synchronized boolean isInsideTransaction() {
        if (this.transstat != null) {
            return this.transstat.isInsideTransaction();
        }
        return true;
    }

    public synchronized boolean isTransactionClosed() {
        if (this.transstat != null) {
            return this.transstat.isClosed();
        }
        return false;
    }

    public synchronized void setTransStatus(RPCTransStatus transstat) {
        this.transstat = transstat;
        if (transstat.isClosed() && this.con != null) {
            this.con.closeAllCursors();
        }
    }

    synchronized void doDelayedOps() throws CommException {
        this.commitmode.flush();
        this.readwrite.flush();
        this.isolation.flush();
    }

    public synchronized void setEliminateRedundantEndTransaction(boolean eliminate) {
        this.doEndTransactionAnyway = !eliminate;
    }

    void checkOpen() throws CommException {
        if (!this.is_open) {
            throw new CommException(21);
        }
    }

    protected void finalize() {
        if (this.is_open) {
            this.close();
        }
    }

    private void evaluateRPCResult(RPCResult reply) throws CommException {
        if (reply != null) {
            RPCStatus status = reply.getRPCStatus();
            if (status != null) {
                if (status.isError()) {
                    throw new CommException(13, status.getErrorMessage(), status);
                }
                return;
            }
            throw new CommException(1, "Missing RPC status message");
        }
        throw new CommException(1, "Missing RPC reply message");
    }

    private class DelayedOp {
        private int mode;
        private long current_value = -1L;
        private long next_value = -1L;

        DelayedOp(int mode) {
            this.mode = mode;
        }

        void set(long param) {
            this.next_value = param;
        }

        void force() throws CommException {
            CliDatabaseImpl.this.doSetExecutionMode(this.mode, this.next_value);
            this.current_value = this.next_value;
        }

        void flush() throws CommException {
            if (this.current_value != this.next_value) {
                this.force();
            }
        }
    }
}

