/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.CliDatabaseImpl;
import com.sun.hadb.comm.CliStatement;
import com.sun.hadb.comm.CommException;
import com.sun.hadb.comm.CommLogFactory;
import com.sun.hadb.comm.MessageBuffer;
import com.sun.hadb.comm.RPCChannel;
import com.sun.hadb.comm.RPCCloseStatement;
import com.sun.hadb.comm.RPCExecuteParams;
import com.sun.hadb.comm.RPCGetTuples;
import com.sun.hadb.comm.RPCGetTuplesDescr;
import com.sun.hadb.comm.RPCQpxsql;
import com.sun.hadb.comm.RPCQueryDescr;
import com.sun.hadb.comm.RPCRemoveStatement;
import com.sun.hadb.comm.RPCResult;
import com.sun.hadb.comm.RPCStatus;
import com.sun.hadb.comm.RPCTransStatus;
import java.util.logging.Level;
import java.util.logging.Logger;

class CliStatementImpl
implements CliStatement {
    private static final int TAB_FREE = 0;
    private static final int TAB_ACCESSED = 1;
    private static final int TAB_EXECUTED = 2;
    private static final int TAB_PREPARED = 3;
    private static final int MAX_STRINGLEN = 32000;
    private static final int MAX_PAR_WDS = 4044;
    private static final long VOID_RMT = -1L;
    private Logger logger = CommLogFactory.getCommLogger();
    private CliDatabaseImpl db;
    private RPCChannel rpc;
    private int tab_state;
    private long remote_table_id = -1L;
    private long query_timeout = 0L;
    private boolean is_closed = false;

    public CliStatementImpl(CliDatabaseImpl db, RPCChannel rpc) {
        this.db = db;
        this.rpc = rpc;
        this.tab_state = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RPCQueryDescr prepareAndExecuteQuery(String cmd, int count, int actions, int parmcnt, long querymode, MessageBuffer params, int fetch) throws CommException {
        CliDatabaseImpl cliDatabaseImpl = this.db;
        synchronized (cliDatabaseImpl) {
            boolean prepare;
            this.db.checkOpen();
            if (this.is_closed) {
                throw new CommException(23);
            }
            if (this.rpc == null) {
                throw new CommException(5);
            }
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("query mode = " + querymode);
            }
            boolean execute = (actions & 2) != 0;
            boolean bl = prepare = (actions & 1) != 0;
            if (cmd == null) {
                cmd = "";
            }
            if (this.tab_state == 0 && !prepare) {
                throw new CommException(8);
            }
            if (this.tab_state == 3 && prepare) {
                throw new CommException(9);
            }
            if (cmd.length() > 32000) {
                throw new CommException(10);
            }
            if (params != null) {
                long ptr = 0L;
                long size = 0L;
                for (int i = 0; i < count; ++i) {
                }
            }
            if (this.tab_state == 1) {
                this.logger.finest("FIXME: tab_state == TAB_ACCESSED");
            }
            if (this.tab_state == 2) {
                this.logger.finest("FIXME: tab_state == TAB_EXECUTED");
            }
            long bufsize = 100000L;
            long split = 0L;
            RPCQpxsql qpxsql = new RPCQpxsql(this.rpc.getVersion());
            qpxsql.setRemoteTableId(this.remote_table_id);
            qpxsql.setCommand(cmd);
            qpxsql.setActions(actions);
            qpxsql.setQueryMode(querymode);
            qpxsql.setSplit(split);
            qpxsql.setCount(count);
            qpxsql.setFetch(fetch);
            qpxsql.setParameterCount(parmcnt);
            qpxsql.setParameters(params);
            RPCQueryDescr qd = null;
            this.db.doDelayedOps();
            RPCResult reply = this.rpc.execute(qpxsql, this.query_timeout);
            RPCTransStatus transstat = reply.getRPCTransStatus();
            this.db.setTransStatus(transstat);
            qd = qpxsql.getQueryDescriptor();
            this.remote_table_id = qd.getRemoteTableId();
            RPCStatus status = reply.getRPCStatus();
            qd.setRPCStatus(status);
            if (prepare) {
                this.tab_state = 3;
            }
            if (execute) {
                this.tab_state = 2;
            }
            if (this.tab_state == 2) {
                long retparam = 0L;
                retparam = qd.getExeCount() > 0 ? qd.getExe(0).getRetparam() : 0L;
            }
            return qd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RPCQueryDescr executeParams(MessageBuffer params) throws CommException {
        CliDatabaseImpl cliDatabaseImpl = this.db;
        synchronized (cliDatabaseImpl) {
            RPCExecuteParams rep = new RPCExecuteParams(this.rpc.getVersion());
            rep.setRemoteTableId(this.remote_table_id);
            rep.setParameters(params);
            RPCResult reply = this.rpc.execute(rep, this.query_timeout);
            RPCStatus status = reply.getRPCStatus();
            this.db.setTransStatus(reply.getRPCTransStatus());
            RPCQueryDescr qd = new RPCQueryDescr(this.rpc.getVersion());
            qd.setRPCStatus(status);
            qd.setExe(rep.getExe());
            return qd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RPCGetTuplesDescr getTuples(int maxcnt, int direction, int options) throws CommException {
        CliDatabaseImpl cliDatabaseImpl = this.db;
        synchronized (cliDatabaseImpl) {
            this.db.checkOpen();
            if (this.is_closed) {
                throw new CommException(23);
            }
            if (this.rpc == null) {
                throw new CommException(5);
            }
            RPCGetTuples rgt = new RPCGetTuples(this.rpc.getVersion());
            rgt.setMaxCount(maxcnt);
            rgt.setDirection(direction);
            rgt.setRemoteTableId(this.remote_table_id);
            rgt.setOption(options);
            this.db.doDelayedOps();
            RPCResult reply = this.rpc.execute(rgt);
            this.db.setTransStatus(reply.getRPCTransStatus());
            RPCGetTuplesDescr gtd = rgt.getTuplesDescriptor();
            gtd.setRPCStatus(reply.getRPCStatus());
            return gtd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("Close statement : tab_state=" + this.tab_state + " hashcode=" + this.hashCode());
        }
        CliDatabaseImpl cliDatabaseImpl = this.db;
        synchronized (cliDatabaseImpl) {
            if (this.is_closed) {
                return;
            }
            try {
                this.db.checkOpen();
            }
            catch (CommException e) {
                return;
            }
            if (this.rpc != null && this.remote_table_id >= 0L) {
                if (this.tab_state > 0) {
                    RPCRemoveStatement rs = new RPCRemoveStatement();
                    rs.setRemoteTableId(this.remote_table_id);
                    try {
                        RPCResult reply = this.rpc.execute(rs);
                        this.db.setTransStatus(reply.getRPCTransStatus());
                    }
                    catch (CommException e) {
                        this.logger.log(Level.FINE, "Exception on close", e);
                    }
                }
                this.logger.finest("closed statement");
            }
            this.db.closeStatement(this);
            this.rpc = null;
            this.is_closed = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCursor() throws CommException {
        CliDatabaseImpl cliDatabaseImpl = this.db;
        synchronized (cliDatabaseImpl) {
            this.db.checkOpen();
            if (this.is_closed) {
                throw new CommException(23);
            }
            RPCCloseStatement cl = new RPCCloseStatement();
            cl.setRemoteTableId(this.remote_table_id);
            cl.setOption(2L);
            RPCResult reply = this.rpc.execute(cl);
            this.db.setTransStatus(reply.getRPCTransStatus());
            RPCStatus stat = reply.getRPCStatus();
            if (stat.isError()) {
                throw new CommException(13, stat.toString(), stat);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeout(long timeout) throws CommException {
        CliDatabaseImpl cliDatabaseImpl = this.db;
        synchronized (cliDatabaseImpl) {
            this.db.checkOpen();
            if (this.is_closed) {
                throw new CommException(23);
            }
            this.query_timeout = timeout;
        }
    }

    protected void finalize() {
        if (!this.is_closed) {
            this.close();
        }
    }
}

