/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.RPCStatus;
import java.io.PrintStream;
import java.util.Locale;
import java.util.ResourceBundle;

public class CommException
extends Exception {
    private static final int BASE = 25000;
    public static final int NOT_USED = 0;
    public static final int INTERNAL = 1;
    public static final int NOT_IMPLEMENTED = 2;
    public static final int UNKNOWN_HOST = 3;
    public static final int SOCKET_SEND_FAILED = 4;
    public static final int RPC_CLOSED = 5;
    public static final int RPC_NOT_RUNNING = 6;
    public static final int RPC_ERROR = 7;
    public static final int QUERY_NOT_PREPARED = 8;
    public static final int QUERY_ALREADY_PREPARED = 9;
    public static final int QUERY_TOO_LONG = 10;
    public static final int DIALOG_OVERFLOW = 11;
    public static final int RPC_CONN_FAILED = 12;
    public static final int RPC_EXEC_FAILED = 13;
    public static final int DIALOG_ALREADY_EXISTS = 14;
    public static final int DIALOG_ILLEGAL_OPERATION = 15;
    public static final int DIALOG_ILLEGAL_STATE = 16;
    public static final int SEP_NO_CONNECTION = 17;
    public static final int SEP_LOST_CONNECTION = 18;
    public static final int QUERY_TIMED_OUT = 19;
    public static final int RPC_VERSION = 20;
    public static final int DB_CLOSED = 21;
    public static final int TRANSACTION_ROLLED_BACK = 22;
    public static final int STMT_CLOSED = 23;
    public static final int OP_INTERRUPT = 24;
    public static final int LAST_ERROR = 25;
    private static final String[] errtable = new String[]{"HY000 NOT_USED", "HY000 INTERNAL", "HY000 NOT_IMPLEMENTED", "HY000 UNKNOWN_HOST", "HY000 SOCKET_SEND_FAILED", "HY000 RPC_CLOSED", "HY000 RPC_NOT_RUNNING", "HY000 RPC_ERROR", "HY010 QUERY_NOT_PREPARED", "HY010 QUERY_ALREADY_PREPARED", "22001 QUERY_TOO_LONG", "08006 DIALOG_OVERFLOW", "08001 RPC_CONN_FAILED", "08006 RPC_EXEC_FAILED", "08006 DIALOG_ALREADY_EXISTS", "08006 DIALOG_ILLEGAL_OPERATION", "08006 DIALOG_ILLEGAL_STATE", "HY000 SEP_NO_CONNECTION", "08006 SEP_LOST_CONNECTION", "HY000 QUERY_TIMED_OUT", "08004 RPC_VERSION", "08003 DB_CLOSED", "08007 TRANSACTION_ROLLED_BACK", "HY000 STMT_CLOSED", "HY000 OP_INTERRUPT", "HY000 LAST_ERROR"};
    private int errcode = 0;
    private RPCStatus rpc_status = null;

    public CommException() {
        this(1);
    }

    public CommException(int errno) {
        this(errno, null);
    }

    private static String getKMessage(int errcode, String str) {
        StringBuffer sb = new StringBuffer();
        sb.append(CommException.getError(errcode));
        sb.append(" (");
        sb.append(25000 + errcode);
        sb.append(")");
        if (str != null) {
            sb.append(" : ");
            sb.append(str);
        }
        return sb.toString();
    }

    public CommException(int errcode, String str) {
        super(CommException.getKMessage(errcode, str));
        this.errcode = errcode;
    }

    public CommException(int errcode, String str, RPCStatus status) {
        super(CommException.getKMessage(errcode, str));
        this.errcode = errcode;
        this.rpc_status = status;
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(25000 + this.errcode);
        strbuf.append(" : ");
        strbuf.append(this.getMessage());
        strbuf.append(" : ");
        if (this.rpc_status != null) {
            strbuf.append(this.rpc_status.toString());
        }
        return strbuf.toString();
    }

    public RPCStatus getRPCStatus() {
        return this.rpc_status;
    }

    public int getErrorCode() {
        return 25000 + this.errcode;
    }

    public String getSQLState() {
        return CommException.sqlCode(this.errcode);
    }

    private static String sqlCode(int errcode) {
        return errtable[errcode].substring(0, 5);
    }

    private static String getErrorKey(int errcode) {
        return errtable[errcode].substring(6);
    }

    private static String getError(int errcode) {
        String key = CommException.getErrorKey(errcode);
        ResourceBundle bundle = ResourceBundle.getBundle("com.sun.hadb.comm.CommException", Locale.getDefault());
        String message = bundle.getString(key);
        return message;
    }

    public static void listExceptions(PrintStream s) {
        ResourceBundle bundle = ResourceBundle.getBundle("com.sun.hadb.comm.CommException", Locale.getDefault());
        for (int i = 0; i < errtable.length; ++i) {
            StringBuffer sb = new StringBuffer();
            sb.append(25000 + i).append(": ").append(CommException.sqlCode(i)).append(" : ").append(bundle.getString(CommException.getErrorKey(i)));
            s.println(sb.toString());
        }
    }
}

