/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.CommException;
import com.sun.hadb.comm.CommLogFactory;
import com.sun.hadb.comm.Dialog;
import com.sun.hadb.comm.DialogCallback;
import com.sun.hadb.comm.DialogImpl;
import com.sun.hadb.comm.EndPoint;
import com.sun.hadb.comm.MessageBuffer;
import com.sun.hadb.comm.MsgInfo;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DialogManager {
    public static final int D_MASTER = 1;
    public static final int D_OPEN = 2;
    public static final int D_CLOSE = 4;
    public static final int D_RETRANS = 8;
    private static final int MAX_DIALOGID = 65535;
    private Logger logger = CommLogFactory.getCommLogger();
    private static DialogManager this_instance = new DialogManager();
    private Hashtable masterDialogs = new Hashtable();
    private Hashtable slaveDialogs = new Hashtable();
    private int lastDialogId = 0;
    private DialogCallback my_callback;

    private DialogManager() {
    }

    public static DialogManager getInstance() {
        return this_instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dialog open(EndPoint endpoint, boolean retrans, long msgkey) throws CommException {
        Hashtable hashtable = this.masterDialogs;
        synchronized (hashtable) {
            int dlgid = this.getAvailableDialogId(endpoint);
            DialogImpl dlg = new DialogImpl(this, dlgid, endpoint, retrans, true);
            dlg.setMessageKey(msgkey);
            DialogHashKey hashKey = new DialogHashKey(dlgid, endpoint);
            this.masterDialogs.put(hashKey, dlg);
            if (this.logger.isLoggable(Level.FINEST)) {
                StringBuffer sb = new StringBuffer();
                sb.append("DialogManager: open id=").append(dlgid);
                sb.append(" size=").append(this.masterDialogs.size());
                this.logger.finest(sb.toString());
            }
            return dlg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dialog openSlave(EndPoint endpoint, int dialog_id, boolean retrans, long msgkey) throws CommException {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("DialogManager.openSlave: id: " + dialog_id);
        }
        DialogHashKey key = new DialogHashKey(dialog_id, endpoint);
        Hashtable hashtable = this.slaveDialogs;
        synchronized (hashtable) {
            if (this.slaveDialogs.containsKey(key)) {
                throw new CommException(14);
            }
            DialogImpl dlg = new DialogImpl(this, dialog_id, endpoint, retrans, false);
            dlg.setMessageKey(msgkey);
            this.slaveDialogs.put(key, dlg);
            return dlg;
        }
    }

    public void setCallback(DialogCallback cbobj) {
        this.my_callback = cbobj;
    }

    void receive_handler(MsgInfo msginfo) throws CommException {
        DialogImpl dlg;
        MessageBuffer buffer = msginfo.getMessageBuffer();
        int dialog_id = buffer.getUInt16();
        int round = buffer.getUInt8();
        int flags = buffer.getUInt8();
        DialogHashKey key = new DialogHashKey(dialog_id, msginfo.getEndPoint());
        if ((flags & 1) != 0) {
            if ((flags & 2) != 0 && this.my_callback != null) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("DialogManager.receive_handler() : Calling callback");
                }
                this.my_callback.callback(dialog_id, round, flags, msginfo);
            }
            dlg = (DialogImpl)this.slaveDialogs.get(key);
        } else {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("DialogManager.receive_handler: Locating dialog with id=" + dialog_id);
            }
            dlg = (DialogImpl)this.masterDialogs.get(key);
        }
        if (dlg != null) {
            dlg.receive_handler(dialog_id, round, flags, msginfo);
        } else {
            this.logger.finest("DialogManager.receive_handler : Dialog not found, ignoring message");
            msginfo.close();
        }
    }

    void close(DialogImpl dialog) {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("DialogManager.close: " + dialog.getDialogId());
        }
        DialogHashKey key = new DialogHashKey(dialog.getDialogId(), dialog.getEndPoint());
        if (dialog.isMaster()) {
            if (this.masterDialogs.remove(key) == null) {
                this.logger.finer("DialogManager.close: did not find master dialog");
            }
        } else if (this.slaveDialogs.remove(key) == null) {
            this.logger.finer("DialogManager.close: did not find slave dialog");
        }
    }

    private int getAvailableDialogId(EndPoint endPoint) throws CommException {
        int nextDialogId = this.lastDialogId;
        do {
            nextDialogId = nextDialogId >= 65535 ? 0 : ++nextDialogId;
            DialogHashKey key = new DialogHashKey(nextDialogId, endPoint);
            if (this.masterDialogs.containsKey(key)) continue;
            this.lastDialogId = nextDialogId;
            return nextDialogId;
        } while (nextDialogId != this.lastDialogId);
        throw new CommException(11);
    }

    class DialogHashKey {
        int dialogId;
        EndPoint endPoint;

        DialogHashKey(int dialogId, EndPoint endPoint) {
            this.dialogId = dialogId;
            this.endPoint = endPoint;
        }

        public int hashCode() {
            return this.endPoint.hashCode() + this.dialogId;
        }

        public boolean equals(Object obj) {
            DialogHashKey key = (DialogHashKey)obj;
            return this.dialogId == key.dialogId && this.endPoint.equals(key.endPoint);
        }
    }
}

