/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.MessageBuffer;
import com.sun.hadb.comm.MessageChunk;
import com.sun.hadb.comm.UnsignedByteBuffer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class ExtData
implements UnsignedByteBuffer {
    private static final int EXT_NEGMASK = 128;
    private static final long YEAR_MASK_DATE = 8388096L;
    private static final long MONTH_MASK_DATE = 480L;
    private static final long DAY_MASK_DATE = 31L;
    private static final long HOUR_MASK_TIMESTAMP = 0x1F00000000L;
    private static final long MINUTE_MASK_TIMESTAMP = 0xFC000000L;
    private static final long SECOND_MASK_TIMESTAMP = 0x3F00000L;
    private static final long MICRO_MASK_TIMESTAMP = 1048575L;
    UnsignedByteBuffer buffer;
    private int pos;

    public ExtData(UnsignedByteBuffer buffer, int pos) {
        if (buffer instanceof ExtData) {
            ExtData p = (ExtData)buffer;
            this.buffer = p.buffer;
            this.pos = p.pos + pos;
        } else if (buffer instanceof MessageBuffer) {
            MessageBuffer b = (MessageBuffer)buffer;
            MessageChunk c = b.getChunkByOffset(pos);
            this.buffer = c;
            this.pos = pos - b.getOffset(c);
        } else {
            this.pos = pos;
            this.buffer = buffer == null ? new MessageBuffer() : buffer;
        }
    }

    public ExtData(UnsignedByteBuffer buffer) {
        this(buffer, 0);
    }

    public byte[] getBuffer() {
        return this.buffer.getBuffer();
    }

    public int getOffset() {
        return this.pos;
    }

    public byte[] asByteArray(int len) {
        byte[] ret = new byte[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = (byte)this.getUInt8(i);
        }
        return ret;
    }

    public byte[] asByteArray() {
        return this.asByteArray(this.size());
    }

    public int size() {
        if (this.buffer != null) {
            return this.buffer.size() - this.pos;
        }
        return 0;
    }

    public void close() {
        if (this.buffer instanceof MessageChunk) {
            this.buffer.close();
        } else if (this.buffer instanceof MessageBuffer) {
            this.buffer.close();
        }
        this.buffer = null;
    }

    public void putBytes(byte[] bytes, int offset) {
        if (bytes == null) {
            return;
        }
        this.buffer.putBytes(bytes, offset);
    }

    public void putUInt8(int v, int offset) {
        this.buffer.putUInt8(v, this.pos + offset);
    }

    public int getUInt8(int offset) {
        return this.buffer.getUInt8(this.pos + offset);
    }

    public int putByteStream(InputStream stream, int length, int offset) throws IOException {
        return this.buffer.putByteStream(stream, length, this.pos + offset);
    }

    public byte[] getBytes(int offset, int count) {
        return this.buffer.getBytes(this.pos + offset, count);
    }

    public void putInt8(byte v, int offset) {
        this.putUInt8(v ^ 0x80, offset);
    }

    public byte getInt8(int offset) {
        return (byte)((this.getUInt8(offset) ^ 0x80) & 0xFF);
    }

    public void putInt16(short v, int offset) {
        this.putUInt8(v >> 8 ^ 0x80, offset);
        this.putUInt8(v, offset + 1);
    }

    public short getInt16(int offset) {
        return (short)(((this.getUInt8(offset) ^ 0x80) << 8 & 0xFF00) + (this.getUInt8(offset + 1) & 0xFF));
    }

    public void putInt32(int v, int offset) {
        this.putUInt8(v >> 24 ^ 0x80, offset);
        this.putUInt8(v >> 16, offset + 1);
        this.putUInt8(v >> 8, offset + 2);
        this.putUInt8(v, offset + 3);
    }

    public int getInt32(int offset) {
        return ((this.getUInt8(offset + 0) ^ 0x80) << 24 & 0xFF000000) + (this.getUInt8(offset + 1) << 16 & 0xFF0000) + (this.getUInt8(offset + 2) << 8 & 0xFF00) + (this.getUInt8(offset + 3) & 0xFF);
    }

    public long getUInt32(int offset) {
        return ((long)(this.getUInt8(offset + 0) << 24) & 0xFF000000L) + ((long)(this.getUInt8(offset + 1) << 16) & 0xFF0000L) + ((long)(this.getUInt8(offset + 2) << 8) & 0xFF00L) + ((long)this.getUInt8(offset + 3) & 0xFFL);
    }

    public void putInt64(long v, int offset) {
        this.putUInt8((int)(v >> 56 ^ 0x80L), offset + 0);
        this.putUInt8((int)(v >> 48), offset + 1);
        this.putUInt8((int)(v >> 40), offset + 2);
        this.putUInt8((int)(v >> 32), offset + 3);
        this.putUInt8((int)(v >> 24), offset + 4);
        this.putUInt8((int)(v >> 16), offset + 5);
        this.putUInt8((int)(v >> 8), offset + 6);
        this.putUInt8((int)v, offset + 7);
    }

    public long getInt64(int offset) {
        long[] p = new long[8];
        for (int i = 0; i < 8; ++i) {
            p[i] = this.getUInt8(offset + i);
        }
        return (p[0] ^ 0x80L) << 56 & 0xFF00000000000000L | p[1] << 48 & 0xFF000000000000L | p[2] << 40 & 0xFF0000000000L | p[3] << 32 & 0xFF00000000L | p[4] << 24 & 0xFF000000L | p[5] << 16 & 0xFF0000L | p[6] << 8 & 0xFF00L | p[7] & 0xFFL;
    }

    public String getDecimal(int offset, int length, int scale) {
        char c;
        String s = this.toHexString(offset, offset + length);
        char check = s.charAt(s.length() - 1);
        boolean negative = check == 'b' || check == 'd';
        s = s.substring(0, s.length() - 1);
        int stringlength = s.length();
        if (scale > 0) {
            s = s.substring(0, stringlength - scale) + "." + s.substring(stringlength - scale, stringlength);
        }
        int removeLimit = 0;
        for (int i = 0; i < s.length() - 1 && (c = s.charAt(i)) == '0'; ++i) {
            removeLimit = i + 1;
        }
        if ((s = s.substring(removeLimit, s.length())).charAt(0) == '.') {
            s = "0" + s;
        }
        return negative ? "-" + s : s;
    }

    public String getDate(int offset, boolean isTimeStamp) {
        long dateext = this.getUInt32(offset);
        if (isTimeStamp) {
            dateext >>= 5;
        }
        int day = (int)(dateext & 0x1FL);
        int month = (int)((dateext & 0x1E0L) >> 5);
        int year = (int)((dateext & 0x7FFE00L) >> 9);
        String years = new Integer(year).toString();
        while (years.length() < 4) {
            years = new String("0" + years);
        }
        String months = month < 10 ? new String("0" + new Integer(month).toString()) : new Integer(month).toString();
        String days = day < 10 ? new String("0" + new Integer(day).toString()) : new Integer(day).toString();
        return new String(years + "-" + months + "-" + days);
    }

    public String getDate(int offset) {
        return this.getDate(offset, false);
    }

    public String getTime(int offset) {
        long timestampext = this.getInt64(offset);
        int hour = (int)((timestampext & 0x1F00000000L) >> 32);
        int minute = (int)((timestampext & 0xFC000000L) >> 26);
        int second = (int)((timestampext & 0x3F00000L) >> 20);
        int microsek = (int)(timestampext & 0xFFFFFL);
        String hours = hour < 10 ? new String("0" + new Integer(hour).toString()) : new Integer(hour).toString();
        String minutes = minute < 10 ? new String("0" + new Integer(minute).toString()) : new Integer(minute).toString();
        String seconds = second < 10 ? new String("0" + new Integer(second).toString()) : new Integer(second).toString();
        String microseks = new Integer(microsek).toString();
        while (microseks.length() < 6) {
            microseks = new String("0" + microseks);
        }
        return microsek == 0 ? new String(hours + ":" + minutes + ":" + seconds) : new String(hours + ":" + minutes + ":" + seconds + "." + microseks);
    }

    public void setTime(long hour, long minute, long second, long microsek, int offset) {
        long time = (hour << 32) + (minute << 26) + (second << 20) + microsek;
        this.putInt64(time, offset);
    }

    public void setTimeWithTimezone(long hour, long minute, long second, long microsek, int tzhour, int tzmin, int offset) {
        this.setTime(hour, minute, second, microsek, offset);
        int tzoff = tzhour * 60 + tzmin;
        this.putInt16((short)tzoff, offset + 8);
    }

    public void setDate(long year, long month, long day, int offset) {
        long date = (year << 9) + (month << 5) + day;
        this.putInt32((int)date, offset);
    }

    public void setTimestamp(long year, long month, long day, long hour, long minute, long second, long microsek, int offset) {
        long timestamp = (year << 46) + (month << 42) + (day << 37) + (hour << 32) + (minute << 26) + (second << 20) + microsek;
        this.putInt64(timestamp, offset);
    }

    public void setTimestampWithTimezone(long year, long month, long day, long hour, long minute, long second, long microsek, int tzhour, int tzmin, int offset) {
        this.setTimestamp(year, month, day, hour, minute, second, microsek, offset);
        int tzoff = tzhour * 60 + tzmin;
        this.putInt16((short)tzoff, offset + 8);
    }

    public String getTimeStamp(int offset) {
        return new String(this.getDate(offset, true) + " " + this.getTime(offset));
    }

    public static String byteToHexString(byte[] p, int start, int stop) {
        String s3 = new String();
        if (stop > p.length) {
            stop = p.length;
        }
        for (int i = start; i < stop; ++i) {
            String s1 = new String(Integer.toHexString((p[i] & 0xF0) >> 4));
            String s2 = new String(Integer.toHexString(p[i] & 0xF));
            s3 = s3 + s1 + s2;
        }
        return s3;
    }

    public static String byteToHexString(byte[] p) {
        return ExtData.byteToHexString(p, 0, p.length);
    }

    public String toHexString(int start, int stop) {
        ExtData p = new ExtData(this, start);
        return ExtData.byteToHexString(p.asByteArray(stop - start));
    }

    public String toHexString() {
        byte[] buf = this.asByteArray(this.size());
        return ExtData.byteToHexString(buf, 0, buf.length);
    }

    public String toHexString(int len) {
        byte[] buf = this.asByteArray(len);
        return ExtData.byteToHexString(buf);
    }

    public String toCharString(int start, int len) {
        ExtData p = new ExtData(this, start);
        byte[] buf = p.asByteArray(len);
        try {
            return new String(buf, 0, len, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("ISO-8859-1 not supported", e);
        }
    }

    public void toFile(String filename) throws IOException {
        FileOutputStream file = new FileOutputStream(filename);
        byte[] data = this.asByteArray(this.size());
        file.write(data);
        file.close();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("EXTDATA: buffer size=").append(this.buffer.size());
        sb.append(" pos=").append(this.pos);
        return sb.toString();
    }

    public static void main(String[] args) {
        long lowVal = args.length == 2 ? new Long(args[0]) : Integer.MIN_VALUE;
        long highVal = args.length == 2 ? new Long(args[1]) : Integer.MAX_VALUE;
        ExtData p64 = new ExtData(new MessageBuffer(8));
        ExtData p32 = new ExtData(new MessageBuffer(4));
        ExtData p16 = new ExtData(new MessageBuffer(2));
        ExtData p8 = new ExtData(new MessageBuffer(1));
        for (long i = lowVal; i < highVal; ++i) {
            p64.putInt64(i, 0);
            p32.putInt32((int)i, 0);
            p16.putInt16((short)i, 0);
            p8.putInt8((byte)i, 0);
            long j64 = p64.getInt64(0);
            long j32 = p32.getInt32(0);
            long j16 = p16.getInt16(0);
            long j8 = p8.getInt8(0);
            System.out.print(i + " : " + p64.toHexString());
            System.out.print(": " + p32.toHexString());
            System.out.print(": " + p16.toHexString());
            System.out.println(": " + p8.toHexString());
            if (i == j64 && (long)((int)i) == j32 && (long)((short)i) == j16 && (long)((byte)i) == j8) continue;
            System.out.println("ERROR with value:" + i + "?=" + j64);
            System.out.println("ERROR with value:" + (int)i + "?=" + j32);
            System.out.println("ERROR with value:" + (short)i + "?=" + j16);
            System.out.println("ERROR with value:" + (byte)i + "?=" + j8);
            p64.putInt64(j64, 0);
            System.out.println("j = " + p64.toHexString());
            System.out.println("p32:" + p32.toHexString());
            System.out.println("p16:" + p16.toHexString());
            System.out.println("p8:" + p8.toHexString());
            break;
        }
    }
}

