/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import java.io.PrintWriter;
import java.sql.DriverManager;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Logger {
    public static final int OFF = 0;
    public static final int SEVERE = 1;
    public static final int WARNING = 16;
    public static final int INFO = 32;
    public static final int CONFIG = 48;
    public static final int FINE = 64;
    public static final int FINER = 80;
    public static final int FINEST = 96;
    public static final int ALL = 256;
    private static int loglevel = 0;
    private static SimpleDateFormat formatter = null;

    public static String levelToString(int level) {
        switch (level) {
            case 0: {
                return "OFF     ";
            }
            case 1: {
                return "SEVERE  ";
            }
            case 16: {
                return "WARNING ";
            }
            case 32: {
                return "INFO    ";
            }
            case 48: {
                return "CONFIG  ";
            }
            case 64: {
                return "FINE    ";
            }
            case 80: {
                return "FINER   ";
            }
            case 96: {
                return "FINEST  ";
            }
            case 256: {
                return "ALL     ";
            }
        }
        return "?LEVEL? ";
    }

    public static synchronized void log(int level, String msg) {
        PrintWriter logwriter;
        if (level <= loglevel && (logwriter = DriverManager.getLogWriter()) != null) {
            Date d = new Date();
            if (formatter == null) {
                formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            }
            StringBuffer sb = new StringBuffer();
            sb.append(Logger.levelToString(level));
            sb.append(formatter.format(d));
            sb.append(" JDBC (");
            sb.append(Thread.currentThread().getName());
            sb.append(") ");
            sb.append(msg);
            logwriter.println(sb.toString());
            logwriter.flush();
        }
    }

    public static synchronized void log(int level, String msg, Throwable throwable) {
        if (level <= loglevel) {
            StringBuffer sb = new StringBuffer();
            if (msg != null) {
                sb.append(msg).append('\n');
            }
            sb.append(Logger.presentThrowable(throwable));
            Logger.log(level, sb.toString());
        }
    }

    private static String presentThrowable(Throwable t) {
        if (t != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(t.toString()).append('\n');
            StackTraceElement[] trace = t.getStackTrace();
            for (int i = 0; i < trace.length; ++i) {
                StackTraceElement e = trace[i];
                sb.append("  ").append(e.getClassName()).append('.').append(e.getMethodName());
                sb.append(" (").append(e.getFileName()).append(':').append(e.getLineNumber());
                sb.append(")\n");
            }
            sb.append(Logger.presentThrowable(t.getCause()));
            return sb.toString();
        }
        return "(no further cause)";
    }

    public static void setLogWriter(PrintWriter logwriter) {
        DriverManager.setLogWriter(logwriter);
    }

    public static void setLogLevel(int level) {
        loglevel = level;
    }

    public static int getLogLevel() {
        return loglevel;
    }

    public static void setLogLevel(String level) {
        if (level != null) {
            if ((level = level.toUpperCase()).startsWith("FINEST")) {
                Logger.setLogLevel(96);
            } else if (level.startsWith("FINER")) {
                Logger.setLogLevel(80);
            } else if (level.startsWith("FINE")) {
                Logger.setLogLevel(64);
            } else if (level.startsWith("CONFIG")) {
                Logger.setLogLevel(48);
            } else if (level.startsWith("INFO")) {
                Logger.setLogLevel(32);
            } else if (level.startsWith("WARNING")) {
                Logger.setLogLevel(16);
            } else if (level.startsWith("SEVERE")) {
                Logger.setLogLevel(1);
            } else if (level.startsWith("ALL")) {
                Logger.setLogLevel(256);
            } else if (level.startsWith("OFF")) {
                Logger.setLogLevel(0);
            } else if (level.startsWith("NONE")) {
                Logger.setLogLevel(0);
            }
        }
    }

    public static void severe(String msg) {
        Logger.log(1, msg);
    }

    public static void warning(String msg) {
        Logger.log(16, msg);
    }

    public static void info(String msg) {
        Logger.log(32, msg);
    }

    public static void config(String msg) {
        Logger.log(48, msg);
    }

    public static void fine(String msg) {
        Logger.log(64, msg);
    }

    public static void finer(String msg) {
        Logger.log(80, msg);
    }

    public static void finest(String msg) {
        Logger.log(96, msg);
    }
}

