/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.CommLogFactory;
import com.sun.hadb.comm.MessageBuffer;
import com.sun.hadb.comm.MessageChunkByteArray;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LongInMsg {
    private static final int CLU_MAX_MSGPARTS = 8;
    private static final int CLU_INIT_MSGPARTS = 4;
    private Logger logger = CommLogFactory.getCommLogger();
    private long msgSeqNo = -1L;
    private int dataRecv;
    private LongMsgPart[] part = new LongMsgPart[8];

    public LongInMsg() {
        for (int p = 0; p < 8; ++p) {
            this.part[p] = new LongMsgPart();
        }
        this.reset();
    }

    public void reset() {
        this.msgSeqNo = -1L;
        this.dataRecv = 0;
        for (int p = 0; p < 8; ++p) {
            this.part[p].init();
        }
    }

    private void init(long seqNo, int msgSize, int partNo, int offset, MessageBuffer fragment) {
        this.msgSeqNo = seqNo;
        this.dataRecv = 0;
    }

    public boolean addMsgFragment(long seqNo, int msgSize, int partNo, MessageBuffer fragment) {
        int offset = 0;
        if (partNo > 0) {
            if (fragment.size() <= 4) {
                this.logger.finest("LongInMsg.addMsgFragment: received too short fragment: " + fragment.size());
                return false;
            }
            offset = (int)fragment.getUInt32();
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("LongInMsg.addMsgFragment: offset: " + offset);
        }
        if (this.msgSeqNo == -1L) {
            this.init(seqNo, msgSize, partNo, offset, fragment);
        }
        if (this.part[partNo].fragment == null) {
            this.part[partNo].set(offset, fragment);
            this.dataRecv += fragment.size();
        }
        return this.dataRecv + 23 == msgSize;
    }

    public long getSequenceNumber() {
        return this.msgSeqNo;
    }

    public MessageBuffer getMessageBody() {
        MessageBuffer body = new MessageBuffer();
        int partNo = 0;
        for (int bodySize = 0; partNo < 8 && bodySize < this.dataRecv; bodySize += this.part[partNo].fragment.size(), ++partNo) {
            if (this.part[partNo].fragment != null) {
                if (this.part[partNo].offset != bodySize) {
                    this.logger.finest("LongInMsg.getMessageBody: wrong offset: " + this.part[partNo].offset + " should be: " + bodySize);
                    return null;
                }
                body.append(this.part[partNo].fragment);
                continue;
            }
            this.logger.finest("LongInMsg.getMessageBody: missing data for part " + partNo);
            return null;
        }
        byte[] buf = body.getBuffer();
        MessageChunkByteArray chunk = new MessageChunkByteArray(buf, body.size());
        MessageBuffer oneChunkBody = new MessageBuffer();
        oneChunkBody.append(chunk);
        return oneChunkBody;
    }

    class LongMsgPart {
        private int offset;
        private MessageBuffer fragment;

        LongMsgPart() {
            this.init();
        }

        public void init() {
            this.offset = -1;
            this.fragment = null;
        }

        public void set(int offset, MessageBuffer fragment) {
            this.offset = offset;
            this.fragment = fragment;
        }
    }
}

