/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.MessageChunk;
import com.sun.hadb.comm.MessageChunkByteArray;
import com.sun.hadb.comm.UnsignedByteBuffer;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class MessageBuffer
implements UnsignedByteBuffer,
Cloneable {
    private List chunkList = new ArrayList();

    public MessageBuffer() {
    }

    public MessageBuffer(int size) {
        while (size > 0) {
            this.appendUInt8(0);
            --size;
        }
    }

    public Object clone() {
        MessageBuffer clone = new MessageBuffer();
        ListIterator li = this.chunkList.listIterator();
        while (li.hasNext()) {
            MessageChunk chunk = (MessageChunk)li.next();
            if (chunk == null) continue;
            clone.append((MessageChunk)chunk.clone());
        }
        return clone;
    }

    public void close() {
        if (this.chunkList != null) {
            ListIterator li = this.chunkList.listIterator();
            while (li.hasNext()) {
                MessageChunk cur_chunk = (MessageChunk)li.next();
                if (cur_chunk == null) continue;
                cur_chunk.close();
            }
            this.chunkList = null;
        }
    }

    public void append(MessageChunk chunk) {
        this.chunkList.add(chunk);
    }

    public void append(MessageBuffer mb) {
        for (int i = 0; i < mb.count(); ++i) {
            this.append(mb.getChunk(i));
        }
    }

    public void prepend(MessageChunk chunk) {
        this.chunkList.add(0, chunk);
    }

    public void insertBefore(int index, MessageChunk chunk) {
        this.insertAt(index - 1, chunk);
    }

    public void insertAfter(int index, MessageChunk chunk) {
        this.insertAt(index + 1, chunk);
    }

    public void insertAt(int index, MessageChunk chunk) {
        if (index < 0) {
            index = 0;
        }
        if (index >= this.chunkList.size()) {
            for (int i = this.chunkList.size(); i < index; ++i) {
                this.chunkList.add(null);
            }
            this.chunkList.add(chunk);
        } else if (this.chunkList.get(index) == null) {
            this.chunkList.set(index, chunk);
        } else {
            this.chunkList.add(index, chunk);
        }
    }

    public MessageChunk getChunk(int index) {
        return (MessageChunk)this.chunkList.get(index);
    }

    public int count() {
        return this.chunkList.size();
    }

    public int size() {
        int sum = 0;
        ListIterator li = this.chunkList.listIterator();
        while (li.hasNext()) {
            MessageChunk chunk = (MessageChunk)li.next();
            if (chunk == null) continue;
            sum += chunk.size();
        }
        return sum;
    }

    public byte[] getBuffer() {
        int writeptr = 0;
        byte[] buffer = new byte[this.size()];
        ListIterator li = this.chunkList.listIterator();
        while (li.hasNext()) {
            MessageChunk chunk = (MessageChunk)li.next();
            chunk.get(buffer, writeptr);
            writeptr += chunk.size();
        }
        return buffer;
    }

    public ByteBuffer getBufferNIODirect(ByteBuffer buffer) {
        buffer.clear();
        ListIterator li = this.chunkList.listIterator();
        while (li.hasNext()) {
            MessageChunk chunk = (MessageChunk)li.next();
            if (chunk == null) continue;
            chunk.get(buffer);
        }
        return buffer;
    }

    MessageChunk getChunkByOffset(int offset) throws IndexOutOfBoundsException {
        if (offset >= 0) {
            ListIterator li = this.chunkList.listIterator();
            while (li.hasNext()) {
                MessageChunk chunk = (MessageChunk)li.next();
                if (chunk.size() >= offset) {
                    return chunk;
                }
                offset -= chunk.size();
            }
        }
        throw new IndexOutOfBoundsException("MessageChunk not found. index=" + offset);
    }

    int getOffset(MessageChunk wantedchunk) {
        int offset = 0;
        ListIterator li = this.chunkList.listIterator();
        while (li.hasNext()) {
            MessageChunk chunk = (MessageChunk)li.next();
            if (chunk == wantedchunk) {
                return offset;
            }
            offset += chunk.size();
        }
        throw new IndexOutOfBoundsException("MessageChunk not found. index=" + wantedchunk);
    }

    public int getUInt8() {
        return this.getFirstChunk().getUInt8();
    }

    public int getUInt16() {
        return this.getFirstChunk().getUInt16();
    }

    public long getUInt32() {
        return this.getFirstChunk().getUInt32();
    }

    public int getInt8() {
        return this.getFirstChunk().getInt8();
    }

    public int getInt16() {
        return this.getFirstChunk().getInt16();
    }

    public int getInt32() {
        return this.getFirstChunk().getInt32();
    }

    public long getInt64() {
        return this.getFirstChunk().getInt64();
    }

    public void putUInt8(int v, int offset) {
        MessageChunk chunk = this.getChunkByOffset(offset);
        chunk.putUInt8(v, offset - this.getOffset(chunk));
    }

    public void putBytes(byte[] v, int offset) {
        MessageChunk chunk = this.getChunkByOffset(offset);
        chunk.putBytes(v, offset - this.getOffset(chunk));
    }

    public int putByteStream(InputStream str, int length, int offset) throws IOException {
        MessageChunk chunk = this.getChunkByOffset(offset);
        return chunk.putByteStream(str, length, offset);
    }

    public void appendUInt8(int value) {
        this.getLastChunk().appendUInt8(value);
    }

    public void appendUInt16(int value) {
        this.getLastChunk().appendUInt16(value);
    }

    public void appendUInt32(long value) {
        this.getLastChunk().appendUInt32(value);
    }

    public void appendInt16(int value) {
        this.getLastChunk().appendInt16(value);
    }

    public void appendInt32(int value) {
        this.getLastChunk().appendInt32(value);
    }

    public int getUInt8(int offset) throws IndexOutOfBoundsException {
        MessageChunk chunk = this.getChunkByOffset(offset);
        return chunk.getUInt8(offset - this.getOffset(chunk));
    }

    public int getUInt16(int offset) throws IndexOutOfBoundsException {
        MessageChunk chunk = this.getChunkByOffset(offset);
        return chunk.getUInt16(offset - this.getOffset(chunk));
    }

    public long getUInt32(int offset) throws IndexOutOfBoundsException {
        MessageChunk chunk = this.getChunkByOffset(offset);
        return chunk.getUInt32(offset - this.getOffset(chunk));
    }

    public String getString(int offset, int count) throws IndexOutOfBoundsException {
        MessageChunk chunk = this.getChunkByOffset(offset);
        return chunk.getString(offset - this.getOffset(chunk), count);
    }

    public byte[] getBytes(int offset, int count) throws IndexOutOfBoundsException {
        MessageChunk chunk = this.getChunkByOffset(offset);
        return chunk.getBytes(count, offset - this.getOffset(chunk));
    }

    public MessageBuffer getMessageFragment(int offset, int size) throws IndexOutOfBoundsException {
        MessageBuffer newMsgBuf;
        if (offset < 0 || size <= 0) {
            throw new IllegalArgumentException();
        }
        if (offset + size > this.size()) {
            throw new IndexOutOfBoundsException("Fragment outside message buffer");
        }
        if (offset == 0 && size == this.size()) {
            newMsgBuf = this;
        } else {
            int chunkSize;
            newMsgBuf = new MessageBuffer();
            ListIterator li = this.chunkList.listIterator();
            for (int pos = 0; li.hasNext() && pos < offset + size; pos += chunkSize) {
                MessageChunk chunk = (MessageChunk)li.next();
                chunkSize = chunk.size();
                if (pos + chunkSize <= offset) continue;
                if (pos >= offset && pos + chunkSize <= offset + size) {
                    newMsgBuf.append(chunk);
                    continue;
                }
                int chunkPartStart = 0;
                if (offset >= pos) {
                    chunkPartStart = offset - pos;
                }
                int chunkPartEnd = chunkSize;
                if (offset + size <= pos + chunkSize) {
                    chunkPartEnd = offset + size - pos;
                }
                MessageChunk chunkFragment = chunk.getFragment(chunkPartStart, chunkPartEnd - chunkPartStart);
                newMsgBuf.append(chunkFragment);
            }
        }
        return newMsgBuf;
    }

    private MessageChunk getFirstChunk() {
        MessageChunk chunk;
        if (this.chunkList.size() == 0) {
            chunk = new MessageChunkByteArray(10);
            this.append(chunk);
        } else {
            chunk = (MessageChunk)this.chunkList.get(0);
        }
        return chunk;
    }

    private MessageChunk getLastChunk() {
        MessageChunk chunk;
        int siz = this.chunkList.size();
        if (siz == 0) {
            chunk = new MessageChunkByteArray(10);
            this.append(chunk);
        } else {
            chunk = (MessageChunk)this.chunkList.get(siz - 1);
        }
        return chunk;
    }

    public String toString() {
        byte[] buff = this.getBuffer();
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < buff.length; ++i) {
            int a;
            if (i % 16 == 0) {
                str.append('\n');
            }
            int b = (a = buff[i]) < 0 ? 256 + a : a;
            str.append(this.getHexByte(b));
            str.append(' ');
        }
        return str.toString();
    }

    private String getHexByte(int b) {
        return "" + this.getHexNibble(b >> 4) + this.getHexNibble(b);
    }

    private char getHexNibble(int b) {
        switch (b & 0xF) {
            case 0: {
                return '0';
            }
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
            case 3: {
                return '3';
            }
            case 4: {
                return '4';
            }
            case 5: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return '7';
            }
            case 8: {
                return '8';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return 'A';
            }
            case 11: {
                return 'B';
            }
            case 12: {
                return 'C';
            }
            case 13: {
                return 'D';
            }
            case 14: {
                return 'E';
            }
            case 15: {
                return 'F';
            }
        }
        return 'X';
    }

    public MessageBuffer(String filename) throws FileNotFoundException, IOException {
        FileInputStream file = new FileInputStream(filename);
        this.append(new MessageChunkByteArray(file));
        file.close();
    }
}

