/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.ExtData;
import com.sun.hadb.comm.UnsignedByteBuffer;
import java.nio.ByteBuffer;

public abstract class MessageChunk
implements UnsignedByteBuffer,
Cloneable {
    public abstract Object clone();

    public abstract void close();

    public byte[] getBuffer() {
        return this.getChunk();
    }

    public abstract int size();

    public abstract ExtData allocate(int var1);

    public abstract void appendUInt8(int var1);

    public void appendUInt16(int value) {
        this.appendUInt8(value >> 8 & 0xFF);
        this.appendUInt8(value >> 0 & 0xFF);
    }

    public void appendUInt32(long value) {
        this.appendUInt8((int)(value >> 24) & 0xFF);
        this.appendUInt8((int)(value >> 16) & 0xFF);
        this.appendUInt8((int)(value >> 8) & 0xFF);
        this.appendUInt8((int)(value >> 0) & 0xFF);
    }

    public void appendInt16(int value) {
        this.appendUInt8(value >> 8 & 0xFF ^ 0x80);
        this.appendUInt8(value >> 0 & 0xFF);
    }

    public void appendInt32(int value) {
        this.appendUInt8(value >> 24 & 0xFF ^ 0x80);
        this.appendUInt8(value >> 16 & 0xFF);
        this.appendUInt8(value >> 8 & 0xFF);
        this.appendUInt8(value >> 0 & 0xFF);
    }

    public abstract int getUInt8() throws IndexOutOfBoundsException;

    public int getUInt16() throws IndexOutOfBoundsException {
        int a = this.getUInt8();
        int b = this.getUInt8();
        return a << 8 | b << 0;
    }

    public long getUInt32() throws IndexOutOfBoundsException {
        long a = this.getUInt8();
        int b = this.getUInt8();
        int c = this.getUInt8();
        int d = this.getUInt8();
        return a << 24 | (long)(b << 16) | (long)(c << 8) | (long)(d << 0);
    }

    public int getInt8() throws IndexOutOfBoundsException {
        int a = this.getUInt8() ^ 0x80;
        return a & 0xFF;
    }

    public int getInt16() throws IndexOutOfBoundsException {
        int a = this.getUInt8() ^ 0x80;
        int b = this.getUInt8();
        return a << 8 & 0xFF00 | b << 0 & 0xFF;
    }

    public int getInt32() throws IndexOutOfBoundsException {
        int a = this.getUInt8() ^ 0x80;
        int b = this.getUInt8();
        int c = this.getUInt8();
        int d = this.getUInt8();
        return a << 24 | b << 16 | c << 8 | d << 0;
    }

    public long getInt64() throws IndexOutOfBoundsException {
        long a = this.getUInt8() ^ 0x80;
        long b = this.getUInt8();
        long c = this.getUInt8();
        long d = this.getUInt8();
        long e = this.getUInt8();
        long f = this.getUInt8();
        long g = this.getUInt8();
        long h = this.getUInt8();
        return a << 56 & 0xFF00000000000000L | b << 48 & 0xFF000000000000L | c << 40 & 0xFF0000000000L | d << 32 & 0xFF00000000L | e << 24 & 0xFF000000L | f << 16 & 0xFF0000L | g << 8 & 0xFF00L | h & 0xFFL;
    }

    public abstract int getUInt8(int var1) throws IndexOutOfBoundsException;

    public abstract void putUInt8(int var1, int var2) throws IndexOutOfBoundsException;

    public abstract void putBytes(byte[] var1, int var2) throws IndexOutOfBoundsException;

    public int getUInt16(int offset) throws IndexOutOfBoundsException {
        int a = this.getUInt8(offset);
        int b = this.getUInt8(offset + 1);
        return a << 8 | b << 0;
    }

    public long getUInt32(int offset) throws IndexOutOfBoundsException {
        long a = this.getUInt8(offset);
        int b = this.getUInt8(offset + 1);
        int c = this.getUInt8(offset + 2);
        int d = this.getUInt8(offset + 3);
        return a << 24 | (long)(b << 16) | (long)(c << 8) | (long)(d << 0);
    }

    public abstract byte[] getBytes(int var1, int var2) throws IndexOutOfBoundsException;

    public abstract void get(byte[] var1, int var2);

    public abstract void get(ByteBuffer var1);

    public abstract MessageChunk getFragment(int var1, int var2);

    public abstract String getString(int var1, int var2) throws IndexOutOfBoundsException;

    public abstract byte[] getChunk();

    public ExtData getAsExtData() {
        return new ExtData(this);
    }
}

