/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.CInteger;
import com.sun.hadb.comm.CommException;
import com.sun.hadb.comm.CommLogFactory;
import com.sun.hadb.comm.DialogManager;
import com.sun.hadb.comm.EndPoint;
import com.sun.hadb.comm.LongInMsg;
import com.sun.hadb.comm.MessageBuffer;
import com.sun.hadb.comm.MessageChunk;
import com.sun.hadb.comm.MsgChannel;
import com.sun.hadb.comm.MsgDescr;
import com.sun.hadb.comm.MsgHeader;
import com.sun.hadb.comm.MsgInfo;
import com.sun.hadb.comm.MsgManager;
import com.sun.hadb.comm.TimeVal;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

class MsgChannelImpl
implements MsgChannel {
    private static final int MSG_PAYLOAD_NONE = 0;
    private static final int MSG_PAYLOAD_MASK = 6;
    private static final int MSG_ACK = 8;
    private static final int MSG_RESEND = 16;
    private static final int MSG_RESEND_FROM = 32;
    private static final int MSG_NO_RETRANS = 64;
    private static final int MSG_RESET_SEQ = 128;
    private static final int VOID_MSGPARTNO = 255;
    public static final int RESET_SEQUENCE_REQ = 1;
    public static final int RESET_SEQUENCE_ACK = 2;
    static final int CLU_MAX_MSGSIZE = 32768;
    static final int CLU_UDP_MINSIZE = 9000;
    private static final int NO_ACK_NEEDED = 1;
    private static final int ACK_NEEDED = 2;
    private static final int ACK_TIMEOUT = 3;
    Logger logger = CommLogFactory.getCommLogger();
    private MsgManager my_manager;
    private EndPoint my_endpoint;
    private long inCid = 0L;
    private long outCid = 0L;
    private int protoVersion = 254;
    private int nOpen;
    private boolean inUse = true;
    private int udpMsgSize = 9000;
    private int fragmentSizeUdp = 8973;
    private MsgStream unreliable;
    private ReliableMsgStream reliable;
    private boolean initResetSent = false;
    private boolean waitForReset = true;
    private TimeVal lastResetRecv;
    private SendQueue sendQueue;
    private int needAck = 1;
    private long lastResendFrom = 0xFFFFFFFFL;
    private BoolFlag retransmitEnabled = new BoolFlag(true);

    public MsgChannelImpl(MsgManager manager, long cid, EndPoint endpoint) {
        this.my_manager = manager;
        this.my_endpoint = endpoint;
        this.inCid = cid;
        this.unreliable = new MsgStream();
        this.reliable = new ReliableMsgStream();
        this.sendQueue = new SendQueue();
        this.lastResetRecv = new TimeVal();
    }

    public synchronized void open() throws CommException {
        if (!this.initResetSent) {
            this.sendResetSeqRequest();
            this.initResetSent = true;
        }
        ++this.nOpen;
        this.inUse = true;
    }

    public synchronized void close() {
        if (this.nOpen <= 0) {
            throw new IllegalStateException("Illegal reference counter");
        }
        --this.nOpen;
    }

    private void sendResetSeqRequest() throws CommException {
        this.logger.finest("MsgChannelImpl.sendResetSeq() called");
        MessageBuffer buf = new MessageBuffer();
        buf.appendUInt8(1);
        TimeVal now = new TimeVal();
        now.fetch();
        now.append(buf);
        TimeVal ackTime = new TimeVal();
        ackTime.append(buf);
        buf.appendUInt32(32768L);
        buf.appendUInt32(this.inCid);
        long outSeqNo = this.reliable.getNextOutSeq();
        MsgHeader header = new MsgHeader(this.outCid, outSeqNo, 2903L, 0, true, buf);
        header.setResetSequenceFlag();
        this.waitForReset = true;
        this.sendMessage(header, buf);
        this.sendQueue.add(header, buf);
    }

    private void sendResetSeqAck(TimeVal ackTimeStamp) throws CommException {
        this.logger.finest("MsgChannelImpl.sendResetSeqAck():");
        MessageBuffer buf = new MessageBuffer();
        buf.appendUInt8(2);
        TimeVal now = new TimeVal();
        now.fetch();
        now.append(buf);
        ackTimeStamp.append(buf);
        buf.appendUInt32(32768L);
        buf.appendUInt32(this.inCid);
        long outSeqNo = 1L;
        MsgHeader header = new MsgHeader(this.outCid, outSeqNo, 2903L, 0, true, buf);
        header.setResetSequenceFlag();
        this.sendMessage(header, buf);
        this.sendQueue.addFirst(header, buf);
    }

    public synchronized void send(MessageBuffer buffer, long msgkey, int payload, boolean retrans) throws CommException {
        long trseqno = retrans ? this.reliable.getNextOutSeq() : this.unreliable.getNextOutSeq();
        this.send(buffer, trseqno, msgkey, payload, retrans);
    }

    private void send(MessageBuffer buf, long seqNo, long msgkey, int payload, boolean retrans) throws CommException {
        this.logger.finest("MSG: Send Process start*******");
        long size = 23 + buf.size();
        int flags = payload;
        if (size >= 32768L) {
            this.logger.finest("MsgChannelImpl.send: message size larger than MAX message size: " + size);
            throw new IllegalArgumentException();
        }
        MsgHeader header = new MsgHeader(this.outCid, seqNo, msgkey, payload, retrans, buf);
        this.sendMessage(header, buf);
        if (retrans) {
            this.sendQueue.add(header, buf);
        }
        this.logger.finest("MSG: Send process end#########");
    }

    private void sendMessage(MsgHeader header, MessageBuffer body) throws CommException {
        this.sendMessageUDP(header, body);
    }

    private void sendMessageUDP(MsgHeader header, MessageBuffer body) throws CommException {
        this.setAckInfo(header);
        if (header.getMessageSize() <= (long)this.udpMsgSize) {
            this.sendPacketUDP(header, body);
        } else {
            int bodyLen = body.size();
            int nParts = bodyLen / this.fragmentSizeUdp;
            if (bodyLen % this.fragmentSizeUdp != 0) {
                ++nParts;
            }
            for (int partNo = 0; partNo < nParts; ++partNo) {
                this.sendMessagePartUDP(header, body, partNo);
            }
        }
    }

    private void sendMessagePartUDP(MsgHeader header, MessageBuffer body, int partNo) throws CommException {
        MessageBuffer fragment;
        int fragmentOffset = partNo * this.fragmentSizeUdp;
        int fragmentSize = this.fragmentSizeUdp;
        int bodySize = body.size();
        if (fragmentOffset + fragmentSize > bodySize && ((fragmentSize = bodySize - fragmentOffset) <= 0 || fragmentSize > this.fragmentSizeUdp)) {
            System.out.println("sendMessagePartUDP: assertion failed. Exiting");
            System.exit(1);
        }
        if ((fragment = body.getMessageFragment(fragmentOffset, fragmentSize)).size() != fragmentSize) {
            System.out.println("sendMessagePartUDP: wrong fragment size: requested: " + fragmentSize + " actual: " + fragment.size());
            System.exit(1);
        }
        header.setPartNo(partNo, fragmentOffset);
        this.sendPacketUDP(header, fragment);
    }

    private void sendPacketUDP(MsgHeader header, MessageBuffer body) throws CommException {
        int p;
        int nBodyParts;
        MessageBuffer msg;
        MessageChunk head;
        if (this.protoVersion == 254 || this.protoVersion == 4) {
            head = header.getHeader(4);
            msg = new MessageBuffer();
            msg.append(head);
            nBodyParts = body.count();
            for (p = 0; p < nBodyParts; ++p) {
                msg.append(body.getChunk(p));
            }
            this.my_manager.send(this.my_endpoint, msg);
        }
        if (this.protoVersion == 254 || this.protoVersion == 5) {
            head = header.getHeader(5);
            msg = new MessageBuffer();
            msg.append(head);
            nBodyParts = body.count();
            for (p = 0; p < nBodyParts; ++p) {
                msg.append(body.getChunk(p));
            }
            this.my_manager.send(this.my_endpoint, msg);
        }
    }

    private void setAckInfo(MsgHeader header) {
        if (!(header.hasResetSequenceFlag() || header.hasResendFromFlag() || header.hasResendFlag())) {
            header.setAckSeqNo(this.reliable.inMsgSeq.getValue());
            this.needAck = 1;
        }
    }

    private void sendAckMessage() {
        this.logger.finest("sendAckMessage:");
        MessageBuffer body = new MessageBuffer();
        MsgHeader header = new MsgHeader(this.outCid, 0L, 16L, 0, false, body);
        try {
            this.sendMessage(header, body);
        }
        catch (CommException e) {
            this.logger.log(Level.FINE, "Sending ACK message caused an exception", e);
        }
    }

    private void sendResendFromRequest() {
        long resendFromMsgSeq = this.reliable.inMsgSeq.nextValue();
        if (resendFromMsgSeq != this.lastResendFrom) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("sendResendFromRequest: " + resendFromMsgSeq + " (" + this.lastResendFrom + ")");
            }
            MessageBuffer body = new MessageBuffer();
            MsgHeader header = new MsgHeader(this.outCid, 0L, 15L, 0, false, body);
            header.setResendFrom(resendFromMsgSeq);
            try {
                this.sendMessageUDP(header, body);
            }
            catch (CommException e) {
                this.logger.log(Level.FINE, "Resend caused an exception", e);
            }
            this.lastResendFrom = resendFromMsgSeq;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receive_handler(MessageBuffer buffer) {
        if (buffer.size() < 23) {
            this.logger.finest("MsgChannelImpl.receive_handler: ignoring message: size=" + buffer.size());
            buffer.close();
            return;
        }
        int version = buffer.getUInt8();
        long msgsize = buffer.getUInt32();
        long msgkey = buffer.getUInt32();
        int flags = buffer.getUInt8();
        int resetseq = buffer.getUInt8();
        long msgseq = buffer.getUInt32();
        int partNo = buffer.getUInt8();
        int ackflags = buffer.getUInt8();
        int resetack = buffer.getUInt8();
        long seqack = buffer.getUInt32();
        int partack = buffer.getUInt8();
        if (version == 5) {
            long connid = buffer.getUInt32();
        }
        if (version != 4 && version != 5) {
            this.logger.finest("MsgChannel: illegal message version: " + version);
            buffer.close();
            return;
        }
        if (this.protoVersion == 254 || this.protoVersion == 5) {
            this.protoVersion = version;
        }
        MsgChannelImpl connid = this;
        synchronized (connid) {
            boolean retrans;
            if ((flags & 0x80) != 0) {
                this.recvResetSequenceMessage(resetseq, msgseq, buffer);
                buffer.close();
                return;
            }
            if (!this.validateMsgSequence(flags, resetseq, msgseq)) {
                buffer.close();
                return;
            }
            if ((flags & 8) != 0) {
                this.processAck(resetack, seqack);
            }
            if ((flags & 0x10) != 0) {
                this.logger.finest("MsgChannel: Got MSG_RESEND - not handled");
                buffer.close();
                return;
            }
            if ((flags & 0x20) != 0) {
                this.processResendFrom(seqack);
                return;
            }
            if (partNo != 255 && (buffer = this.processLongMsg(msgseq, (int)msgsize, partNo, retrans = (flags & 0x40) == 0, buffer)) == null) {
                return;
            }
            this.acceptMsg(flags, resetseq, msgseq);
        }
        if ((flags & 6) == 4) {
            MsgInfo mInfo = new MsgInfo(this.my_endpoint, msgkey, buffer);
            try {
                DialogManager.getInstance().receive_handler(mInfo);
            }
            catch (CommException e) {
                this.logger.log(Level.FINE, "Unexpected exception in receive_handler", e);
            }
        } else {
            this.logger.finest("MsgChannelImpl.receive_handler: got non-dialog message");
            int expectedValue = 0;
            int readPos = 0;
            while (buffer.size() > 0) {
                int readValue = buffer.getUInt8();
                if (readValue != expectedValue) {
                    this.logger.severe("pos=" + readPos + " read: " + readValue + " expected: " + expectedValue);
                    System.exit(1);
                }
                ++readPos;
                if (++expectedValue != 256) continue;
                expectedValue = 0;
            }
            buffer.close();
        }
    }

    private void recvResetSequenceMessage(int resetSeq, long msgSeq, MessageBuffer resetMsg) {
        int resetType = resetMsg.getUInt8();
        TimeVal resetTimeStamp = new TimeVal(resetMsg);
        TimeVal ackTimeStamp = null;
        if (resetMsg.size() > 0) {
            ackTimeStamp = new TimeVal(resetMsg);
        }
        if (resetType == 1) {
            this.procResetSequenceRequest(resetSeq, msgSeq, resetTimeStamp);
        } else {
            this.procResetSequenceAck(resetSeq, msgSeq, resetTimeStamp, ackTimeStamp);
        }
        if (resetMsg.size() > 0) {
            this.udpMsgSize = (int)resetMsg.getUInt32();
            this.fragmentSizeUdp = this.udpMsgSize - 27;
        }
        if (resetMsg.size() > 0) {
            this.outCid = resetMsg.getUInt32();
        }
        if (this.needAck == 1) {
            this.needAck = 2;
        }
    }

    private void procResetSequenceRequest(int resetSeq, long msgSeq, TimeVal resetTimeStamp) {
        if (resetTimeStamp.compareTo(this.lastResetRecv) <= 0) {
            this.logger.finest("procResetSequence: duplicate of RESET_SEQ");
            return;
        }
        if (this.waitForReset) {
            this.logger.finest("procResetSequenceMessage: RESET_SEQUENCE_REQ - handled as RESET_SEQ_ACK");
            this.reliable.inMsgSeq.setValue(msgSeq);
            this.waitForReset = false;
            this.lastResetRecv = resetTimeStamp;
            this.sendQueue.resetTimeOut();
        } else {
            try {
                this.sendResetSeqAck(resetTimeStamp);
            }
            catch (CommException e) {
                this.logger.log(Level.FINE, "reset sequence request caught exception", e);
                return;
            }
            this.unreliable.reset();
            this.reliable.reset();
            this.lastResendFrom = 0L;
            this.reliable.inMsgSeq.setValue(msgSeq);
            this.lastResetRecv = resetTimeStamp;
            ListIterator sendQiter = this.sendQueue.listIterator();
            while (sendQiter.hasNext()) {
                MsgDescr mDes = (MsgDescr)sendQiter.next();
                MsgHeader header = mDes.getMessageHeader();
                long msgSeqNo = this.reliable.getNextOutSeq();
                header.setMsgSeqNo(msgSeqNo);
            }
        }
        if (this.needAck == 1) {
            this.needAck = 2;
        }
    }

    private void procResetSequenceAck(int resetSeq, long msgSeq, TimeVal resetTimeStamp, TimeVal resetAckTimeStamp) {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("MsgChannel: received RESET_ACK: reset time: " + resetTimeStamp.toString() + " ack time: " + resetAckTimeStamp.toString());
        }
        this.reliable.inMsgSeq.setValue(1L);
        this.waitForReset = false;
        if (this.needAck == 1) {
            this.needAck = 2;
        }
    }

    private boolean validateMsgSequence(int msgFlags, int resetSeq, long msgSeq) {
        boolean messageOk = true;
        if (this.waitForReset) {
            this.logger.finest("validateMsgSequence: waiting for RESET_ACK - ignoring message");
            return false;
        }
        if ((msgFlags & 0x40) == 0) {
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest("validateMsgSequence: " + msgSeq + " " + this.reliable.inMsgSeq.nextValue());
            }
            if (msgSeq != this.reliable.inMsgSeq.nextValue()) {
                if (this.reliable.inMsgSeq.compareTo(msgSeq) < 0) {
                    this.logger.finest("validateMsgSequence: message out of sequence");
                    this.sendResendFromRequest();
                } else {
                    if (this.needAck == 1) {
                        this.needAck = 2;
                    }
                    this.logger.finest("validateMsgSequence: duplicate message");
                }
                messageOk = false;
            }
        } else {
            if ((msgFlags & 6) == 0) {
                return true;
            }
            if (this.unreliable.inMsgSeq.compareTo(msgSeq) >= 0) {
                if (this.logger.isLoggable(Level.FINEST)) {
                    this.logger.finest("validateMsgSequence[non-reliable]: duplicate message: inMsgSeq=" + this.unreliable.inMsgSeq.getValue() + " msgSeq=" + msgSeq);
                }
                messageOk = false;
            }
        }
        return messageOk;
    }

    private void processAck(int resetSeqAck, long seqAck) {
        MsgDescr msgDes;
        CInteger seqAckCounter = new CInteger(0xFFFFFFFFL);
        seqAckCounter.setValue(seqAck);
        while (!this.sendQueue.isEmpty() && seqAckCounter.compareTo((msgDes = this.sendQueue.getFirst()).getSequenceNumber()) >= 0) {
            this.sendQueue.removeFirst();
            if (!this.logger.isLoggable(Level.FINEST)) continue;
            this.logger.finest("processAck: releasing message: " + msgDes.getSequenceNumber());
        }
        this.reliable.lastAckRecv.setValue(seqAck);
    }

    private MessageBuffer processLongMsg(long msgSeqNo, int msgSize, int partNo, boolean retrans, MessageBuffer fragment) {
        LongInMsg longMsg = retrans ? this.reliable.longMsg : this.unreliable.longMsg;
        if (longMsg.getSequenceNumber() != msgSeqNo) {
            longMsg.reset();
        }
        boolean complete = longMsg.addMsgFragment(msgSeqNo, msgSize, partNo, fragment);
        MessageBuffer body = null;
        if (complete) {
            body = longMsg.getMessageBody();
        }
        return body;
    }

    private void processResendFrom(long resendFrom) {
        CInteger resendSeqCounter = new CInteger(0xFFFFFFFFL);
        resendSeqCounter.setValue(resendFrom);
        this.processAck(0, resendSeqCounter.prevValue());
        if (this.sendQueue.isEmpty()) {
            this.sendDummyMessage(resendFrom);
        } else {
            ListIterator sendQiter = this.sendQueue.listIterator();
            while (sendQiter.hasNext()) {
                MsgDescr mDes = (MsgDescr)sendQiter.next();
                while (resendSeqCounter.compareTo(mDes.getSequenceNumber()) < 0) {
                    this.sendDummyMessage(resendSeqCounter.getValue());
                    resendSeqCounter.inc();
                }
                this.resendMessage(mDes);
                resendSeqCounter.inc();
            }
        }
    }

    private void acceptMsg(int msgFlags, int resetSeq, long msgSeq) {
        if ((msgFlags & 0x40) == 0) {
            this.reliable.inMsgSeq.setValue(msgSeq);
            this.needAck = 2;
        } else {
            this.unreliable.inMsgSeq.setValue(msgSeq);
        }
    }

    private void resendMessage(MsgDescr mDes) {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("retransmit: " + mDes.getSequenceNumber());
        }
        try {
            this.sendMessageUDP(mDes.getMessageHeader(), mDes.getMessageBody());
        }
        catch (CommException e) {
            this.logger.log(Level.FINE, "resendMessage caught an exception", e);
        }
    }

    private void sendDummyMessage(long seqNo) {
        this.logger.finest("sendDummyMessage: " + seqNo);
        MessageBuffer body = new MessageBuffer();
        MsgHeader header = new MsgHeader(this.outCid, seqNo, 14L, 0, true, body);
        try {
            this.sendMessageUDP(header, body);
        }
        catch (CommException e) {
            this.logger.log(Level.FINE, "MsgChannelImpl.sendDummyMessage: caught CommException", e);
        }
    }

    synchronized void retransmit(long elapsed) {
        if (this.retransmitEnabled.get() && !this.sendQueue.isEmpty()) {
            if (this.sendQueue.timeOut(elapsed)) {
                this.logger.finest("MsgChannelImpl.retransmit: channel: " + this.my_endpoint);
                MsgDescr mDes = this.sendQueue.getFirst();
                long firstMsgSeqNo = mDes.getSequenceNumber();
                if (firstMsgSeqNo != this.reliable.lastAckRecv.nextValue()) {
                    this.sendDummyMessage(this.reliable.lastAckRecv.nextValue());
                } else {
                    this.resendMessage(mDes);
                }
                mDes = this.sendQueue.getLast();
                if (mDes.getSequenceNumber() != firstMsgSeqNo) {
                    this.resendMessage(mDes);
                }
            }
            if (this.needAck == 2) {
                this.needAck = 3;
            } else if (this.needAck == 3) {
                this.sendAckMessage();
                this.needAck = 1;
            }
        }
    }

    public boolean readyForGC() {
        if (!this.inUse) {
            this.inUse = false;
            return true;
        }
        if (this.nOpen == 0) {
            this.inUse = false;
        }
        return false;
    }

    public EndPoint getEndPoint() {
        return this.my_endpoint;
    }

    public long getConnectionId() {
        return this.inCid;
    }

    void disableRetransmit() {
        this.retransmitEnabled.set(false);
    }

    private static class BoolFlag {
        private boolean val = false;

        BoolFlag(boolean val) {
            this.val = val;
        }

        public synchronized boolean get() {
            return this.val;
        }

        public synchronized void set(boolean val) {
            this.val = val;
        }
    }

    static class SendQueue {
        private LinkedList sendQ = new LinkedList();
        private int resendLimit = 0;
        private int timeOutLeft = 0;

        public void addFirst(MsgHeader header, MessageBuffer body) {
            MsgDescr mDes = new MsgDescr(header, body);
            this.resendLimit = 100;
            this.timeOutLeft = 100;
            this.sendQ.addFirst(mDes);
        }

        public void add(MsgHeader header, MessageBuffer body) {
            MsgDescr mDes = new MsgDescr(header, body);
            if (this.isEmpty()) {
                this.resendLimit = 100;
                this.timeOutLeft = 100;
            } else if (this.timeOutLeft > 100) {
                this.timeOutLeft = 100;
            }
            this.sendQ.add(mDes);
        }

        public MsgDescr getFirst() {
            return (MsgDescr)this.sendQ.getFirst();
        }

        public MsgDescr getLast() {
            return (MsgDescr)this.sendQ.getLast();
        }

        public boolean isEmpty() {
            return this.sendQ.isEmpty();
        }

        public ListIterator listIterator() {
            return this.sendQ.listIterator();
        }

        public void removeFirst() {
            this.sendQ.removeFirst();
        }

        public boolean timeOut(long elapsed) {
            boolean timedOut = false;
            this.timeOutLeft = (int)((long)this.timeOutLeft - elapsed);
            if (this.timeOutLeft < 0) {
                this.resendLimit *= 2;
                this.timeOutLeft = this.resendLimit;
                timedOut = true;
            }
            return timedOut;
        }

        public void resetTimeOut() {
            this.resendLimit = 100;
            this.timeOutLeft = 0;
        }
    }

    static class ReliableMsgStream
    extends MsgStream {
        CInteger lastAckRecv = new CInteger(0xFFFFFFFFL);

        ReliableMsgStream() {
        }

        public void reset() {
            super.reset();
            this.lastAckRecv.setValue(0L);
        }
    }

    static class MsgStream {
        private CInteger outMsgSeq = new CInteger(0xFFFFFFFFL);
        CInteger inMsgSeq = new CInteger(0xFFFFFFFFL);
        LongInMsg longMsg = new LongInMsg();

        MsgStream() {
        }

        public void reset() {
            this.outMsgSeq.setValue(0L);
            this.inMsgSeq.setValue(0L);
        }

        long getNextOutSeq() {
            this.outMsgSeq.inc();
            return this.outMsgSeq.getValue();
        }
    }
}

