/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.CommLogFactory;
import com.sun.hadb.comm.MsgManager;
import java.util.logging.Logger;

class MsgRetransmitter
implements Runnable {
    private static final long DEFAULT_INTERVAL = 100L;
    private static final long GC_INTERVAL = 60000L;
    private Logger logger = CommLogFactory.getCommLogger();
    private long interval;
    private MsgManager my_manager;
    private boolean close_flag;

    public MsgRetransmitter(MsgManager manager) {
        this.my_manager = manager;
        this.interval = 100L;
        this.close_flag = false;
    }

    public void close() {
        this.close_flag = true;
    }

    public void setInterval(long interval) {
        if (interval > 0L) {
            this.interval = interval;
        }
    }

    public void run() {
        int timeSinceGarbageCollect = 0;
        this.logger.finest("Retransmission thread started");
        while (!this.close_flag) {
            try {
                Thread.sleep(this.interval);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.my_manager.retransmit(this.interval);
            if ((long)(timeSinceGarbageCollect = (int)((long)timeSinceGarbageCollect + this.interval)) < 60000L) continue;
            this.my_manager.garbageCollect();
            timeSinceGarbageCollect = 0;
        }
        this.logger.finest("Retransmission thread stopped");
    }
}

