/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.CommLogFactory;
import com.sun.hadb.comm.EndPoint;
import com.sun.hadb.comm.MessageBuffer;
import com.sun.hadb.comm.MessageChunkByteArray;
import com.sun.hadb.comm.TimeVal;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PacketDump {
    public static final int MSG_DIRECTION_VOID = 0;
    public static final int MSG_DIRECTION_IN = 1;
    public static final int MSG_DIRECTION_OUT = 2;
    private static Logger logger = CommLogFactory.getCommLogger();

    public static void dumpPacket(byte[] buf) {
        if (logger.isLoggable(Level.FINEST)) {
            PacketDump.dumpPacket(buf, null, 0);
        }
    }

    public static void dumpPacket(byte[] buf, EndPoint endpoint, int direction) {
        if (logger.isLoggable(Level.FINEST)) {
            MessageBuffer buffer = new MessageBuffer();
            MessageChunkByteArray chunk = new MessageChunkByteArray(buf, buf.length);
            buffer.append(chunk);
            StringBuffer sb = new StringBuffer("NET: ");
            if (direction == 1) {
                sb.append("FROM ");
            } else {
                sb.append("TO ");
            }
            sb.append(endpoint.toString());
            logger.finest(sb.toString());
            PacketDump.dumpMessage(buffer, endpoint, direction);
        }
    }

    public static void dumpPacket(ByteBuffer buf, EndPoint endpoint, int direction) {
        if (logger.isLoggable(Level.FINEST)) {
            MessageBuffer buffer = new MessageBuffer();
            int pos = buf.position();
            buf.rewind();
            MessageChunkByteArray chunk = new MessageChunkByteArray(buf);
            buf.position(pos);
            buffer.append(chunk);
            StringBuffer sb = new StringBuffer("NET: ");
            if (direction == 1) {
                sb.append("FROM ");
            } else {
                sb.append("TO ");
            }
            sb.append(endpoint.toString());
            logger.finest(sb.toString());
            PacketDump.dumpMessage(buffer, endpoint, direction);
        }
    }

    private static void dumpMessage(MessageBuffer buffer, EndPoint endPoint, int direction) {
        if (buffer.size() < 23) {
            logger.finest("MSG: Buffer too small. Size=" + buffer.size());
            PacketDump.dumpPayload(buffer);
        } else {
            StringBuffer str = new StringBuffer();
            int version = buffer.getUInt8();
            if (version < 4 || version > 5) {
                logger.finest("MSG: unknown version. no=" + version);
                PacketDump.dumpPayload(buffer);
                return;
            }
            long msgsize = buffer.getUInt32();
            long msgkey = buffer.getUInt32();
            int flags = buffer.getUInt8();
            int resetseq = buffer.getUInt8();
            long msgseq = buffer.getUInt32();
            int partno = buffer.getUInt8();
            int ackflag = buffer.getUInt8();
            int resetseqack = buffer.getUInt8();
            long seqack = buffer.getUInt32();
            int partack = buffer.getUInt8();
            long from = 0L;
            if ((flags & 1) > 0 || version >= 5) {
                from = buffer.getUInt32();
            }
            if ((flags & 1) > 0) {
                str.append("INT ");
            }
            if ((flags & 8) > 0) {
                str.append("ACK ");
            }
            if ((flags & 0x10) > 0) {
                str.append("RESEND ");
            }
            if ((flags & 0x20) > 0) {
                str.append("RESEND_FROM ");
            }
            if ((flags & 0x40) > 0) {
                str.append("NO_RETRANS ");
            }
            if ((flags & 0x80) > 0) {
                str.append("RESET_SEQ ");
            }
            boolean is_dialog = false;
            int payload = flags >> 1 & 3;
            switch (payload) {
                case 0: {
                    break;
                }
                case 1: {
                    str.append("DATA ");
                    break;
                }
                case 2: {
                    str.append("DLG ");
                    is_dialog = true;
                    break;
                }
                case 3: {
                    str.append("STREAM ");
                }
            }
            StringBuffer partNoStr = new StringBuffer();
            if (partno != 255) {
                partNoStr.append(partno);
            } else {
                partNoStr.append("-");
            }
            StringBuffer partAckStr = new StringBuffer();
            if (partack != 255) {
                partAckStr.append(partack);
            } else {
                partAckStr.append("-");
            }
            StringBuffer resetSeqStr = new StringBuffer();
            if ((flags & 0x80) > 0) {
                TimeVal resetTime;
                int resetType = buffer.getUInt8();
                switch (resetType) {
                    case 1: {
                        resetSeqStr.append("RESET_REQ");
                        break;
                    }
                    case 2: {
                        resetSeqStr.append("RESET_ACK");
                        break;
                    }
                    default: {
                        resetSeqStr.append("UNKNOWN");
                    }
                }
                if (resetType == 1 || resetType == 2) {
                    resetTime = new TimeVal(buffer);
                    resetSeqStr.append(resetTime.toString());
                }
                resetTime = null;
                if (buffer.size() >= 8) {
                    resetTime = new TimeVal(buffer);
                }
                if (resetType == 2) {
                    resetSeqStr.append(resetTime.toString());
                }
                if (version >= 5) {
                    long maxUdp = buffer.getUInt32();
                    long cid = buffer.getUInt32();
                    resetSeqStr.append(" udp=");
                    resetSeqStr.append(maxUdp);
                    resetSeqStr.append(" cid=");
                    resetSeqStr.append(cid);
                }
            }
            StringBuffer dirStr = new StringBuffer();
            switch (direction) {
                case 0: {
                    break;
                }
                case 1: {
                    dirStr.append(" <== ");
                    break;
                }
                case 2: {
                    dirStr.append(" ==> ");
                }
            }
            StringBuffer endPointStr = new StringBuffer();
            if (endPoint != null) {
                endPointStr.append(endPoint);
            }
            long cid = 0L;
            if (version >= 5) {
                cid = from;
            }
            StringBuffer sb = new StringBuffer("MSG: ");
            sb.append(version).append(' ');
            sb.append(msgsize).append(' ');
            sb.append(msgkey).append(' ');
            sb.append(str.toString());
            sb.append(" (").append(resetseq).append(' ');
            sb.append(msgseq).append(' ');
            sb.append(partNoStr).append(") ");
            sb.append(ackflag).append(" (");
            sb.append(resetseqack).append(' ');
            sb.append(seqack).append(' ').append(partAckStr).append(") ");
            sb.append(resetSeqStr.toString());
            sb.append(dirStr.toString());
            sb.append(endPointStr.toString());
            if (version >= 5) {
                sb.append(' ').append(cid).append(' ');
            }
            logger.finest(sb.toString());
            if (is_dialog) {
                PacketDump.dumpDialog(buffer);
            } else {
                PacketDump.dumpPayload(buffer);
            }
        }
    }

    private static void dumpDialog(MessageBuffer buffer) {
        if (buffer.size() < 4) {
            logger.finest("DLG: Buffer too small. Size=" + buffer.size());
            PacketDump.dumpPayload(buffer);
            return;
        }
        int dialogid = buffer.getUInt16();
        int round = buffer.getUInt8();
        int flags = buffer.getUInt8();
        StringBuffer str = new StringBuffer();
        if ((flags & 2) != 0) {
            str.append("D_OPEN ");
        }
        if ((flags & 4) != 0) {
            str.append("D_CLOSE ");
        }
        if ((flags & 1) != 0) {
            str.append("D_MASTER ");
        }
        if ((flags & 8) != 0) {
            str.append("D_RETRANS ");
        }
        StringBuffer sb = new StringBuffer();
        sb.append("DLG: dialogid=").append(dialogid).append(" round=").append(round).append(" flags=").append(flags).append(" (").append(str).append(")");
        logger.finest(sb.toString());
        if (buffer.size() == 0) {
            return;
        }
        PacketDump.dumpSep(buffer);
    }

    private static void dumpSep(MessageBuffer buffer) {
        String str;
        if (buffer.size() < 4) {
            logger.finest("SEP: Buffer too small. Size=" + buffer.size());
            PacketDump.dumpPayload(buffer);
            return;
        }
        int comcode = buffer.getUInt8();
        int comtype = buffer.getUInt8();
        int options = buffer.getUInt16();
        StringBuffer line = new StringBuffer();
        line.append("SEP: comcode=");
        PacketDump.dumpByte(line, comcode);
        switch (comcode) {
            case 162: {
                str = " (rpcDataCode) ";
                break;
            }
            case 160: {
                str = " (rpcConnectCode) ";
                break;
            }
            case 161: {
                str = " (rpcConnReplyCode) ";
                break;
            }
            case 163: {
                str = " (rpcCloseCode) ";
                break;
            }
            case 165: {
                str = " (rpcPingCode) ";
                break;
            }
            case 164: {
                str = " (rpcSubServerCode) ";
                break;
            }
            default: {
                str = "";
            }
        }
        line.append(str);
        line.append(" type=");
        PacketDump.dumpByte(line, comtype);
        switch (comtype) {
            default: 
        }
        str = "";
        line.append(" options=" + options + " (");
        if ((options & 1) != 0) {
            line.append("OPT_VAR_HEADER ");
        }
        if ((options & 2) != 0) {
            line.append("OPT_SERVER_LIST ");
        }
        logger.finest(line.toString() + ")");
        if (comcode == 162) {
            PacketDump.dumpRPC(buffer);
        } else {
            PacketDump.dumpPayload(buffer);
        }
    }

    private static void dumpRPC(MessageBuffer buffer) {
        long transno = buffer.getUInt32();
        int msgtype = buffer.getUInt16();
        StringBuffer line = new StringBuffer();
        line.append("RPC: transno=" + transno + " type=");
        if (msgtype == 0) {
            line.append("RPC_CALL");
            int versno = buffer.getUInt16();
            int progversno = buffer.getUInt16();
            int procno = buffer.getUInt16();
            int link = buffer.getUInt16();
            line.append(" versno=" + versno + " prog_versno=" + progversno + " procno=" + procno + " link=" + link);
        } else if (msgtype == 1) {
            line.append("RPC_REPLY");
            long reply = buffer.getUInt32();
            if (reply == 1L) {
                line.append(" Reply=RPC_MSG_OK");
            } else {
                line.append(" Reply=RPC_ERROR code=" + reply);
            }
        } else {
            line.append("RPC_UNKNOWN!");
        }
        logger.finest(line.toString());
        PacketDump.dumpPayload(buffer);
    }

    private static void dumpPayload(MessageBuffer buffer) {
        byte[] arr = new byte[buffer.size()];
        arr = buffer.getBuffer();
        for (int i = 0; i < arr.length; i += 16) {
            int k;
            int j;
            StringBuffer line = new StringBuffer();
            line.append("Payload: ");
            PacketDump.printHex(line, i);
            line.append(" : ");
            for (j = 0; j < 16; ++j) {
                k = i + j;
                if (k >= arr.length) {
                    line.append("  ");
                } else {
                    PacketDump.dumpByte(line, arr[k]);
                }
                line.append(" ");
            }
            line.append(' ');
            for (j = 0; j < 16 && (k = i + j) < arr.length; ++j) {
                PacketDump.dumpChar(line, arr[k]);
            }
            logger.finest(line.toString());
        }
    }

    private static void dumpChar(StringBuffer b, int i) {
        char c = (char)i;
        if (Character.isISOControl(c)) {
            b.append('.');
        } else {
            b.append(c);
        }
    }

    private static void printHex(StringBuffer b, int i) {
        PacketDump.dumpByte(b, i >> 8);
        PacketDump.dumpByte(b, i);
    }

    private static void dumpByte(StringBuffer b, int i) {
        PacketDump.dumpNibble(b, i >> 4);
        PacketDump.dumpNibble(b, i);
    }

    private static void dumpNibble(StringBuffer b, int i) {
        char c;
        switch (i & 0xF) {
            case 0: {
                c = '0';
                break;
            }
            case 1: {
                c = '1';
                break;
            }
            case 2: {
                c = '2';
                break;
            }
            case 3: {
                c = '3';
                break;
            }
            case 4: {
                c = '4';
                break;
            }
            case 5: {
                c = '5';
                break;
            }
            case 6: {
                c = '6';
                break;
            }
            case 7: {
                c = '7';
                break;
            }
            case 8: {
                c = '8';
                break;
            }
            case 9: {
                c = '9';
                break;
            }
            case 10: {
                c = 'A';
                break;
            }
            case 11: {
                c = 'B';
                break;
            }
            case 12: {
                c = 'C';
                break;
            }
            case 13: {
                c = 'D';
                break;
            }
            case 14: {
                c = 'E';
                break;
            }
            case 15: {
                c = 'F';
                break;
            }
            default: {
                c = 'X';
            }
        }
        b.append(c);
    }
}

