/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.MessageBuffer;
import com.sun.hadb.comm.RPCChannel;
import com.sun.hadb.comm.RPCChar;
import com.sun.hadb.comm.RPCType;

public class RPCAttrDescr
implements RPCType {
    private int main;
    private int where;
    private int specs;
    private int addn;
    private int addinfo;
    private int nullinfo;
    private int charset;
    private int spare;
    private RPCChar name = null;
    public static final int T_NULL = 0;
    public static final int T_SMALLINT = 1;
    public static final int T_LONGINT = 2;
    public static final int T_HUGEINT = 3;
    public static final int T_DECIMAL = 4;
    public static final int T_REAL = 5;
    public static final int T_LONGREAL = 6;
    public static final int T_CHAR = 8;
    public static final int T_BYTE = 9;
    public static final int T_BOOLEAN = 10;
    public static final int T_DATETIME = 11;
    public static final int T_INTERVAL = 12;
    public static final int T_BLOB = 13;
    public static final int T_CLOB = 14;
    public static final int T_SPECIAL = 16;
    public static final int T_SEQBGN = 19;
    public static final int T_SEQEND = 17;
    public static final int T_TUPEND = 18;
    public static final int T_GROUP = 21;
    public static final int T_GRITEM = 22;
    public static final int T_NUMEXACT = 4;
    public static final int T_NUMERIC = 7;
    public static final int T_FIELD = 16;
    public static final int T_MAXTYPE = 31;
    public static final int ADD_PRI_KEY = 1;
    public static final int ADD_DUP_KEY = 2;
    public static final int ADD_SEC_KEY = 4;
    public static final int ADD_NULLS = 8;
    public static final int ADD_CHECK = 16;
    public static final int ADD_DEFAULT = 32;
    public static final int ADD_AUTOINCR = 64;
    public static final int ADD_SEQFLD = 128;
    public static final int ADD_READONLY = 256;
    public static final int ADD_WRITEONLY = 512;
    public static final int ADD_CONSTANT = 1024;
    public static final int ADD_VARSIZE = 4096;
    public static final int ADD_BIN_CONST = 8192;
    public static final int ADD_KEYNO_MASK = 255;
    public static final int ADD_FLDNO_MASK = 255;
    public static final int ADD_FLDCNT_MASK = 255;
    public static final int ADD_DISTKEY_MASK = 255;
    public static final int ADD_COUNT_OFFSET = 0;
    public static final int ADD_LOBNO_MASK = 255;
    public static final int DEC_PREC = 63;
    public static final int DEC_SCALE = 63;
    public static final int DEC_SHIFT = 6;
    public static final int SPC_LENGTH = 1023;
    public static final int SPC_TYPE = 3072;
    public static final int SPC_SURRKEY = 0;
    public static final int SPC_LOGSEQNO = 1024;
    public static final int SPC_CHECKSUM = 2048;
    public static final int SPC_UNUSED = 3072;
    public static final int SPC_DT_TYPE = 16128;
    static final int YEAR = 7;
    static final int MONTH = 6;
    static final int DAY = 5;
    static final int HOUR = 4;
    static final int MINUTE = 3;
    static final int SECOND = 2;
    static final int TZHOUR = 1;
    static final int TZMIN = 0;
    static final int SPC_DT_END = 1792;
    static final int SPC_DT_START = 14336;
    static final int SPC_DT_TIMEZONE = 16384;
    static final int SPC_DT_SH_END = 8;
    static final int SPC_DT_SH_START = 11;
    public static final int SPC_DT_TIME = RPCAttrDescr.makeInType(4, 2);
    public static final int SPC_DT_DATE = RPCAttrDescr.makeInType(7, 5);
    public static final int SPC_DT_STAMP = RPCAttrDescr.makeInType(7, 2);
    public static final int SPC_DT_LPREC = 240;
    public static final int SPC_DT_LPSHIFT = 4;
    public static final int INTERVAL_YEAR = 16128;
    public static final int INTERVAL_MONTH = 13824;
    public static final int INTERVAL_DAY = 11520;
    public static final int INTERVAL_HOUR = 9216;
    public static final int INTERVAL_MINUTE = 6912;
    public static final int INTERVAL_SECOND = 4608;
    public static final int INTERVAL_YEAR_TO_MONTH = 15872;
    public static final int INTERVAL_DAY_TO_HOUR = 11264;
    public static final int INTERVAL_DAY_TO_MINUTE = 11008;
    public static final int INTERVAL_DAY_TO_SECOND = 10752;
    public static final int INTERVAL_HOUR_TO_MINUTE = 8960;
    public static final int INTERVAL_HOUR_TO_SECOND = 8704;
    public static final int INTERVAL_MINUTE_TO_SECOND = 6656;

    static int makeInType(int s, int e) {
        return s << 11 | e << 8;
    }

    public int getMain() {
        return this.main;
    }

    public void setMain(int main) {
        this.main = main;
    }

    public int getIntervalLeadingPrecision() {
        return (this.specs & 0xF0) >> 4;
    }

    public int getPrecision() {
        return this.specs & 0x3F;
    }

    public int getScale() {
        return this.specs >> 6 & 0x3F;
    }

    public int getDateTimeType() {
        return this.specs & 0x3F00;
    }

    public boolean isNulls() {
        return (this.addn & 8) != 0;
    }

    public boolean isVarsize() {
        return (this.addn & 0x1000) != 0;
    }

    public boolean isReadOnly() {
        return (this.addn & 0x100) != 0;
    }

    public boolean isWriteOnly() {
        return (this.addn & 0x200) != 0;
    }

    public int getSpecialSubType() {
        return this.specs & 0xC00;
    }

    public int getLength() {
        switch (this.main) {
            case 8: 
            case 9: {
                return this.specs;
            }
            case 16: {
                return this.specs & 0x3FF;
            }
        }
        return 0;
    }

    public String getName() {
        return this.name.getValue();
    }

    public boolean isDate() {
        if (this.main != 11) {
            return false;
        }
        return this.getDateTimeType() == SPC_DT_DATE;
    }

    public boolean isTime() {
        if (this.main != 11) {
            return false;
        }
        return this.getDateTimeType() == SPC_DT_TIME;
    }

    public boolean isTimeStamp() {
        if (this.main != 11) {
            return false;
        }
        return this.getDateTimeType() == SPC_DT_STAMP;
    }

    public boolean hasTimezone() {
        if (this.main != 11) {
            return false;
        }
        return (this.specs & 0x4000) != 0;
    }

    public boolean isLOB() {
        switch (this.main) {
            case 13: 
            case 14: {
                return true;
            }
        }
        return false;
    }

    public void write(MessageBuffer buffer) {
    }

    public void read(MessageBuffer buffer) {
        this.main = RPCChannel.getInt16(buffer);
        this.where = RPCChannel.getInt16(buffer);
        this.specs = RPCChannel.getInt16(buffer);
        this.addn = RPCChannel.getInt16(buffer);
        this.addinfo = RPCChannel.getInt16(buffer);
        this.nullinfo = RPCChannel.getInt16(buffer);
        this.charset = RPCChannel.getInt16(buffer);
        this.spare = RPCChannel.getInt16(buffer);
        int size = buffer.getUInt16();
        this.name = new RPCChar(size);
        this.name.read(buffer);
    }

    public int getAddInfo() {
        return this.addinfo;
    }

    public int getLobNo() {
        return this.getAddInfo() & 0xFF;
    }

    private String specialString() {
        switch (this.getSpecialSubType()) {
            case 0: {
                return "surrkey";
            }
            case 1024: {
                return "logseqno";
            }
            case 2048: {
                return "checksum";
            }
        }
        return "*illegal*";
    }

    private String mainString() {
        switch (this.main) {
            case 0: {
                return "null";
            }
            case 1: {
                return "smallint";
            }
            case 2: {
                return "longint";
            }
            case 3: {
                return "hugeint";
            }
            case 4: {
                return "decimal/" + this.getScale() + "/" + this.getPrecision();
            }
            case 5: {
                return "real";
            }
            case 6: {
                return "longreal";
            }
            case 8: {
                return "char(" + this.getLength() + ")";
            }
            case 9: {
                return "byte(" + this.getLength() + ")";
            }
            case 10: {
                return "boolean";
            }
            case 11: {
                return "datetime/" + Integer.toHexString(this.specs);
            }
            case 12: {
                return "interval/" + Integer.toHexString(this.specs);
            }
            case 13: {
                return "blob";
            }
            case 14: {
                return "clob";
            }
            case 16: {
                return "special." + this.specialString() + "(" + this.getLength() + ")";
            }
            case 19: {
                return "seqbgn";
            }
            case 17: {
                return "seqend";
            }
            case 18: {
                return "tupend";
            }
            case 21: {
                return "group";
            }
            case 22: {
                return "gritem";
            }
        }
        return "*illegal*";
    }

    private String addnString() {
        if (this.addn == 0) {
            return "";
        }
        String r = "";
        if ((this.addn & 0x2000) != 0) {
            r = r + "bin_const|";
        }
        if ((this.addn & 0x1000) != 0) {
            r = r + "varsize|";
        }
        if ((this.addn & 0x400) != 0) {
            r = r + "constant|";
        }
        if ((this.addn & 0x200) != 0) {
            r = r + "writeonly|";
        }
        if ((this.addn & 0x100) != 0) {
            r = r + "readonly|";
        }
        if ((this.addn & 0x80) != 0) {
            r = r + "seqfld|";
        }
        if ((this.addn & 0x40) != 0) {
            r = r + "autoincr|";
        }
        if ((this.addn & 0x20) != 0) {
            r = r + "default|";
        }
        if ((this.addn & 0x10) != 0) {
            r = r + "check|";
        }
        if ((this.addn & 8) != 0) {
            r = r + "nulls|";
        }
        if ((this.addn & 4) != 0) {
            r = r + "sec_key|";
        }
        if ((this.addn & 2) != 0) {
            r = r + "dup_key|";
        }
        if ((this.addn & 1) != 0) {
            r = r + "pri_key|";
        }
        if (r.length() > 0) {
            return r.substring(0, r.length() - 1);
        }
        return "addn=" + Integer.toHexString(this.addn);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("'").append(this.getName()).append("'");
        sb.append(" ").append(this.mainString());
        sb.append(" ").append(this.addnString());
        return sb.toString();
    }
}

