/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.CommException;
import com.sun.hadb.comm.CommLogFactory;
import com.sun.hadb.comm.EndPoint;
import com.sun.hadb.comm.MessageBuffer;
import com.sun.hadb.comm.RPCProcedure;
import com.sun.hadb.comm.RPCResult;
import com.sun.hadb.comm.SepChannel;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RPCChannel {
    public static final int RPC_CALL = 0;
    public static final int RPC_REPLY = 1;
    public static final int RPC_MSG_OK = 1;
    public static final int RPC_LINK = 0;
    public static final int RPC_NOLINK = 1;
    public static final int KVATRO_RPCVERSNO = 23000;
    public static final int RPC_OLD_VERS = 5;
    public static final int RPC_CUR_VERS = 6;
    private SepChannel sep;
    private long transaction_number = 1L;
    private long timeout;
    private int rpc_version = 6;
    private long rpc_trans_no;
    private int rpc_message_type;
    private int rpc_version_no;
    private int rpc_prog_version_no;
    private int rpc_proc_no;
    private long rpc_reply;
    private int rpc_linkstatus;
    private Logger logger = CommLogFactory.getCommLogger();
    private RPCResult reply = null;

    public RPCChannel(EndPoint[] endpoints, long timeout) throws CommException {
        this.sep = new SepChannel(endpoints, timeout);
        if (!this.sep.isReady()) {
            EndPoint ep = this.sep.getEndPoint();
            String epstr = "ep:" + (ep == null ? "null" : ep.toString());
            throw new CommException(12, epstr);
        }
    }

    public synchronized RPCResult execute(RPCProcedure proc, long preTimeout) throws CommException {
        if (this.sep == null) {
            throw new CommException(13, "execute() called on a closed session");
        }
        this.setTimeout(preTimeout);
        RPCResult reply = this.execute(proc);
        this.setTimeout(0L);
        return reply;
    }

    public synchronized RPCResult execute(RPCProcedure proc) throws CommException {
        if (this.sep == null) {
            throw new CommException(13, "execute() called on a closed session");
        }
        MessageBuffer buffer = new MessageBuffer();
        this.writeHeader(buffer, proc.getProcedureNumber());
        proc.write(buffer);
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("Executing RPC procedure no. " + proc.getProcedureNumber());
        }
        this.sep.send(162, 0, 0, null, buffer);
        buffer = this.sep.receive();
        if (buffer == null) {
            throw new CommException(19);
        }
        RPCResult rpc_result = new RPCResult(this.readHeader(buffer), proc.getProcedureNumber());
        rpc_result.read(buffer);
        proc.read(buffer);
        return rpc_result;
    }

    public synchronized void close() {
        if (this.sep != null) {
            this.sep.disconnect();
            this.sep.close();
            this.sep = null;
        }
    }

    private void writeHeader(MessageBuffer buffer, int procno) {
        RPCChannel.appendInt32(buffer, this.transaction_number++);
        RPCChannel.appendInt16(buffer, 0);
        RPCChannel.appendInt16(buffer, 23000);
        RPCChannel.appendInt16(buffer, this.rpc_version);
        RPCChannel.appendInt16(buffer, procno);
        RPCChannel.appendInt16(buffer, 1);
    }

    private long readHeader(MessageBuffer buffer) throws CommException {
        this.rpc_trans_no = RPCChannel.getInt32(buffer);
        this.rpc_message_type = RPCChannel.getInt16(buffer);
        this.rpc_reply = RPCChannel.getInt32(buffer);
        return this.rpc_reply;
    }

    public void setTimeout(long timeout) throws CommException {
        if (this.sep == null) {
            throw new CommException(13, "setTimeout() called on a closed session");
        }
        this.timeout = timeout;
        this.sep.setTimeout(timeout);
    }

    public synchronized void setVersion(long low, long high) throws CommException {
        if (6 <= (int)high && 6 >= (int)low) {
            this.rpc_version = 6;
        } else if (5 <= (int)high && 5 >= (int)low) {
            this.rpc_version = 5;
        } else {
            throw new CommException(20);
        }
    }

    public SepChannel getSepChannel() {
        return this.sep;
    }

    public synchronized int getVersion() {
        return this.rpc_version;
    }

    public static void appendInt16(MessageBuffer buffer, int val) {
        buffer.appendUInt16(val);
    }

    public static void appendInt(MessageBuffer buffer, long val) {
        buffer.appendUInt32(val);
    }

    public static void appendInt32(MessageBuffer buffer, long val) {
        buffer.appendUInt32(val);
    }

    public static int getInt16(MessageBuffer buffer) {
        return buffer.getUInt16();
    }

    public static long getInt(MessageBuffer buffer) {
        return buffer.getUInt32();
    }

    public static long getInt32(MessageBuffer buffer) {
        return buffer.getUInt32();
    }

    public static long getInt64(MessageBuffer buffer) {
        return buffer.getInt64();
    }
}

