/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.MessageBuffer;
import com.sun.hadb.comm.RPCChannel;
import com.sun.hadb.comm.RPCType;

public class RPCExeDescr
implements RPCType {
    private long retparam;
    private long count;
    private long fetched;
    private long eof;
    private long errno;
    private long errlevel;
    private int rpc_version;

    public RPCExeDescr(int rpc_version) {
        this.rpc_version = rpc_version;
    }

    public void write(MessageBuffer buffer) {
    }

    public void read(MessageBuffer buffer) {
        this.retparam = RPCChannel.getInt(buffer);
        this.count = RPCChannel.getInt64(buffer);
        this.fetched = RPCChannel.getInt(buffer);
        this.eof = RPCChannel.getInt(buffer);
        if (this.rpc_version >= 6) {
            this.errno = RPCChannel.getInt32(buffer);
            this.errlevel = RPCChannel.getInt32(buffer);
        }
    }

    public long getErrNo() {
        return this.errno;
    }

    public long getErrLevel() {
        return this.errlevel;
    }

    public int getFetched() {
        return (int)this.fetched;
    }

    public int getCount() {
        return (int)this.count;
    }

    public boolean isEof() {
        return this.eof != 0L;
    }

    public long getRetparam() {
        return this.retparam;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("RPCExe: retparam=0x").append(Long.toHexString(this.retparam)).append(", count=0x").append(Long.toHexString(this.count)).append(", fetched=0x").append(Long.toHexString(this.fetched)).append(", eof=0x").append(Long.toHexString(this.eof));
        if (this.rpc_version >= 6) {
            sb.append(", errno=0x").append(Long.toHexString(this.errno)).append(", errlevel=0x").append(Long.toHexString(this.errlevel));
        }
        return sb.toString();
    }
}

