/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.MessageBuffer;
import com.sun.hadb.comm.RPCChannel;
import com.sun.hadb.comm.RPCExeDescr;
import com.sun.hadb.comm.RPCProcedure;

public class RPCExecuteParams
implements RPCProcedure {
    private int rpc_version;
    private long rmt;
    private MessageBuffer parmbuf;
    private long execount;
    private RPCExeDescr[] exe;

    public RPCExecuteParams(int rpc_version) {
        this.rpc_version = rpc_version;
    }

    public int getProcedureNumber() {
        return 42;
    }

    public void setRemoteTableId(long rmt) {
        this.rmt = rmt;
    }

    public void setParameters(MessageBuffer buffer) {
        this.parmbuf = buffer;
    }

    public void read(MessageBuffer buffer) {
        this.rmt = RPCChannel.getInt32(buffer);
        this.execount = RPCChannel.getInt(buffer);
        if (this.execount > 0L) {
            this.exe = new RPCExeDescr[(int)this.execount];
            for (int i = 0; i < this.exe.length; ++i) {
                this.exe[i] = new RPCExeDescr(this.rpc_version);
                this.exe[i].read(buffer);
            }
        }
        buffer.close();
    }

    public void write(MessageBuffer buffer) {
        RPCChannel.appendInt32(buffer, this.rmt);
        buffer.append(this.parmbuf);
    }

    public int getExeCount() {
        return (int)this.execount;
    }

    public RPCExeDescr getExe(int i) {
        if (this.exe == null) {
            return null;
        }
        return this.exe[i];
    }

    public RPCExeDescr[] getExe() {
        return this.exe;
    }
}

