/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.MessageBuffer;
import com.sun.hadb.comm.RPCChannel;
import com.sun.hadb.comm.RPCChar;

public class RPCStatus {
    private static final int SQL_CODE_LEN = 5;
    public static final int SEV_FIRST = 0;
    public static final int SEV_SUCCESS = 1;
    public static final int SEV_WARNING = 2;
    public static final int SEV_ERROR = 3;
    public static final int SEV_SYSTEMERR = 4;
    public static final int SEV_INTERNERR = 5;
    private long main_status;
    private long severity;
    private long iostat;
    private RPCChar sqlstate = new RPCChar(5);
    private long msglength;
    private RPCChar msgtext;
    private long ioslength;
    private RPCChar iostext;

    public void read(MessageBuffer buffer) {
        this.main_status = RPCChannel.getInt(buffer);
        if (this.main_status != 0L) {
            this.severity = RPCChannel.getInt(buffer);
            this.iostat = RPCChannel.getInt(buffer);
            this.sqlstate.read(buffer);
            this.msglength = RPCChannel.getInt(buffer);
            this.msgtext = new RPCChar((int)this.msglength);
            this.msgtext.read(buffer);
            this.ioslength = RPCChannel.getInt(buffer);
            this.iostext = new RPCChar((int)this.ioslength);
            this.iostext.read(buffer);
        }
    }

    public boolean isError() {
        return this.getMainStatus() != 0L && this.getSeverity() >= 3L;
    }

    public long getMainStatus() {
        return this.main_status;
    }

    public long getSeverity() {
        return this.severity;
    }

    public long getIOStatus() {
        return this.iostat;
    }

    public String getSQLState() {
        return this.sqlstate.getValue();
    }

    public String getErrorMessage() {
        return this.msgtext.getValue();
    }

    public String getIOSText() {
        return this.iostext.getValue();
    }

    public String toString() {
        return "RPCStatus=" + Long.toHexString(this.getMainStatus()) + " sev=" + Long.toHexString(this.getSeverity()) + (this.msgtext != null ? " msg=" + this.msgtext.getValue() : "");
    }

    public void fill(long err) {
        this.main_status = err;
        this.severity = 3L;
        this.iostat = 0L;
        this.sqlstate = new RPCChar(5);
        this.sqlstate.setValue("\u0000");
        this.msglength = 0L;
        this.msgtext = new RPCChar(9);
        this.msgtext.setValue("RPC_ERROR");
        this.ioslength = 0L;
        this.iostext = new RPCChar(25);
        this.iostext.setValue("Errorcode (" + err + ")");
    }
}

