/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.MessageBuffer;
import com.sun.hadb.comm.RPCAttrDescr;
import com.sun.hadb.comm.RPCChannel;
import com.sun.hadb.comm.RPCType;

public class RPCTableTypeDescr
implements RPCType {
    private long id;
    private int fixlen;
    private int keylen;
    private int seqcnt;
    private int strcnt;
    private int keystr;
    private int fixoff;
    private int flobno;
    private int where;
    private int attcnt;
    private int rowcnt;
    private RPCAttrDescr[] att;

    public void write(MessageBuffer buffer) {
    }

    public void read(MessageBuffer buffer) {
        this.id = RPCChannel.getInt(buffer);
        this.fixlen = RPCChannel.getInt16(buffer);
        this.keylen = RPCChannel.getInt16(buffer);
        this.seqcnt = RPCChannel.getInt16(buffer);
        this.strcnt = RPCChannel.getInt16(buffer);
        this.keystr = RPCChannel.getInt16(buffer);
        this.fixoff = RPCChannel.getInt16(buffer);
        this.flobno = RPCChannel.getInt16(buffer);
        this.where = RPCChannel.getInt16(buffer);
        this.attcnt = RPCChannel.getInt16(buffer);
        this.rowcnt = RPCChannel.getInt16(buffer);
        this.att = new RPCAttrDescr[this.rowcnt];
        for (int i = 0; i < this.rowcnt; ++i) {
            this.att[i] = new RPCAttrDescr();
            this.att[i].read(buffer);
        }
    }

    public RPCAttrDescr getRPCAttrDescr(int index) {
        return this.att == null ? null : this.att[index];
    }

    public int getRowcnt() {
        return this.rowcnt;
    }

    public int getAttcnt() {
        return this.attcnt;
    }

    public int getLobNo() {
        return this.flobno;
    }

    public boolean hasLob() {
        return this.getLobNo() != 65535;
    }

    public int getLobCount() {
        int count = 0;
        if (this.hasLob()) {
            for (int i = 0; i < this.getAttcnt(); ++i) {
                RPCAttrDescr ad = this.getRPCAttrDescr(i);
                if (!ad.isLOB()) continue;
                ++count;
            }
        }
        return count;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("RPCTableTypeDescr id=").append(this.id);
        sb.append(", keylen=").append(this.keylen);
        sb.append(", attcnt=").append(this.getAttcnt());
        sb.append(", flobno=").append(this.getLobNo());
        for (int i = 0; i < this.getAttcnt(); ++i) {
            sb.append("\n ").append(i).append(": ").append(this.att[i]);
        }
        return sb.toString();
    }

    static void main(String[] arg) {
        if (arg.length < 1) {
            System.err.println("Usage: java com.sun.hadb.RPCTableTypeDescr <ttdfile1> <ttdfile2> .....");
        } else {
            for (int i = 0; i < arg.length; ++i) {
                try {
                    MessageBuffer buf = new MessageBuffer(arg[i]);
                    System.out.println("-------------- " + arg[i] + " -----------------");
                    RPCTableTypeDescr ttd = new RPCTableTypeDescr();
                    ttd.read(buf);
                    System.out.println(ttd.toString());
                    continue;
                }
                catch (Exception e) {
                    System.out.println(e.toString());
                    e.printStackTrace();
                    return;
                }
            }
        }
    }
}

