/*
 * Decompiled with CFR 0.152.
 */
package com.sun.hadb.comm;

import com.sun.hadb.comm.MessageBuffer;
import com.sun.hadb.comm.RPCVarChar;

public class RPCTrimChar
extends RPCVarChar {
    private int size;

    public RPCTrimChar(int size) {
        this.size = size;
    }

    public void setValue(String val) {
        this.value = val.trim();
    }

    public String getValue() {
        int len = this.value.length();
        if (len > this.size) {
            return this.value.substring(0, this.size);
        }
        StringBuffer b = new StringBuffer(this.value);
        for (int i = len; i < this.size; ++i) {
            b.append(' ');
        }
        return b.toString();
    }

    public void write(MessageBuffer buffer) {
        int len = this.value.length();
        if (len > this.size) {
            len = this.size;
        }
        buffer.appendUInt16(len);
        byte[] arr = this.value.getBytes();
        for (int i = 0; i < len; ++i) {
            buffer.appendUInt8(arr[i]);
        }
        if (len % 2 != 0) {
            buffer.appendUInt8(32);
        }
    }
}

